/*! phoscon-app 2025-05-20 */

"use strict";function checkAppType(){const ip=new RegExp("\\b(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\b");let appType="APP_LOCAL";return location.href&&ip.test(location.href)?appType=window.webkit&&window.webkit.messageHandlers&&window.webkit.messageHandlers.IOs?"APP_SMARTPHONE":"APP_LOCAL":location.href&&-1!==location.href.indexOf("phoscon.de")?appType="APP_ONLINE":location.href&&-1!==location.href.indexOf("androidplatform")&&(appType="APP_SMARTPHONE"),appType}function iOS(){return["iPad Simulator","iPhone Simulator","iPod Simulator","iPad","iPhone","iPod"].includes(navigator.platform)||navigator.userAgent.includes("Mac")&&"ontouchend"in document}let MAX_SUB_WORKERS=3;"ontouchstart"in document.documentElement&&(MAX_SUB_WORKERS=1);const Gateway=Backbone.Model.extend({url:function(){let url="//"+this.get("ip")+(":"+this.get("port")||"")+"/api";return this.has("apikey")?url+="/"+this.get("apikey"):url+="/config",url},sync:function(method,model,options){return Backbone.sync(method,model,options)}});function addGateway(gw){var g=app.gateways.get(gw.id);if(g){if(console.log("dont add gw",gw.id),!g.has("lastseen")){let t=Date.now();g.set({lastseen:t})}}else gw.lastseen||(gw.lastseen=Date.now()),app.gateways.add([gw])}function checkAuth(gwid,gw){return new Promise((resolve,reject)=>{gw||reject("Parameter missing, gw"),gw.has("apikey")||resolve({substate:"login"});let url=gw.get("ip");Number.isInteger(Number.parseInt(gw.get("port"),10))&&(url+=":"+gw.get("port")),sessionStorage.setItem("app.gw",url),sessionStorage.setItem("app.gwid",gwid),restGetResource(gw).then(result=>{resolve({substate:"",id:result})}).catch(err=>{403===err.status&&gw.has("apikey")&&(console.log("invalid api key, remove"),gw.unset("apikey")),resolve({substate:"login"})})})}function getOwnIPs(){const result=[],RTCPeerConnection=window.RTCPeerConnection||window.mozRTCPeerConnection||window.webkitRTCPeerConnection;return new Promise((resolve,reject)=>{if(!RTCPeerConnection)return void resolve([]);const config={};try{const pc=new RTCPeerConnection(config);pc.onicecandidate=(ice=>{if(!ice.candidate)return;const ipAddr=/([0-9]{1,3}(\.[0-9]{1,3}){3}|[a-f0-9]{1,4}(:[a-f0-9]{1,4}){7})/.exec(ice.candidate.candidate)||[];ipAddr.length<2||result.find(ip=>ip===ipAddr[1])||result.push(ipAddr[1])}),pc.createDataChannel(""),pc.createOffer().then(offer=>pc.setLocalDescription(offer)).then(()=>setTimeout(()=>resolve(result),200)).catch(reject)}catch(e){reject(e)}})}function searchGateways(){app.probeWorker.postMessage({scan:!0}),app.scanActive||(app.scanIteration++,app.dbgInfo.innerHTML="",app.scanActive=!0,app.scanProgress=0,app.subnets=[],app.progressTotal=0,app.progressDone=0,app.progressBar.style.width="1%",getOwnIPs().then(res=>{(res=res.filter(ip=>ip.match(/^(192\.168\.|10\.|172\.(1[6-9]|2\d|3[01]))/))).forEach(ip=>addSubnet(ip))}).catch(console.log).then(()=>{app.probeWorker.postMessage({t:"check-subnets"})}))}function stopSearchGateways(){app.scanActive&&(app.dbgInfo.innerHTML="",app.probeWorker.postMessage({scan:!1}),app.subWorkers=[],app.subnetsToCheck=[],app.scanActive=!1,document.body.classList.remove("scan-active"))}function toggleScanner(){app.scanActive?stopSearchGateways():searchGateways(),app.probeWorker.postMessage({scan:!app.scanActive})}app.GatewayCollection=Backbone.Collection.extend({model:Gateway}),app.gateways=new app.GatewayCollection;var appCacheStatus=["uncached","idle","checking","downloading","updateready","obsolete"];function onWorkerMessage(e){if("t"in e.data){if("found"===e.data.t)app.probeWorker.postMessage({add:[e.data.gw.ip]}),app.probeWorker.postMessage({scan:!0});else if("progress"===e.data.t){var w=app.subWorkers.find(x=>x.worker===this);if(w){w.done=e.data.progress[0],w.total=e.data.progress[1];var percent=Math.round(w.done/254*100);w.elProgress.innerHTML=percent+"&thinsp;%",updateProgress()}app.scanActive||this.terminate()}else console.log("sub",e.data);"scan"===e.data.t&&"done"===e.data.scan&&(console.log("sub",e.data),this.terminate(),app.subWorkers=app.subWorkers.filter(w=>w.worker!==this),app.progressDone+=254,updateProgress(),setTimeout(updateWorkerTasks,100))}}function updateWorkerTasks(){if(!app.scanActive)return;if(app.subWorkers.length>=MAX_SUB_WORKERS)return;var net=app.subnetsToCheck.shift();if(!net)return;let w=new Worker(window.URL.createObjectURL(app.scannerWorkerBlob));w.onmessage=onWorkerMessage,w.postMessage({scan:!0,list:[net]});var el=document.createElement("span");el.classList.add("subnet"),el.innerHTML="<b>"+net+"</b> <i>0</i>";var elProgress=el.querySelector("i");app.dbgInfo.appendChild(el),app.subWorkers.push({worker:w,total:254,progress:0,subnet:net,el:el,elProgress:elProgress})}function updateProgress(){app.rafProgress||(app.rafProgress=requestAnimationFrame(function(){app.rafProgress=null;var done=app.progressDone,progress=0;app.subWorkers.forEach(w=>{w.done&&(done+=w.done)}),0===app.subWorkers.length&&0===app.subnetsToCheck.length?(progress=1,stopSearchGateways()):app.progressTotal&&done&&(progress=done/app.progressTotal),progress<app.scanProgress?progress=app.scanProgress:app.scanProgress=progress,progress<0?progress=0:progress>1&&(progress=1),app.progressBar.style.width=100*progress+"%"}))}function addSubnet(subnet){if(!subnet.match(/^(192\.168\.|10\.|172\.(1[6-9]|2\d|3[01]))/))return;let prefix=subnet.split(".").splice(0,3).join(".");app.subnets.find(x=>0===x.indexOf(prefix))||app.scanActive&&(app.progressTotal+=254,app.subnets.push(subnet),app.subnetsToCheck.push(subnet),setTimeout(updateWorkerTasks,100))}function isIPv4(host){return host&&null!==host.match(/^\d{1,3}\.\d{1,3}\.\d{1,3}.\d{1,3}$/)}window.onbeforeunload=function(){app.probeWorker&&app.probeWorker.terminate()},window.onload=function(){if("APP_SMARTPHONE"===checkAppType())return;app.scannerWorkerBlob=new Blob(Array.prototype.map.call(document.querySelectorAll("script[type='text/js-worker']"),function(oScript){return oScript.textContent}),{type:"text/javascript"});let appDate=document.querySelector("meta[data-generated]");if(appDate&&(appDate=appDate.getAttribute("data-generated"),appDate=encodeURIComponent(appDate)),app.probeWorker=new Worker(window.URL.createObjectURL(app.scannerWorkerBlob)),app.scanActive=!1,app.scanIteration=0,app.subWorkers=[],app.subnets=[],app.subnetsToCheck=[],app.dbgInfo=document.querySelector("#dbg-info"),app.probeWorker.onerror=function(e){console.log("Worker error"),console.log(e)},app.probeWorker.onmessageerror=function(){console.log("Worker message error")},app.probeWorker.onmessage=function(e){if("found"===e.data.t&&e.data.gw){let json=e.data.gw;var gw=app.gateways.get(json.bridgeid);if(gw)json.ip!==gw.get("ip")&&(isIPv4(gw.get("ip"))||(json.ip=gw.get("ip"))),gw.set(json),gw.has("port")&&!json.port&&gw.unset("port");else{if(addGateway(json),!(gw=app.gateways.get(json.bridgeid)))return;localStorage.setItem("app.gateways",JSON.stringify(app.gateways.toJSON()))}let t=Date.now();gw.set({lastseen:t}),gw.has("apikey")&&checkAuth(gw).catch(err=>{localStorage.setItem("app.gateways",JSON.stringify(app.gateways.toJSON())),app.Devicetype.sendMessage("GATEWAYS_DATA",JSON.stringify(app.gateways.toJSON())),console.log(err)})}else"scan"===e.data.t||("subnet"===e.data.t?addSubnet(e.data.subnet):"progress"===e.data.t||("state"===e.data.t?(e.data.state,app.scanActive||app.subWorkers.length>0||document.body.classList.remove("scan-active")):console.log(e.data)))},setTimeout(()=>{fetch(`${location.origin}${getUrlPrefix()}/api/config`).then(rsp=>rsp.json()).then(console.log).catch(err=>{0===app.gateways.length?searchGateways():console.log("skip intial search, already have reachable gateways")})},1500),-1!==document.location.hash.indexOf("nocache"))return;let cache=localStorage.getItem("app.gateways");if(cache){let ips=[],unique=[];const maxAge=6048e5;try{cache=JSON.parse(cache)||[]}catch(err){cache=[]}cache.forEach(gw=>{gw.reachable=!1,gw.id&&0!==parseInt(gw.id,16)&&gw.lastseen&&(gw.lastseen&&Date.now()-gw.lastseen>maxAge||(gw.ip&&ips.push(gw.ip),unique.find(x=>x.id===gw.id)||(unique.push(gw),addGateway(gw))))}),ips.length>0&&(app.probeWorker.postMessage({add:ips}),app.probeWorker.postMessage({scan:!0}))}var host=document.location.hostname;(host.match(/^(192\.168\.|10\.|172\.(1[6-9]|2\d|3[01]))/)||-1===host.indexOf(".de"))&&(host=document.location.host,app.probeWorker.postMessage({add:[host]}),getUrlPrefix().length>0&&app.probeWorker.postMessage({add:[host+getUrlPrefix()]}),app.probeWorker.postMessage({scan:!0})),getOwnIPs().then(res=>{res=res.filter(ip=>ip.match(/^(192\.168\.|10\.|172\.(1[6-9]|2\d|3[01]))/)),app.probeWorker.postMessage({add:res}),app.probeWorker.postMessage({scan:!0})}).catch(console.log)};