/*! phoscon-app 2025-05-20 */

function drawSunState(parentContainer,sunstate,sunstatePoint,sunstateName,rota){var sunState_data,labelPoint,dayTime=sunstate.split("T");dayTime=(dayTime=dayTime[1]).split(":"),"sunrise"==sunstateName?(sunState_data=[[sunstatePoint.x,sunstatePoint.y],[sunstatePoint.x,sunstatePoint.y+100]],labelPoint={textPos:{x:sunstatePoint.x+80,y:sunstatePoint.y-40},timePos:{x:sunstatePoint.x,y:sunstatePoint.y+75}}):"sunset"==sunstateName&&(sunState_data=[[sunstatePoint.x,sunstatePoint.y],[sunstatePoint.x,sunstatePoint.y+100]],labelPoint={textPos:{x:sunstatePoint.x-140,y:sunstatePoint.y-40},timePos:{x:sunstatePoint.x,y:sunstatePoint.y+75}});var sunstate_pathString=d3.line()(sunState_data)+"l-12.7383,0z";d3.select(parentContainer).append("g").attr("style","display: none;").attr("id",sunstateName+"-g"),d3.select("#"+sunstateName+"-g").append("path").attr("id",sunstateName+"-line").attr("d",sunstate_pathString).attr("class","sunref1");var ico=$("#"+sunstateName+"-icon").clone();ico.attr("id","sundial"+sunstateName+"-icon"),ico.attr("transform","translate("+labelPoint.textPos.x+" "+labelPoint.textPos.y+")"),ico.appendTo("#"+sunstateName+"-g");var line=document.querySelector("#"+sunstateName+"-line");TweenLite.set(line,{transformOrigin:"top",rotation:rota+"_deg"})}function drawMarker(markerPoint,parentContainer,nr){var point=markerPoint.point,data=[[point.x,point.y],[point.x,point.y+10]],pathString=d3.line()(data);d3.select(parentContainer).append("g").attr("id","Marker-"+nr),d3.select("#Marker-"+nr).append("path").attr("id","Line-"+nr).attr("d",pathString).attr("class","marker");var marker=document.querySelector("#Marker-"+nr);if(TweenLite.set(marker,{transformOrigin:"top",rotation:markerPoint.rotation+"_deg"}),nr%6==0){d3.select("#Marker-"+nr).append("text").attr("id","Marker-Text-"+nr).attr("x",data[1][0]).attr("y",data[1][1]+15).append("tspan").text(nr).attr("class","marker-text").append("tspan").attr("baseline-shift","super").text("00").attr("class","marker-text-super");var markerText=document.querySelector("#Marker-Text-"+nr);TweenLite.set(markerText,{transformOrigin:"center",rotation:-markerPoint.rotation+"_deg"})}}function getPointOnPath(path,angle){var vhtn=1-100/(360/angle)/100,pathLength=path.getTotalLength()||0,splitPoint=Math.round(pathLength*vhtn),starti=path.getPointAtLength(splitPoint);return starti=closestPoint(path,pathLength,starti)}function getRotation(p1,p2){var dx=p2.x-p1.x,dy=p2.y-p1.y;return Math.atan2(dy,dx)}const DEG=180/Math.PI;function getDistance(point1,point2){var xs=0,ys=0;return xs=point2.x-point1.x,xs*=xs,ys=point2.y-point1.y,ys*=ys,Math.sqrt(xs+ys)}function closestPoint(pathNode,pathLength,point){var best,bestLength,precision=8,bestDistance=1/0;for(let scan,scanDistance,scanLength=0;scanLength<=pathLength;scanLength+=precision)(scanDistance=distance2(scan=pathNode.getPointAtLength(scanLength)))<bestDistance&&(best=scan,bestLength=scanLength,bestDistance=scanDistance);for(precision/=2;precision>.7;){var before,after,beforeLength,afterLength,beforeDistance,afterDistance;(beforeLength=bestLength-precision)>=0&&(beforeDistance=distance2(before=pathNode.getPointAtLength(beforeLength)))<bestDistance?(best=before,bestLength=beforeLength,bestDistance=beforeDistance):(afterLength=bestLength+precision)<=pathLength&&(afterDistance=distance2(after=pathNode.getPointAtLength(afterLength)))<bestDistance?(best=after,bestLength=afterLength,bestDistance=afterDistance):precision/=2}var len2=bestLength+(bestLength===pathLength?-.1:.1);return{point:best,rotation:getRotation(best,pathNode.getPointAtLength(len2))*DEG};function distance2(p){var dx=p.x-point.x,dy=p.y-point.y;return dx*dx+dy*dy}}function localTimeISOString(date){return date.getFullYear()+"-"+pad(date.getMonth()+1)+"-"+pad(date.getDate())+"T"+pad(date.getHours())+":"+pad(date.getMinutes())+":"+pad(date.getSeconds());function pad(number){return number<10?"0"+number:number}}function getBorders(drag,draggable_Collection){var start,stop,self=draggable_Collection.indexOf(drag);if(draggable_Collection.length<3)start=draggable_Collection[draggable_Collection.length-self-1],stop=draggable_Collection[draggable_Collection.length-self-1];else if(0!=self&&self!=draggable_Collection.length-1)start=draggable_Collection[self-1],stop=draggable_Collection[self+1];else if(0==self){start=draggable_Collection[draggable_Collection.length-1],stop=draggable_Collection[self+1]}else self==draggable_Collection.length-1&&(start=draggable_Collection[self-1],stop=draggable_Collection[0]);return{start:start,stop:stop}}function getCircleAngle(p1,p2){var angle,angleDeg=360*Math.atan2(p2.y-p1.y,p2.x-p1.x)/Math.PI;-1==Math.sign(angleDeg)?angle=180+(angleDeg+180):angle=angleDeg;return angle}function getMiddelAngle(angle1,angle2){var dist=0;return angle1>angle2?(tillZero=360-angle1,(dist=(tillZero+angle2)/2)>tillZero?angle2-dist:angle1+dist):angle1+(angle2-angle1)/2}function generatePoint(path,angle,pathLength){var vhtn=1-100/(360/angle)/100,splitPoint=Math.round(pathLength*vhtn);return path.getPointAtLength(splitPoint)}function calcCirclePath2(points){var a=points[0].pos,b=points[2].pos,c=points[1].pos,A=dist(b,c),B=dist(c,a),C=dist(a,b),angle=Math.acos((A*A+B*B-C*C)/(2*A*B)),r=A*B*C/4/(.5*A*B*Math.sin(angle));r=Math.round(1e3*r)/1e3;Math.PI,b[0],a[0],c[1],a[1],b[1],a[1],c[0],a[0];return-1!=["M",a,"A",r,r,0,0,1,c,r,r,0,0,1,b].join(" ").search("NaN")?"":["M",a,"A",r,r,0,0,1,c,r,r,0,0,1,b].join(" ")}function dist(a,b){return Math.sqrt(Math.pow(a[0]-b[0],2)+Math.pow(a[1]-b[1],2))}function getSegmentColorByClassId(segclass){switch(segclass){case 20204:return"#6a747cff";case 20202:return"#f7eacfff";case 20203:return"#b0a192ff";case 20201:return"#d5c6afff"}}function ColorLuminance(hex,lum){(hex=String(hex).replace(/[^0-9a-f]/gi,"")).length<6&&(hex=hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2]),lum=lum||0;var c,i,rgbHex="#";for(i=0;i<3;i++)c=parseInt(hex.substr(2*i,2),16),rgbHex+=("00"+(c=Math.round(Math.min(Math.max(0,c+c*lum),255)).toString(16))).substr(c.length);return rgbHex}function calcTimeString(angle,timeformat){var angleMinutes=1440*angle/360,angleHours=parseInt(angleMinutes/60)%timeformat;return"00"==angleHours&&12==timeformat&&(angleHours=12),twoDigits(angleHours)+":"+twoDigits(parseInt(angleMinutes%60))}function convertTimeformat(time,timeformat){let ts,h,m,a;return 12==timeformat?(a=(ts=time.split(":"))[0]>12?"pm":"am",(h=ts[0]%12)+":"+(m=ts[1])+" "+a):24==timeformat?time:void 0}function generateLineColor(value){let res="";switch(value%17){case 0:res="#9A77CF";break;case 1:res="#3a0ca3";break;case 2:res="#262245";break;case 3:res="#A13670";break;case 4:res="#026178";break;case 5:res="#34A1C7";break;case 6:res="#FB8986";break;case 7:res="#651B40";break;case 8:res="#543684";break;case 9:res="#f3722c";break;case 10:res="#f8961e";break;case 11:res="#f9c74f";break;case 12:res="#43aa8b";break;case 13:res="#b08968";break;case 14:res="#606c38";break;case 15:res="#cdb4db";break;case 16:res="#7b2cbf";break;case 17:res="#3a0ca3"}return res}function getTimeAttachment(angle,timeformat){return 24==timeformat?translate("text_24h_attach"):12==timeformat?parseInt(1440*angle/360/60)<=11?translate("text_12h_am_attach"):translate("text_12h_pm_attach"):void 0}function twoDigits(number){return number<0?Math.abs(number)<10?"0"+Math.abs(number):Math.abs(number):(number<10?"0":"")+number}function minutesToHours(n){var num=Math.abs(n),hours=num/60<1?0:num/60,rhours=Math.floor(hours),minutes=0==hours?num:60*(hours-rhours),rminutes=Math.round(minutes);return twoDigits(rhours)+":"+twoDigits(rminutes)}function getSegmentModel(context,start_id,stop_id){var resToChange,dragNr=stop_id.split("drag")[1],seg_clicked=[start_id.split("drag")[1],dragNr],segStack=[];context.SegmentCol.forEach(function(elem){var seg=[];elem.attributes.links.forEach(function(link){var linkNr=link.split("/");linkNr=linkNr[linkNr.length-1],seg.push(linkNr)}),segStack.push(seg)});for(var j=0;j<segStack.length;j++)JSON.stringify(seg_clicked)==JSON.stringify(segStack[j])&&(resToChange=context.SegmentCol.at(j));return resToChange}function getInfoObjects(controlToControl){return new Promise((resolve,reject)=>{restGetResource(app.rules).then(rsp=>{var segStatus=new DialStatusSensor({name:"DialSeg_STATE_"+controlToControl.get("name"),uniqueid:uuidv4()});restCreateResource(app.sensors,segStatus).then(rsp=>{segStatus.set("id",rsp),resolve({rulesCol:app.rules,status:segStatus})}).catch(err=>{reject({rulesCol:app.rules,status:err})})}).catch(err=>{reject({rulesCol:err,status:null})})})}function arrayUnique(array){for(var a=array.concat(),i=0;i<a.length;++i)for(var j=i+1;j<a.length;++j)a[i]===a[j]&&a.splice(j--,1);return a}function getHdcModel(controllCollection,elem){var control=null;for(let conCount=0;conCount<controllCollection.length;conCount++){var controlLinks=controllCollection.at(conCount).get("links");for(let linkCount=0;linkCount<controlLinks.length;linkCount++){controlLinks[linkCount]=="/resourcelinks/"+elem.get("id")&&(control=controllCollection.at(conCount))}}return control}function genDefName(){return"Offset Ref P"+Math.round(100*Math.random()).toString(3)}function genDefModelId(){return"DLOFFSET"+Math.round(100*Math.random()).toString(3)}function genDefOffset(){return Math.round(180-100*Math.random())*(2*Math.round(Math.random())-1)}function genDefAngle(){return 1e3*Math.random()%360}function calcConfig(context,dlOffsetPoint){var offsetMinutes,config=dlOffsetPoint.config;if("sunset"==config.mode){var timevar=new Date(context.SunStates.get("sunset"));offsetMinutes=1440*dlOffsetPoint.angle/360,offsetMinutes=(new Date(timevar.getFullYear(),timevar.getMonth(),timevar.getDate(),offsetMinutes/60,offsetMinutes%60)-timevar)/6e4,config.offset=parseInt(offsetMinutes)}else if("sunrise"==config.mode){timevar=new Date(context.SunStates.get("sunrise"));offsetMinutes=1440*dlOffsetPointangle/360,offsetMinutes=(new Date(timevar.getFullYear(),timevar.getMonth(),timevar.getDate(),offsetMinutes/60,offsetMinutes%60)-timevar)/6e4,config.offset=parseInt(offsetMinutes)}return config}function GenDefaultData(context,angle,name=genDefName(),model_id=genDefModelId(),dlOffset=genDefOffset()){var default_data={name:name,type:"CLIPDaylightOffset",manufacturername:"Phoscon",modelid:model_id,swversion:"1.0",uniqueid:uuidv4(),config:{on:!0,mode:"sunset",offset:dlOffset}};return void 0!=angle&&(default_data.angle=angle,default_data.config=calcConfig(context,default_data),delete default_data.angle),default_data}function hashCode(s){return s.split("").reduce((a,b)=>(a=(a<<5)-a+b.charCodeAt(0))&a,0).toString(16)}function checkSegmentResources(context,d1,d2){return new Promise((resolve,reject)=>{var segStack=[];context.SegmentCol.forEach(function(elem){var seg=[];elem.attributes.links.forEach(function(link){var linkNr=link.split("/");linkNr=linkNr[linkNr.length-1],seg.push(linkNr)}),segStack.push(seg)});for(var seg=[d1.id.split("drag")[1],d2.id.split("drag")[1]],dr=!1,j=0;j<segStack.length;j++)JSON.stringify(seg)==JSON.stringify(segStack[j])&&(dr=!0);if(!dr){var segClass,sen1="/sensors/"+seg[0],sen2="/sensors/"+seg[1],sen1Model=context.OffsetCol.get(seg[0]),sen2Model=context.OffsetCol.get(seg[1]),sen1Index=(parseInt(sen2Model.get("angle")),parseInt(sen1Model.get("angle")),context.OffsetCol.indexOf(sen1Model)),sen2Index=context.OffsetCol.indexOf(sen2Model);if(0==sen1Index&&1==sen2Index)var SegName=hashCode("Morgens-"+seg[0]+"-"+seg[1]);else if(1==sen1Index&&2==sen2Index)SegName=hashCode("Tagsüber"+seg[0]+"-"+seg[1]);else if(2==sen1Index&&3==sen2Index)SegName=hashCode("Abends"+seg[0]+"-"+seg[1]);else if(3==sen1Index&&0==sen2Index)SegName=hashCode("Nachts"+seg[0]+"-"+seg[1]);switch(SegName){case hashCode("Morgens-"+seg[0]+"-"+seg[1]):segClass=20201;break;case hashCode("Tagsüber"+seg[0]+"-"+seg[1]):segClass=20202;break;case hashCode("Abends"+seg[0]+"-"+seg[1]):segClass=20203;break;case hashCode("Nachts"+seg[0]+"-"+seg[1]):segClass=20204}var data={name:SegName,description:"Segment "+sen1+" to  "+sen2,classid:segClass,links:[sen1,sen2]};restCreateResource(context.SegmentCol,data).then(rsp=>{resolve(rsp)}).catch(err=>{reject(err)})}resolve(0)})}function checkForDialControl(controllCollection,elem){var control=null;for(let conCount=0;conCount<controllCollection.length;conCount++){var controlLinks=controllCollection.at(conCount).get("links");for(let linkCount=0;linkCount<controlLinks.length;linkCount++){controlLinks[linkCount]=="/resourcelinks/"+elem.get("id")&&(control=controllCollection.at(conCount))}}return control}function createRulesForSegment2(startRes,segmentStatusSenId,activeSegClasses,segment,startOffset,endOffset){var allRules=[];let segsenStatus,ruleStatus="";if(activeSegClasses.includes(segment.get("classid"))){ruleStatus="enabled",segsenStatus=1;var segStatusCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:"1"}}else{ruleStatus="disabled",segsenStatus=-1;segStatusCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"gt",value:"-1"}}if(startOffset.get("angle")<endOffset.get("angle")){var Rule1Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+startOffset.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},{address:"/sensors/"+endOffset.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},segStatusCondition],actions:[ruleControlAction={address:startRes,body:{status:ruleStatus},method:"PUT"},trackStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:segsenStatus},method:"PUT"}],name:"pir-"+startRes.split("/")[2]+"ResControl-at-"+segment.get("name")};allRules.push(Rule1Data)}else{var ruleControlAction,trackStatusAction;Rule1Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+startOffset.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},{address:"/sensors/"+endOffset.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},segStatusCondition],actions:[ruleControlAction={address:startRes,body:{status:ruleStatus},method:"PUT"},trackStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:segsenStatus},method:"PUT"}],name:"pir-"+startRes.split("/")[2]+"ResControl-at-"+segment.get("name")};allRules.push(Rule1Data);var Rule2Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+startOffset.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},{address:"/sensors/"+endOffset.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},segStatusCondition],actions:[ruleControlAction,trackStatusAction],name:"pir-"+startRes.split("/")[2]+"ResControl-at-"+segment.get("name")};allRules.push(Rule2Data)}return allRules}function createAutomationSegmentRuling(hdcModel,controlToControl,activeSegments){return console.log("Create automation segment ruling"),new Promise((resolve,reject)=>{var allRules,segmentStatus,segmentresources=[],activeSegClasses=[];activeSegments.forEach(segment=>{activeSegClasses.push(segment.get("classid")),segmentresources.push("/resourcelinks/"+segment.get("id"))}),getInfoObjects(controlToControl).then(rsp=>{var allPromises=[];allRules=rsp.rulesCol,segmentStatus=rsp.status;var startRes,startRule,startRuleStatus,currentTime=new Date,segmentStatusSenId=segmentStatus.get("id");{if(segmentresources.push("/sensors/"+segmentStatusSenId),allRules.where({name:"pir-fsm-state-start"}).forEach(rule=>{controlToControl.get("links").filter(link=>link.includes("rules")).forEach(pirRule=>{parseInt(pirRule.split("/")[2])==rule.get("id")&&(startRes=pirRule,startRule=rule)})}),void 0!=startRes)return startRule=allRules.get(startRes.split("/")[2]),console.log("Start rule: "+startRule.get("id")+" - "+startRule.get("name")),startRuleStatus=startRule.get("status"),0==activeSegments.length?(allPromises.push(restUpdateResource(startRule,{status:"disabled"})),allPromises.push(restUpdateResource(segmentStatus,{state:{status:-1}})),Promise.all(allPromises)):4==activeSegments.length?((allPromises=[]).push(restUpdateResource(startRule,{status:"enabled"})),allPromises.push(restUpdateResource(segmentStatus,{state:{status:1}})),Promise.all(allPromises)):(app.SegmentCol.forEach(segment=>{let endpoints=segment.get("links"),start=app.OffsetCol.get(endpoints[0].split("/")[2]),end=app.OffsetCol.get(endpoints[1].split("/")[2]);createRulesForSegment2(startRes,segmentStatusSenId,activeSegClasses,segment,start,end).forEach(rule=>{allPromises.push(restCreateResource(allRules,rule).then(rsp=>{segmentresources.push("/rules/"+rsp)}))});var segSenStatus,sd=new Date(start.get("state").localtime),ed=new Date(end.get("state").localtime);(ed<sd&&ed.setDate(ed.getDate()+1),currentTime>sd&&currentTime<ed)&&(activeSegClasses.includes(segment.get("classid"))?(startRuleStatus="enabled",segSenStatus=1):(startRuleStatus="disabled",segSenStatus=-1),allPromises.push(restUpdateResource(startRule,{status:startRuleStatus})),allPromises.push(restUpdateResource(segmentStatus,{state:{status:segSenStatus}})))}),Promise.all(allPromises));reject("Could not find Start Rule")}}).then(()=>{var controlLinks=arrayUnique(hdcModel.get("links").concat(segmentresources)),upPresent=!1;controlLinks.forEach(link=>{link.includes("userparameter")&&(upPresent=!0)}),upPresent||controlToControl.get("links").forEach(link=>{link.includes("userparameter")&&controlLinks.push(link)}),restUpdateResource(hdcModel,{links:controlLinks})}).then(()=>Promise.all([restGetResource(app.HdPirControlCol)])).then(()=>{app.activeModel=app.HdPirControlCol.get(app.activeModel.get("id"))}).then(()=>{setTimeout(checkPirRulesConsistency,2e3),resolve()}).catch(errArr=>{console.error(errArr),reject(errArr)})})}function checkPirRulesConsistency(){Promise.all([restGetResource(app.resourcelinks),restGetResource(app.userparameter),restGetResource(app.rules),restGetResource(app.sensors)]).then(result=>{let rules=app.rules.filter(r=>0===r.get("name").indexOf("pir-fsm")||0===r.get("name").indexOf("VSen_")||-1!==r.get("name").indexOf("ResControl")).filter(r=>!app.resourcelinks.find(l=>-1!==l.get("links").indexOf("/rules/"+r.id))),sensors=app.sensors.filter(s=>0===s.get("name").indexOf("DialSeg")||0===s.get("name").indexOf("VSen_")||0===s.get("name").indexOf("VPIR")||0===s.get("name").indexOf("FSM_STATE")).filter(s=>!app.resourcelinks.find(l=>-1!==l.get("links").indexOf("/sensors/"+s.id))),rlinks=app.resourcelinks.filter(rl=>0===rl.get("description").indexOf("Links_CLIP")).filter(rl=>!app.resourcelinks.find(l=>-1!==l.get("links").indexOf("/resourcelinks/"+rl.id)));var resources=rules.concat(sensors).concat(rlinks);resources.length>0&&resources.forEach(res=>{console.log("remove orphan: "+res.get("id")+" - "+res.get("name"))}),Promise.all(resources.map(r=>restDeleteResource(r))).then(()=>restGetResource(app.rules)).then(()=>restGetResource(app.resourcelinks)).then(()=>app.resourcelinks.filter(rl=>3030===rl.get("classid")&&rl.get("links").filter(l=>0===l.indexOf("/groups")).find(g=>{let gid=g.slice(g.lastIndexOf("/")+1);return!app.groups.get(gid)}))).then(res=>Promise.all(res.map(rl=>deletePirControl(rl))));var checkedStartRuleIds=[];app.rules.filter(r=>-1!==r.get("name").indexOf("ResControl")).forEach(r=>{let resConStartRuleId=r.get("name").substring(r.get("name").indexOf("pir-")+4,r.get("name").indexOf("ResControl")),currentStartRule=app.rules.get(resConStartRuleId),rl=app.resourcelinks.find(l=>-1!==l.get("links").indexOf("/rules/"+r.id)),up=rl.get("links").find(l=>-1!==l.indexOf("/userparameter/"));var upId=up.slice(up.lastIndexOf("/")+1);if(!currentStartRule||-1===currentStartRule.get("name").indexOf("state-start")){console.log("start Rule "+resConStartRuleId+" missing"),console.log("ResControl Rule "+r.id+" Resourcelink: "+rl.get("name")),app.resourcelinks.find(l=>l.get("name")==="PIR-"+rl.get("name")).get("links").forEach(l=>{if(-1!==l.indexOf("rules")){let rid=l.slice(l.lastIndexOf("/")+1);if(app.rules.get(rid)&&-1!==app.rules.get(rid).get("name").indexOf("state-start")){console.log("found true startrule "+rid+". Updating ResControl rule."),currentStartRule=app.rules.get(rid);let suffix=r.get("name").substring(r.get("name").indexOf("ResControl"),r.get("name").length);console.log("old name: "+r.get("name")),r.attributes.name="pir-"+rid+suffix,r.attributes.actions[0].address="/rules/"+rid,console.log("new name: "+r.get("name")),r.save({name:r.attributes.name},{patch:!0}),r.save({actions:r.attributes.actions},{patch:!0})}}})}if(!checkedStartRuleIds.includes(resConStartRuleId)){if(checkedStartRuleIds.push(resConStartRuleId),!currentStartRule)return void console.log("could not find current start rule. Abort check for status.");var startRuleStatus,startRuleStatus1;console.log("check status of current start rule "+currentStartRule.get("id")),startRuleStatus1=currentStartRule.get("status"),console.log("current status: "+startRuleStatus1);var activeSegments=[],activeSegClasses=[];app.userparameter.get(upId).get("activeSegments").forEach(activeId=>{app.SegmentCol.where({classid:activeId}).forEach(elem=>activeSegments.push(elem))}),activeSegments.forEach(segment=>{activeSegClasses.push(segment.get("classid"))});var allPromises=[];app.SegmentCol.forEach(segment=>{let endpoints=segment.get("links"),start=app.OffsetCol.get(endpoints[0].split("/")[2]),end=app.OffsetCol.get(endpoints[1].split("/")[2]),sd=new Date(start.get("state").localtime),ed=new Date(end.get("state").localtime);ed<sd&&ed.setDate(ed.getDate()+1);let currentTime=new Date;if(currentTime>sd&&currentTime<ed){let segSenStatus;activeSegClasses.includes(segment.get("classid"))?(startRuleStatus="enabled",segSenStatus=1):(startRuleStatus="disabled",segSenStatus=-1),startRuleStatus1!==startRuleStatus&&(console.log("update current Startrule "+currentStartRule.get("id")+": "+startRuleStatus),allPromises.push(restUpdateResource(currentStartRule,{status:startRuleStatus})))}}),Promise.all(allPromises)}})}).catch(err=>{console.log("Error: "+err)})}function createDialControlRules(hdcModel,controlToControl,activeSegments){return console.log("Create dial control rules"),new Promise((resolve,reject)=>{var segmentresources=[];activeSegments.forEach(segment=>{segmentresources.push("/resourcelinks/"+segment.get("id"))}),getInfoObjects(controlToControl).then(rsp=>{allRules=rsp.rulesCol,segmentStatus=rsp.status;var startRes,startRule,startRuleStatus,currentTime=new Date,segmentStatusSenId=segmentStatus.get("id");segmentresources.push("/sensors/"+segmentStatusSenId),allRules.where({name:"pir-fsm-state-start"}).forEach(rule=>{controlToControl.get("links").filter(link=>link.includes("rules")).forEach(pirRule=>{parseInt(pirRule.split("/")[2])==rule.get("id")&&(startRes=pirRule,startRule=rule)})}),void 0!=startRes&&(startRuleStatus=(startRule=allRules.get(startRes.split("/")[2])).get("status"));var activeStarts=[],activeEnds=[];activeSegments.forEach(segment=>{var segStart=segment.get("links")[0].split("/")[2],segEnd=segment.get("links")[1].split("/")[2];activeStarts.push(segStart),activeEnds.push(segEnd)});var activeStartPoints=[];activeStarts.forEach(startId=>{activeStartPoints.push(app.OffsetCol.where({id:startId})[0])});var activeEndPoints=[];if(activeEnds.forEach(endId=>{activeEndPoints.push(app.OffsetCol.where({id:endId})[0])}),console.log("startrule"),console.log(startRule),0==activeSegments.length)return(allPromises=[]).push(restUpdateResource(startRule,{status:"disabled"})),allPromises.push(restUpdateResource(segmentStatus,{state:{status:-1}})),Promise.all(allPromises);if(1==activeSegments.length){var allPromises=[];(allGenRules=createRulesForSegement(startRes,activeStartPoints[0],activeEndPoints[0],activeSegments[0],segmentStatusSenId)).forEach(rule=>{allPromises.push(restCreateResource(allRules,rule).then(rsp=>{segmentresources.push("/rules/"+rsp)}))});var sd=new Date(activeStartPoints[0].get("state").localtime);(ed=new Date(activeEndPoints[0].get("state").localtime))<sd&&sd.setDate(sd.getDate()-1),startRuleStatus=currentTime>sd&&currentTime<ed?"enabled":"disabled",allPromises.push(restUpdateResource(startRule,{status:startRuleStatus}));var dat=0;return"enabled"==startRuleStatus?dat=1:"disabled"==startRuleStatus&&(dat=-1),allPromises.push(restUpdateResource(segmentStatus,{state:{status:dat}})),Promise.all(allPromises)}if(2==activeSegments.length){if(activeSegments[0].get("classid")>activeSegments[1].get("classid")){var activeStart=activeSegments[1].get("links")[0].split("/")[2],passiveEnd=activeSegments[1].get("links")[1].split("/")[2],passiveStart=activeSegments[0].get("links")[0].split("/")[2],activeEnd=activeSegments[0].get("links")[1].split("/")[2];if(passiveEnd==passiveStart)var startPoint=app.OffsetCol.where({id:activeStart})[0],endPoint=app.OffsetCol.where({id:activeEnd})[0],allGenRules=createRulesForSegement(startRes,startPoint,endPoint,activeSegments[0],segmentStatusSenId);else if(activeStart==activeEnd)startPoint=app.OffsetCol.where({id:passiveStart})[0],endPoint=app.OffsetCol.where({id:passiveEnd})[0],allGenRules=createRulesForSegement(startRes,startPoint,endPoint,activeSegments[0],segmentStatusSenId);else allGenRules=createRulesForInteruptedSegements(activeSegments,activeStartPoints,activeEndPoints,segmentStatusSenId,startRes)}else{activeStart=activeSegments[0].get("links")[0].split("/")[2],passiveEnd=activeSegments[0].get("links")[1].split("/")[2],passiveStart=activeSegments[1].get("links")[0].split("/")[2],activeEnd=activeSegments[1].get("links")[1].split("/")[2];if(passiveEnd==passiveStart)startPoint=app.OffsetCol.where({id:activeStart})[0],endPoint=app.OffsetCol.where({id:activeEnd})[0],allGenRules=createRulesForSegement(startRes,startPoint,endPoint,activeSegments[0],segmentStatusSenId);else if(activeStart==activeEnd)startPoint=app.OffsetCol.where({id:passiveStart})[0],endPoint=app.OffsetCol.where({id:passiveEnd})[0],allGenRules=createRulesForSegement(startRes,startPoint,endPoint,activeSegments[0],segmentStatusSenId);else{allGenRules=createRulesForInteruptedSegements(activeSegments,activeStartPoints,activeEndPoints,segmentStatusSenId,startRes),startPoint=app.OffsetCol.where({id:activeStart})[0],endPoint=app.OffsetCol.where({id:passiveEnd})[0];var asd=new Date(startPoint.get("state").localtime);if(new Date(endPoint.get("state").localtime)<asd&&asd.setDate(asd.getDate()-1),asd>currentTime||psd<currentTime){startPoint=app.OffsetCol.where({id:passiveStart})[0],endPoint=app.OffsetCol.where({id:activeEnd})[0];var psd=new Date(startPoint.get("state").localtime),aed=new Date(endPoint.get("state").localtime);aed<psd&&psd.setDate(psd.getDate()-1),(psd>currentTime||aed<currentTime)&&(startPoint=void 0,endPoint=void 0)}}}var allPromises=[];if(allGenRules.forEach(rule=>{allPromises.push(restCreateResource(allRules,rule).then(rsp=>{segmentresources.push("/rules/"+rsp)}))}),void 0!=startPoint&&void 0!=endPoint){sd=new Date(startPoint.get("state").localtime);(ed=new Date(endPoint.get("state").localtime))<sd&&sd.setDate(sd.getDate()-1),startRuleStatus=currentTime>sd&&currentTime<ed?"enabled":"disabled"}else startRuleStatus="disabled";allPromises.push(restUpdateResource(startRule,{status:startRuleStatus}));dat=0;return"enabled"==startRuleStatus?dat=1:"disabled"==startRuleStatus&&(dat=-1),allPromises.push(restUpdateResource(segmentStatus,{state:{status:dat}})),Promise.all(allPromises)}if(3==activeSegments.length){var unactive,unactiveSegment;activeClassids=[],activeSegments.forEach(function(seg,dex){activeClassids.push(seg.get("classid"))}),unactive=[20201,20202,20203,20204].filter(id=>!activeClassids.includes(id))[0];activeStart=(unactiveSegment=app.SegmentCol.findWhere({classid:unactive})).get("links")[1].split("/")[2],activeEnd=unactiveSegment.get("links")[0].split("/")[2],startPoint=app.OffsetCol.findWhere({id:activeStart}),endPoint=app.OffsetCol.findWhere({id:activeEnd}),allPromises=[];(allGenRules=createRulesForSegement(startRes,startPoint,endPoint,activeSegments[0],segmentStatusSenId)).forEach(rule=>{allPromises.push(restCreateResource(allRules,rule).then(rsp=>{segmentresources.push("/rules/"+rsp)}))});var ed;sd=new Date(startPoint.get("state").localtime);(ed=new Date(endPoint.get("state").localtime))<sd&&sd.setDate(sd.getDate()-1),startRuleStatus=currentTime>sd&&currentTime<ed?"enabled":"disabled",allPromises.push(restUpdateResource(startRule,{status:startRuleStatus}));dat=0;return"enabled"==startRuleStatus?dat=1:"disabled"==startRuleStatus&&(dat=-1),allPromises.push(restUpdateResource(segmentStatus,{state:{status:dat}})),Promise.all(allPromises)}if(4==activeSegments.length)return(allPromises=[]).push(restUpdateResource(startRule,{status:"enabled"})),allPromises.push(restUpdateResource(segmentStatus,{state:{status:1}})),Promise.all(allPromises);activeStartPoints=[];activeStarts.forEach(startId=>{activeStartPoints.push(app.OffsetCol.where({id:startId})[0])});activeEndPoints=[];activeEnds.forEach(endId=>{activeEndPoints.push(app.OffsetCol.where({id:endId})[0])}),console.log(activeStartPoints),console.log(activeEndPoints);allPromises=[];activeSegments.forEach(function(seg,dex){var startPointCondition={address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},segStatusCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"eq",value:1},offAction={address:startRes,body:{status:"disabled"},method:"PUT"},trackStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:-1},method:"PUT"};if(0==dex)var prevEndPointCondition={address:"/sensors/"+activeEndPoints[activeEndPoints.length-1].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"};else prevEndPointCondition={address:"/sensors/"+activeEndPoints[dex-1].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"};var prevSegAddress,nextSegAddress,Rule1Data={conditions:[{address:"/config/localtime",operator:"dx"},startPointCondition,prevEndPointCondition,segStatusCondition],actions:[offAction,trackStatusAction],name:"pir-Control-off-SegStart-at-"+seg.get("name")},startTrueCondition={address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},endTrueCondition={address:"/sensors/"+activeEndPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},statusOffCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:1},onAction={address:startRes,body:{status:"enabled"},method:"PUT"},changeStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:1},method:"PUT"},Rule3Data={conditions:[{address:"/config/localtime",operator:"dx"},endTrueCondition,startTrueCondition,statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-"+seg.get("name")},startBiggerCondition={address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/sensors/"+activeEndPoints[dex].get("id")+"/state/localtime"},betweenS0Rule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-"+seg.get("name")+"bS0"},between0ERule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},{address:"/sensors/"+activeEndPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-"+seg.get("name")+"b0E"};0==dex?(prevSegAddress="/sensors/"+activeEndPoints[activeEndPoints.length-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[dex+1].get("id")+"/state/localtime"):dex==activeEndPoints.length-1?(prevSegAddress="/sensors/"+activeEndPoints[dex-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[0].get("id")+"/state/localtime"):(prevSegAddress="/sensors/"+activeEndPoints[dex-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[dex+1].get("id")+"/state/localtime");var outOfSegmentRule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeEndPoints[dex].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},{address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},{address:nextSegAddress,operator:"lt",value:"/config/localtime"},segStatusCondition],actions:[offAction,trackStatusAction],name:"pir-Control-off-at-"+seg.get("name")+"ES-N"},prevEndBiggerCondition={address:prevSegAddress,operator:"lt",value:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime"};[Rule1Data,Rule3Data,betweenS0Rule,between0ERule,outOfSegmentRule,{conditions:[{address:"/config/localtime",operator:"dx"},prevEndBiggerCondition,{address:prevSegAddress,operator:"gt",value:"/config/localtime"},segStatusCondition],actions:[offAction,trackStatusAction],name:"pir-Control-off-at-"+seg.get("name")+"betweenActives"},{conditions:[{address:"/config/localtime",operator:"dx"},prevEndBiggerCondition,{address:"/sensors/"+activeStartPoints[dex].get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},segStatusCondition],actions:[offAction,trackStatusAction],name:"pir-Control-off-at-"+seg.get("name")+"beforeStart"}].forEach(rule=>{allPromises.push(restCreateResource(allRules,rule).then(rsp=>{segmentresources.push("/rules/"+rsp)}))})}),allPromises.push(restUpdateResource(startRule,{status:startRuleStatus}));dat=0;return"enabled"==startRuleStatus?dat=1:"disabled"==startRuleStatus&&(dat=-1),allPromises.push(restUpdateResource(segmentStatus,{state:{status:dat}})),Promise.all(allPromises)}).then(()=>{var controlLinks=arrayUnique(hdcModel.get("links").concat(segmentresources)),upPresent=!1;controlLinks.forEach(link=>{link.includes("userparameter")&&(upPresent=!0)}),upPresent||controlToControl.get("links").forEach(link=>{link.includes("userparameter")&&controlLinks.push(link)}),restUpdateResource(hdcModel,{links:controlLinks})}).then(()=>Promise.all([restGetResource(app.HdPirControlCol)])).then(()=>{app.activeModel=app.HdPirControlCol.get(app.activeModel.get("id")),resolve()}).catch(errArr=>{console.error(errArr),reject(errArr)})})}function deleteDialControlRules(hdcModel,controlToControl,activeSegments){return new Promise((resolve,reject)=>{var allPromises=[];allRules=app.rules,Promise.all([restGetResource(allRules),restGetResource(hdcModel)]).then(rsp=>{var links=hdcModel.get("links"),filtered=hdcModel.get("links");for(let i=links.length-1;i>=0;i--){let li=links[i];if(li.includes("/rules")&&0==li.includes("/resourcelinks")&&0==li.includes("/groups")&&0==li.includes("/userparameter")){let rLink=allRules.get(parseInt(li.split("/rules/")[1]));rLink&&allPromises.push(restDeleteResource(rLink))}let pirString="/resourcelinks/"+controlToControl.get("id");if(!activeSegments||activeSegments.length<1){if(0==li.includes(pirString)&&0==li.includes("/userparameter")&&0==li.includes("/groups")){let ind=links.indexOf(li);ind>-1&&filtered.splice(ind,1)}}else activeSegments.forEach(seg=>{let segString="resourcelinks/"+seg.id;if(0==li.includes(segString)&&0==li.includes(pirString)&&0==li.includes("/userparameter")&&0==li.includes("/groups")){let ind=links.indexOf(li);ind>-1&&filtered.splice(ind,1)}})}allPromises.push(restUpdateResource(hdcModel,{links:filtered})),Promise.all(allPromises).then(()=>{resolve()}).catch(err=>{console.error(err),404==err.status&&resolve(),reject(err)})}).catch(err=>{console.error(err),404==err.status&&resolve(),reject(err)})})}function createRulesForSegement(startRes,activeStart,activeEnd,activeSegment,segmentStatusSenId){var allRules=[];if(new Date(activeStart.get("state").localtime)>new Date(activeEnd.get("state").localtime)){var onAction={address:startRes,body:{status:"enabled"},method:"PUT"},changeStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:1},method:"PUT"},statusOffCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:1},startBiggerCondition={address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"lt",value:"/sensors/"+activeEnd.get("id")+"/state/localtime"},betweenS0Rule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-S0"};allRules.push(betweenS0Rule);var timeOverStartCondition={address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},between0ERule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,timeOverStartCondition,{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-0E"};allRules.push(between0ERule);var outOfSegRule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,timeOverStartCondition,{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},{address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"eq",value:1}],actions:[offAction={address:startRes,body:{status:"disabled"},method:"PUT"},trackStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:-1},method:"PUT"}],name:"pir-Control-OFF-at-OutOfSeg"};allRules.push(outOfSegRule)}else{var offAction,trackStatusAction,segStatusCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"eq",value:1},Rule1Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},segStatusCondition],actions:[offAction={address:startRes,body:{status:"disabled"},method:"PUT"},trackStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:-1},method:"PUT"}],name:"pir-Control-off-SegStart"};allRules.push(Rule1Data);var Rule2Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},segStatusCondition],actions:[offAction,trackStatusAction],name:"pir-Control-off-SegEnd"};allRules.push(Rule2Data);var startTrueCondition={address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},Rule3Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},startTrueCondition,statusOffCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:1}],actions:[onAction={address:startRes,body:{status:"enabled"},method:"PUT"},changeStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:1},method:"PUT"}],name:"pir-Control-on-at-SegStart"};allRules.push(Rule3Data)}return allRules}function createRulesForInteruptedSegements(activeSegments,activeStartPoints,activeEndPoints,segmentStatusSenId,startRes){var allGenRules=[];return activeSegments.forEach(function(seg,dex){var nextSegAddress;allGenRules=allGenRules.concat(createSegmentOnRules(seg,activeStartPoints[dex],activeEndPoints[dex],segmentStatusSenId,startRes)),0==dex?("/sensors/"+activeEndPoints[activeEndPoints.length-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[dex+1].get("id")+"/state/localtime"):dex==activeEndPoints.length-1?("/sensors/"+activeEndPoints[dex-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[0].get("id")+"/state/localtime"):("/sensors/"+activeEndPoints[dex-1].get("id")+"/state/localtime",nextSegAddress="/sensors/"+activeStartPoints[dex+1].get("id")+"/state/localtime");var outOfSegmentRule={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+activeEndPoints[dex].get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},{address:nextSegAddress,operator:"lt",value:"/config/localtime"},{address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"eq",value:1}],actions:[{address:startRes,body:{status:"disabled"},method:"PUT"},{address:"/sensors/"+segmentStatusSenId+"/state",body:{status:-1},method:"PUT"}],name:"pir-Control-off-at-"+seg.get("name")+"ES-N"};allGenRules.push(outOfSegmentRule)}),allGenRules}function createSegmentOnRules(activeSegment,activeStart,activeEnd,segmentStatusSenId,startRes){var allRules=[];if(new Date(activeStart.get("state").localtime)>new Date(activeEnd.get("state").localtime)){var onAction={address:startRes,body:{status:"enabled"},method:"PUT"},changeStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:1},method:"PUT"},statusOffCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:1},startBiggerCondition={address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"lt",value:"/sensors/"+activeEnd.get("id")+"/state/localtime"},betweenS0Rule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-"+activeSegment.get("name")+"bS0"};allRules.push(betweenS0Rule);var between0ERule={conditions:[{address:"/config/localtime",operator:"dx"},startBiggerCondition,{address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},statusOffCondition],actions:[onAction,changeStatusAction],name:"pir-Control-on-at-"+activeSegment.get("name")+"b0E"};allRules.push(between0ERule)}else{var startTrueCondition={address:"/sensors/"+activeStart.get("id")+"/state/localtime",operator:"gt",value:"/config/localtime"},Rule3Data={conditions:[{address:"/config/localtime",operator:"dx"},{address:"/sensors/"+activeEnd.get("id")+"/state/localtime",operator:"lt",value:"/config/localtime"},startTrueCondition,statusOffCondition={address:"/sensors/"+segmentStatusSenId+"/state/status",operator:"lt",value:1}],actions:[onAction={address:startRes,body:{status:"enabled"},method:"PUT"},changeStatusAction={address:"/sensors/"+segmentStatusSenId+"/state",body:{status:1},method:"PUT"}],name:"pir-Control-on-at-"+activeSegment.get("name")};allRules.push(Rule3Data)}return allRules}function getNextId(){return id+=1,"drag"+id}function createPicker(parentContainer_id,child_id,startPoint,startAngle){var id_number;id_number=(id_number=child_id.split("drag"))[1],id_number=parseInt(id_number),id_number=(id_number=child_id.split("drag"))[1],id_number=parseInt(id_number),d3.select(parentContainer_id).append("g").attr("id",child_id),d3.select("#"+child_id).append("rect").attr("id",child_id+"-drag_rect").attr("class","oval"),d3.select("#"+child_id).append("ellipse").attr("id",child_id+"-drag_elipse").attr("cx",5).attr("cy",100).attr("class","handle-ellipse"),d3.select("#"+child_id).append("ellipse").attr("id",child_id+"-drag_innerelipse").attr("cx",5).attr("cy",100).attr("class","handle-innerellipse")}function showPicker(picker_id,startAngle,startPoint,draggable_Collection){var drag=document.querySelector(picker_id);TweenLite.set(drag,{transformOrigin:"top",rotation:startAngle+"_deg",x:startPoint.x,y:startPoint.y,display:"none"}),0==draggable_Collection.includes(drag)&&draggable_Collection.push(drag)}function getClassId(devicetype){switch(devicetype){case"ZHAHumidity":return 30301;case"ZHALightLevel":return 30302;case"ZHAPresence":return 30303;case"ZHAPressure":return 30304;case"ZHATemperature":return 30305;case"ZHAVibration":return 30306;case"ZHAOpenClose":return 30307;case"ZHASwitch":return 30308;case"Daylight":return 30309}}function getDeviceType(classid){switch(classid){case 30301:return"ZHAHumidity";case 30302:return"ZHALightLevel";case 30303:return"ZHAPresence";case 30304:return"ZHAPressure";case 30305:return"ZHATemperature";case 30306:return"ZHAVibration";case 30307:return"ZHAOpenClose";case 30308:return"ZHASwitch";case 30309:return"Daylight";default:return!1}}function getCommonUnit(devicetype,value){let v;switch(devicetype){case"ZHAHumidity":return parseFloat(value/100);case"ZHALightLevel":return 0!=value?((v=Math.pow(10,value/1e4))<1&&(v=0),v=Math.round(v)):v=value,v;case"ZHAPresence":return 1==value;case"ZHAPressure":return value;case"ZHATemperature":return value>99||value<-99?Number(value/100).toFixed(1):Number(value).toFixed(1);case"ZHAVibration":case"ZHAOpenClose":case"Daylight":return 1==value}}function convertToStateUnit(val,devicetype){switch(devicetype){case"ZHAHumidity":return parseFloat(100*val);case"ZHALightLevel":if(0==parseInt(val))return val;let value=Math.log(val)/Math.log(10)*1e4;return null==(value=Math.round(value+1))&&(value=0),value;case"ZHAPresence":return 1==val;case"ZHAPressure":return val;case"ZHATemperature":return parseInt(100*val);case"ZHAVibration":case"ZHAOpenClose":case"Daylight":return 1==val}}function addUnit(value,type,justUnit){return"ZHAPresence"==type?value=justUnit?translate("text_detected_true"):value?translate("detected_ZHAPresence"):translate("text_no_motion_detected"):"ZHALightLevel"==type?value+="Lux":"ZHAOpenClose"==type?value=justUnit?translate("text_isopen"):value?translate("text_isopen"):translate("text_closed"):"Daylight"==type?value=justUnit?translate("opt_sunrise_sunset"):value?translate("opt_sunrise_sunset"):translate("opt_sunset_sunrise"):"ZHATemperature"==type?value+="°C":"ZHAHumidity"==type?value+="%":"ZHAPressure"==type?value+="hPa":"ZHAVibration"==type&&(value=justUnit?translate("text_detected_true"):value?translate("text_vibration_true"):translate("text_vibration_false")),value}function deleteVirtualSensorResource(vRes){return new Promise((resolve,reject)=>{var allProms=[];vRes.get("links").forEach(li=>{if(li.includes("sensors")){let s=app.sensors.get(li.split("/").pop());if(s){if("CLIPGenericFlag"!=s.get("type"))return;allProms.push(restDeleteResource(s))}}else if(li.includes("rules")){let r=app.rules.get(li.split("/").pop());r&&allProms.push(restDeleteResource(r))}}),allProms.push(restDeleteResource(vRes)),Promise.all(allProms).then(()=>{resolve()}).catch(errArr=>{console.error(errArr),reject(errArr)})})}function checkIfTriggerAssigned(s,up,clickArea){var rc=!1;if(up.get("triggersensors").forEach(sen=>{sen.sensor.split("/").pop()==s.get("id")&&(rc=!0)}),1==rc){return clickArea.nextElementSibling.style.display="block",clickArea.querySelector("svg use").setAttribute("xlink:href","#check-frame"),!0}return clickArea.querySelector("svg use").setAttribute("xlink:href","#empty-frame-icon"),!1}function addSensorTrigger(s,flagRes,pirStateListView,withPreset){let sVals,sType=s.get("type"),devicetypes=pirStateListView.userparameter.get("devicetypes"),virtType=sType.replace("ZHA","CLIP"),statetype=sType.replace("ZHA","").toLowerCase(),conName=pirStateListView.resourcelinks.get("name");if(1==withPreset?(sVals=!!(s.get("type").includes("Presence")||s.get("type").includes("OpenClose")||s.get("type").includes("Vibration")||s.get("type").includes("Daylight"))||(s.get("type").includes("Temperature")?[0,25]:[1,600]),s.get("type").includes("OpenClose")&&(statetype="open")):s.get("type").includes("Presence")||s.get("type").includes("OpenClose")||s.get("type").includes("Vibration")||s.get("type").includes("Daylight")?(s.get("type").includes("OpenClose")&&(statetype="open"),wrap=document.querySelector("#"+s.get("type")+"-range-wrap"),wrap.noUiSlider?0==(sVals=wrap.noUiSlider.get(!0))?sVals=!1:1==sVals&&(sVals=!0):sVals=!0):(wrap=document.querySelector("#"+s.get("type")+"-range-wrap"),(sVals=wrap.noUiSlider.get(!0)).forEach((val,ii)=>{let value=convertToStateUnit(val,s.get("type"));sVals[ii]=value,null==sVals[ii]&&(sVals[ii]=0)})),devicetypes.includes(sType)){var virtSen,offRuleMin,offRuleMax,virtRes=null;let flagRes,allProm=[];var resLinks;if(pirStateListView.pirControl.get("links").forEach(link=>{if(link.includes("resourcelinks")){let res=app.resourcelinks.get(link.split("/").pop());res.get("classid")==getClassId(sType)&&(virtRes=res,resLinks=[...res.get("links")],virtRes.get("links").forEach(li=>{if(li.includes("sensors")){let potSen=app.sensors.get(li.split("/").pop());potSen&&"CLIPGenericFlag"==potSen.get("type")&&(virtSen=potSen,flagRes=li)}else if(li.includes("rules")){let potRule=app.rules.get(li.split("/").pop());potRule.get("name")=="VSen_"+virtType+"_"+conName+"_off1"?offRuleMin=potRule:potRule.get("name")=="VSen_"+virtType+"_"+conName+"_off2"&&(offRuleMax=potRule)}}))}}),s.get("type").includes("Presence")||s.get("type").includes("OpenClose")||s.get("type").includes("Vibration")||s.get("type").includes("Daylight")){let maxDuration=60;if(maxDuration>=10&&s.has("config")){let config={};if("duration"in s.get("config")){let duration=s.get("config").duration||60;duration>maxDuration?config.duration=maxDuration:maxDuration>60&&(config.duration=maxDuration);const uniqueid=s.get("uniqueid")||"";-1!==(s.get("modelid")||"").indexOf("lumi.sensor_motion")?duration<90&&(config.duration=90):-1!==uniqueid.indexOf("-0500")&&duration<90&&(config.duration=90)}if("delay"in s.get("config")){(s.get("config").delay||60)>maxDuration?config.delay=maxDuration:maxDuration>60&&(config.delay=maxDuration)}(config.duration||config.delay)&&allProm.push(restUpdateResource(s,{config:config}).then(()=>{}).catch())}if(offRuleMin){let offConditions=[...offRuleMin.get("conditions")].filter(cond=>"dx"!=cond.operator),offVal=1!=sVals;offConditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:offVal}),allProm.push(restUpdateResource(offRuleMin,{conditions:offConditions}))}if(virtSen){let virtOnRule={name:"VSen_"+virtType+"_"+conName+"_on",conditions:[],actions:[]};virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:sVals}),virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"}),virtOnRule.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}});var prom=restCreateResource(app.rules,virtOnRule).then(rid=>{resLinks.push("/rules/"+rid)});allProm.push(prom)}let trigger={sensor:"/sensors/"+s.get("id"),state:statetype,param:["eq"],value:[sVals]},triggerSensors=[...pirStateListView.userparameter.get("triggersensors")];triggerSensors.push(trigger),allProm.push(restUpdateResource(app.pirStateListView.userparameter,{triggersensors:triggerSensors}));let flagset=!1;if(pirStateListView.userparameter.get("triggersensors").every(trigger=>{if(trigger.state==statetype){let sen=app.sensors.get(trigger.sensor.split("/").pop());return!sen||(sen[statetype]!=trigger.value[0]||(flagset=!0,!1))}return!0}),void 0===flagRes||null===flagRes)return!1;1==flagset||s.get("state")[statetype]==sVals[0]?allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!0}})):allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!1}}))}else{if(offRuleMin){let offConditions=[...offRuleMin.get("conditions")].filter(cond=>"dx"!=cond.operator);offConditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"lt",value:sVals[0]}),allProm.push(restUpdateResource(offRuleMin,{conditions:offConditions}))}if(offRuleMax){let offConditions=[...offRuleMax.get("conditions")].filter(cond=>"dx"!=cond.operator);offConditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"gt",value:sVals[1]}),allProm.push(restUpdateResource(offRuleMax,{conditions:offConditions}))}if(virtSen){let virtOnRule={name:"VSen_"+virtType+"_"+conName+"_on",conditions:[],actions:[]};virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"gt",value:sVals[0]}),virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"lt",value:sVals[1]}),virtOnRule.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}});let virtOnRule2={name:"VSen_"+virtType+"_"+conName+"_on2",conditions:[],actions:[]};virtOnRule2.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:sVals[0]}),virtOnRule2.conditions.push({address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"}),virtOnRule2.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}}),[virtOnRule,virtOnRule2].forEach(rule=>{var prom=restCreateResource(app.rules,rule).then(rid=>{resLinks.push("/rules/"+rid)});allProm.push(prom)})}let trigger={sensor:"/sensors/"+s.get("id"),state:statetype,param:["gt, lt"],value:[sVals[0],sVals[1]]},triggerSensors=[...pirStateListView.userparameter.get("triggersensors")];triggerSensors.push(trigger),allProm.push(restUpdateResource(pirStateListView.userparameter,{triggersensors:triggerSensors}));let flagset=!1;if(pirStateListView.userparameter.get("triggersensors").every(trigger=>{if(trigger.state==statetype){let sen=app.sensors.get(trigger.sensor.split("/").pop());return!(sen[statetype]>=trigger.value[0]&&sen[statetype]<=trigger.value[1])||(flagset=!0,!1)}return!0}),void 0===flagRes||null===flagRes)return!1;1==flagset||s.get("state")[statetype]>=sVals[0]&&s.get("state")[statetype]<=sVals[1]?allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!0}})):allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!1}}))}Promise.all(allProm).then(()=>(resLinks.push("/sensors/"+s.get("id")),restUpdateResource(virtRes,{links:resLinks}))).then(()=>{app.trigger("update-list-item");let pirControlListItems=document.querySelectorAll("#sensorControlList li");return document.querySelector("#newSensor-btn").classList.add("unclickable"),pirControlListItems.forEach(el=>{el.classList.add("unclickable")}),app.savePirControl()}).catch(errArr=>{console.error(errArr)})}else{devicetypes.push(sType);let virtSenData={type:"CLIPGenericFlag",modelid:conName+"_CLIPGenericFlag_"+virtType,manufacturername:"Phoscon",name:"VSen_"+virtType+"_"+conName,swversion:"1.0",uniqueid:"vSen-"+(new Date).getTime()},res={classid:getClassId(sType),description:"Links_CLIPGenericFlag_"+virtType+"_of_"+conName,links:[],name:virtType+"_of_"+conName};restCreateResource(app.sensors,virtSenData).then(rsp=>{let vs="/sensors/"+rsp,senRes="/sensors/"+s.get("id");return res.links.push(vs),res.links.push(senRes),restCreateResource(app.resourcelinks,res)}).then(rsp=>{let li=[...pirStateListView.pirControl.get("links")];return li.push("/resourcelinks/"+rsp),typeRes="/resourcelinks/"+rsp,Promise.all([restUpdateResource(pirStateListView.pirControl,{links:li}).then(()=>restGetResource(pirStateListView.pirControl)),restUpdateResource(pirStateListView.userparameter,{devicetypes:devicetypes})])}).then(()=>{(virtRes=app.resourcelinks.get(typeRes.split("/").pop())).get("links").forEach(li=>{if(li.includes("sensors")){let potSen=app.sensors.get(li.split("/").pop());potSen&&potSen.get("type").includes("GenericFlag")&&(flagRes=li)}});let allProm=[];if(s.get("type").includes("Presence")||s.get("type").includes("OpenClose")||s.get("type").includes("Vibration")||s.get("type").includes("Daylight")){let maxDuration=60;if(maxDuration>=10&&s.has("config")){let config={};if("duration"in s.get("config")){let duration=s.get("config").duration||60;duration>maxDuration?config.duration=maxDuration:maxDuration>60&&(config.duration=maxDuration);const uniqueid=s.get("uniqueid")||"";-1!==(s.get("modelid")||"").indexOf("lumi.sensor_motion")?duration<90&&(config.duration=90):-1!==uniqueid.indexOf("-0500")&&duration<90&&(config.duration=90)}if("delay"in s.get("config")){(s.get("config").delay||60)>maxDuration?config.delay=maxDuration:maxDuration>60&&(config.delay=maxDuration)}(config.duration||config.delay)&&allProm.push(restUpdateResource(s,{config:config}).then(()=>{}).catch())}let virtOnRule={name:"VSen_"+virtType+"_"+conName+"_on",conditions:[],actions:[]};virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:sVals}),virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"}),virtOnRule.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}});let changeCondition={address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"},virtOffRule1={name:"VSen_"+virtType+"_"+conName+"_off1",conditions:[],actions:[]},offVal=1!=sVals;virtOffRule1.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:offVal}),virtOffRule1.conditions.push(changeCondition),virtOffRule1.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!1}}),[virtOnRule,virtOffRule1].forEach(rule=>{var prom=restCreateResource(app.rules,rule).then(rid=>{res.links.push("/rules/"+rid)});allProm.push(prom)});let trigger={sensor:"/sensors/"+s.get("id"),state:statetype,param:["eq"],value:[sVals]},triggerSensors=[...app.pirStateListView.userparameter.get("triggersensors")];return triggerSensors.push(trigger),allProm.push(restUpdateResource(app.pirStateListView.userparameter,{triggersensors:triggerSensors})),s.get("state")[statetype]==sVals&&allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!0}})),Promise.all(allProm)}{let virtOnRule={name:"VSen_"+virtType+"_"+conName+"_on",conditions:[],actions:[]};virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"gt",value:sVals[0]}),virtOnRule.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"lt",value:sVals[1]}),virtOnRule.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}});let virtOnRule2={name:"VSen_"+virtType+"_"+conName+"_on2",conditions:[],actions:[]};virtOnRule2.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"eq",value:sVals[0]}),virtOnRule2.conditions.push({address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"}),virtOnRule2.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!0}});let virtOffRule1={name:"VSen_"+virtType+"_"+conName+"_off1",conditions:[],actions:[]};virtOffRule1.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"lt",value:sVals[0]});let changeCondition={address:"/sensors/"+s.get("id")+"/state/lastupdated",operator:"dx"};virtOffRule1.conditions.push(changeCondition),virtOffRule1.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!1}});let virtOffRule2={name:"VSen_"+virtType+"_"+conName+"_off2",conditions:[],actions:[]};virtOffRule2.conditions.push({address:"/sensors/"+s.get("id")+"/state/"+statetype,operator:"gt",value:sVals[1]}),virtOffRule2.conditions.push(changeCondition),virtOffRule2.actions.push({address:flagRes+"/state/",method:"PUT",body:{flag:!1}}),[virtOnRule,virtOnRule2,virtOffRule1,virtOffRule2].forEach(rule=>{var prom=restCreateResource(app.rules,rule).then(rid=>{res.links.push("/rules/"+rid)});allProm.push(prom)});let trigger={sensor:"/sensors/"+s.get("id"),state:statetype,param:["gt, lt"],value:[sVals[0],sVals[1]]},triggerSensors=[...pirStateListView.userparameter.get("triggersensors")];return triggerSensors.push(trigger),allProm.push(restUpdateResource(pirStateListView.userparameter,{triggersensors:triggerSensors})),s.get("state")[statetype]>=sVals[0]&&s.get("state")[statetype]<=sVals[1]&&allProm.push(restUpdateResource(app.sensors.get(flagRes.split("/").pop()),{state:{flag:!0}})),Promise.all(allProm)}}).then(()=>{var virtRes=app.resourcelinks.get(typeRes.split("/").pop());return restUpdateResource(virtRes,{links:res.links})}).then(()=>{app.trigger("update-list-item");let pirControlListItems=document.querySelectorAll("#sensorControlList li");return document.querySelector("#newSensor-btn").classList.add("unclickable"),pirControlListItems.forEach(el=>{el.classList.add("unclickable")}),app.savePirControl()}).catch(err=>{console.error(err)})}setTimeout(conflictCheck,1e3)}function deleteSensorTrigger(sensor,flagRes,pirStateListView){let sType=sensor.get("type"),virtType=sType.replace("ZHA","CLIP"),onRules=(sType.replace("ZHA","").toLowerCase(),pirStateListView.resourcelinks.get("name"),[]),offRules=[],allProms=[];if(flagRes){flagLinks=[...flagRes.get("links")],flagRes.get("links").forEach(link=>{if(link.includes("rules")){let r=app.rules.get(link.split("/").pop());r.get("name").includes("on")?r.get("conditions").every(c=>{if(c.address.includes("sensors/"+sensor.get("id"))){onRules.push(r);let i=flagLinks.indexOf(link);return flagLinks.splice(i,1),!1}return!0}):r.get("name").includes("off")&&r.get("conditions").every(c=>!c.address.includes("sensors/"+sensor.get("id"))||(offRules.push(r),!1))}else if(link.includes("sensors/"+sensor.get("id"))){let i=flagLinks.indexOf(link);flagLinks.splice(i,1)}}),onRules.forEach(rule=>{allProms.push(restDeleteResource(rule))}),offRules.forEach(rule=>{let newConds=[...rule.get("conditions")];rule.get("conditions").forEach(c=>{if(c.address.includes("sensors/"+sensor.get("id"))){let ind=newConds.indexOf(c);ind>=0&&newConds.splice(ind,1)}}),newConds.length>0&&allProms.push(restUpdateResource(rule,{conditions:newConds}))});let senCount=0;if(flagLinks.forEach(l=>{l.includes("sensor")&&(senCount+=1)}),allProms.push(restUpdateResource(flagRes,{links:flagLinks})),senCount<=1){(allProms=[]).push(deleteVirtualSensorResource(flagRes));let pirLinks=pirStateListView.pirControl.get("links"),ii=pirLinks.indexOf("/resourcelinks/"+flagRes.get("id"));ii>=0&&(pirLinks.splice(ii,1),allProms.push(restUpdateResource(pirStateListView.pirControl,{links:pirLinks}).then(()=>restGetResource(pirStateListView.pirControl)))),checkDeviceTypes(pirStateListView.pirControl,pirStateListView.userparameter)}}let triggerList=[...pirStateListView.userparameter.get("triggersensors")];pirStateListView.userparameter.get("triggersensors").forEach((sen,ind)=>{if(sen.sensor.includes(sensor.get("id"))){let iii=triggerList.indexOf(sen);iii>=0&&triggerList.splice(iii,1)}}),allProms.push(restUpdateResource(pirStateListView.userparameter,{triggersensors:triggerList})),Promise.all(allProms).then(()=>{app.trigger("update-list-item");let pirControlListItems=document.querySelectorAll("#sensorControlList li");return document.querySelector("#newSensor-btn").classList.add("unclickable"),pirControlListItems.forEach(el=>{el.classList.add("unclickable")}),app.savePirControl()}).catch(err=>{}),conflictCheck()}function checkDeviceTypes(pirControl,userparam){return new Promise((resolve,reject)=>{let devTypeList=[...userparam.get("devicetypes")];pirControl.get("links").forEach(link=>{if(link.includes("resourcelink")){let res=app.resourcelinks.get(link.split("/").pop());if(res)getDeviceType(res.get("classid"))}}),userparam.get("devicetypes").forEach(type=>{let found=!1;if(pirControl.get("links").every(link=>{if(link.includes("resourcelink")){let res=app.resourcelinks.get(link.split("/").pop());if(res){return getDeviceType(res.get("classid"))!=type||(found=!0,!1)}return!0}return!0}),!found){let i=devTypeList.indexOf(type);i>=0&&devTypeList.splice(i,1)}});let allProms=[];allProms.push(restUpdateResource(userparam,{devicetypes:devTypeList})),Promise.all(allProms).then(()=>{resolve()}).catch(err=>{reject(err)})})}function calcLux(lightlevel){let value=Math.pow(10,lightlevel/1e4);return value<1?value=0:1==value&&(value-=1),value=Math.round(value)}function wizLoadSvg(dest,dev){var swel=Snap.select(dest);if(!swel)return!1;var data=Snap("#common-icons");swel.clear();var s=data.select(dev),viewboxFrame=(getClosest(document.getElementById(s.node.id),"svg"),document.querySelector(dev+" > .sw-wizzard > .view-box"));if(!s)return!1;s=s.clone(),viewboxFrame&&viewboxFrame.setAttribute("display","none");var viewBox=swel.attr("viewBox");return viewBox.x=viewboxFrame.getAttribute("x"),viewBox.y=viewboxFrame.getAttribute("y"),viewBox.width=viewboxFrame.getAttribute("width"),viewBox.height=viewboxFrame.getAttribute("height"),swel.append(s),s.attr("display","inline"),swel.attr("viewBox",viewBox),$(".sw-target").parent().css("display","block"),!0}function wizLoadSvg2(dest,dev){var swel=Snap.select(dest);if(!swel)return!1;var data=Snap("#common-icons");swel.clear();var s=data.select(dev);document.querySelector(dev+" > .sw-wizzard > .view-box");if(!s)return!1;let w=(s=s.clone()).select(".sw-wizzard");w&&w.attr("display","none"),s.parent().attr("display","inline"),swel.append(s),s.attr("display","inline");var bb=s.getBBox(),viewBox=swel.attr("viewBox"),wMargin=swel.attr("data-wmargin");wMargin=wMargin?parseInt(wMargin):310;var bottomMargin=swel.attr("data-bmargin");bottomMargin=bottomMargin?parseInt(bottomMargin):200;var width=Math.floor(bb.width+2*wMargin),height=Math.floor(bb.height+20+bottomMargin);return viewBox.x=Math.floor(bb.x-wMargin),viewBox.y=Math.floor(bb.y-20),viewBox.width=width,viewBox.height=height,swel.attr("viewBox",viewBox),swel.attr("width",width),swel.attr("height",height),$(".sw-target").parent().css("display","block"),!0}function setDataButtonevents(svg,sw){if(!svg)return;let swEventMap=getDeviceEventMap(sw),events=swEventMap.buttonEvents;if(!events)return;let switchId=getDeviceInteractiveId(sw.attributes);svg.find(".sw-target:not(.sw-target-extra)").toArray().forEach((t,idx)=>{events[idx]?t.setAttribute("data-buttonEvent",events[idx]):-1!==switchId.indexOf("generic-switch")&&t.classList.add("no-event")});let extra=swEventMap.buttonExtra;!extra||switchId&&-1!==switchId.indexOf("generic-switch")||svg.find(".sw-extra .sw-target").toArray().forEach((t,idx)=>{extra[idx]&&(t.getAttribute("data-buttonEvent")||(t.setAttribute("data-buttonExtra",extra[idx]),t.classList.add("sw-target-extra")))})}function genereatePathByPoints(path,startModel,endModel){const pathLength=path.getTotalLength()||0;var endPoint=getPointOnPath(path,endModel.get("angle"));endPoint=endPoint.point;var startPoint=getPointOnPath(path,startModel.get("angle"));startPoint=startPoint.point;var endpoint_angleDeg=getCircleAngle(path.getPointAtLength(0),endPoint),arc_midPoint=generatePoint(path,getMiddelAngle(getCircleAngle(path.getPointAtLength(0),startPoint),endpoint_angleDeg),pathLength);return calcCirclePath2([{pos:[startPoint.x,startPoint.y]},{pos:[arc_midPoint.x,arc_midPoint.y]},{pos:[endPoint.x,endPoint.y]}])}var getClosest=function(elem,selector){for(Element.prototype.matches||(Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(s){for(var matches=(this.document||this.ownerDocument).querySelectorAll(s),i=matches.length;--i>=0&&matches.item(i)!==this;);return i>-1});elem&&elem!==document;elem=elem.parentNode)if(elem.matches(selector))return elem;return null};function getPosition(position){return console.log("enter get Position"),console.log(position),{long:position.coords.longitude,lat:position.coords.latitude}}function configDaylightSensi(app,context){$.ajax({url:"https://phoscon.de/discover",type:"GET",success:function(res,ts,request){console.log("Discovery Test"),console.log(request.getResponseHeader("X-Appengine-Citylatlong")),console.log(context.SunStates.get("id"));let cords=request.getResponseHeader("X-Appengine-Citylatlong").split(",");void 0!=context.SunStates.get("id")?2==cords.length?restUpdateResource(app.sensors.get(context.SunStates.get("id")),{config:{lat:cords[0].toString(),long:cords[1].toString()}}).then(rsp=>{void 0==app.config.get("timeformat")&&setGatewayDateAndTime(),context.service.send("ADDED")}).catch(err=>{console.error(err)}):restUpdateResource(app.sensors.get(context.SunStates.get("id")),{config:{lat:"52.52",long:"13.4050"}}).then(rsp=>{void 0==app.config.get("timeformat")&&setGatewayDateAndTime(),context.service.send("ADDED")}).catch(err=>{console.error(err)}):console.error("Daylight Sensor not present\n Please Restart Gateway")},error:function(err){restUpdateResource(app.sensors.get(context.SunStates.get("id")),{config:{lat:"52.52",long:"13.4050"}}).then(rsp=>{context.service.send("ADDED")}).catch(err=>{console.error(err)})}})}function deletePirControl(rl){var pirControl,pirControl2,activeSegments,links=[];if(rl.get("links").forEach(link=>{if(link.includes("resourcelinks")){let linkid=parseInt(link.split("/")[2]),potControl=app.resourcelinks.get(linkid);potControl?3030==potControl.get("classid")&&(pirControl=potControl):4040==rl.get("classid")&&(pirControl2=rl)}}),!pirControl){if(!pirControl2)return;pirControl=pirControl2}pirControl.get("links").forEach(l=>{if(0===l.indexOf("/sensors")){let sid=l.split("/").pop(),s=app.sensors.get(sid);if(!s)return;let type=s.get("type");"CLIPGenericStatus"!==type&&"CLIPPresence"!==type&&"CLIPGenericFlag"!==type||(console.log("deleting sensor: "+s.get("name")),links.push(restDeleteResource(s)))}else if(0===l.indexOf("/rules")){let rid=l.split("/").pop(),r=app.rules.get(rid);r&&(console.log("deleting rule: "+r.get("name")),links.push(restDeleteResource(r)))}else if(0===l.indexOf("/userparameter")){let uid=l.split("/").pop(),u=app.userparameter.get(uid);u?(activeSegments=u.get("activeSegments"),console.log("deleting userparameter: "+u.id),links.push(restDeleteResource(u))):console.log("userparameter of control to delete not found")}else{if(!l.includes("/resourcelinks"))return;{let re=app.resourcelinks.get(l.split("/").pop());re&&re.get("classid")>30300?(console.log("deleting resourcelink: "+re.get("name")),links.push(deleteVirtualSensorResource(re))):re?re&&re.get("classid")<=30300&&console.log("do NOT delete resourcelink: "+re.get("name")+" with classid "+re.get("classid")):console.log("resourcelink of pircontrol link "+l.split("/").pop()+" is undefined")}}}),links.push(deleteDialControlRules(rl,pirControl,activeSegments)),Promise.all(links).then(result=>{var links2=[];links2.push(restDeleteResource(rl)),links2.push(restDeleteResource(pirControl)),Promise.all(links2).then(rsp=>{Promise.all([restGetResource(app.resourcelinks),restGetResource(app.rules),restGetResource(app.sensors)]).then(result=>{checkPirRulesConsistency()}).catch(err=>{console.log("Error: "+err)})}).catch(err=>{console.error("Error: "+err),Promise.all([restGetResource(app.resourcelinks),restGetResource(app.rules),restGetResource(app.sensors)]).then(result=>{checkPirRulesConsistency()}).catch(err=>{console.log("Error: "+err)})})}).catch(err=>{console.log("Error: "+err)})}