/*! phoscon-app 2025-05-20 */

export function initOverview(injectSwitchWizzardSvg,pageParams,searchInput){let tableView,bottomView;pageParams.constants.svgPathsThermostat;const OverviewView=Backbone.View.extend({el:"#overview",template:_.template(document.getElementById("thermostat-overview-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),tableView=new TableView,bottomView=new BottomView,this.searchInput=this.el.querySelector("#searchThermostat")},events:{"input #searchThermostat":"changeSearchField"},changeSearchField:_.debounce(function(ev){let searchViews=tableView.views||[],searchString=ev.currentTarget.value||"";searchInput(searchViews,searchString)},500),show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),EmptyView=Backbone.View.extend({el:".empty-div",template:_.template(document.getElementById("thermostat-empty-template").innerHTML),initialize:function(){this.el.innerHTML=this.template()},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),BottomView=Backbone.View.extend({el:"#bottom",template:_.template(document.getElementById("search-thermostat-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),this.searchText1=this.el.querySelector("#c_newLi_la"),this.emptyDiv=document.querySelector(".empty-div"),this.time=this.el.querySelector("#time"),this.timeLabels=this.time.querySelectorAll("span"),this.progressBar=this.el.querySelector("#progressBar"),this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne)},setSearchActive:function(){this.searchText1.textContent=translate("txt_searchThermostats"),document.body.classList.add("search-active"),this.emptyDiv.classList.add("search")},setSearchInactive:function(){document.body.classList.remove("search-active"),this.emptyDiv.classList.remove("search"),this.time.style.opacity=0},updateProgressBarSmooth:function(start,end,duration){let current=start;const step=(end-start)/(duration/50),interval=setInterval(()=>{(current+=step)>=end&&(clearInterval(interval),current=end),this.updateProgressBar(current)},50)},updateProgressBar:function(width){this.progressBar.style.width=width+"%"},setTimelabelOneMinute:function(){this.timeLabels[0].textContent=" ",this.timeLabels[1].textContent=translate("text_1min_remaining")},setTimelabelMinutesRemaining:function(min){this.time.classList.remove("hidden"),this.time.style.opacity=1,this.timeLabels[0].textContent=min+" ",this.timeLabels[1].textContent=translate("text_min_remaining")},setTimeLabelMinutes:function(min){this.timeLabels[0].textContent=min+" "}}),TableView=Backbone.View.extend({el:"#thermostatTable",collection:app.thermostats,initialize:function(){this.views=[],this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne),this.collection.forEach(this.addOne,this)},addOne:function(model){if(0==Object.keys(model.attributes).length)return;if(app.testEmptyState)return void console.log("don't add device in test empty state");let alreadyExists=this.views.find(function(view){return view.model.get("mac")===model.get("mac")});var th=app.thermostats.find(x=>x.get("id")===model.get("mac"));if(model.has("modelid")&&!th&&!alreadyExists){document.body.classList.remove("empty");var view=new TableRowView({model:model});this.$el.append(view.render().el),this.views.push(view)}},removeOne:function(model){let views=this.views.filter(v=>v.model.get("id")!==model.get("id"));this.views=views}}),TableRowView=Backbone.View.extend({tagName:"tr",template:_.template(document.getElementById("thermostat-item-template").innerHTML),initialize:function(){this.model.set("product",getDeviceProductName(this.model.attributes)),this.model.set("producttype",getDeviceProducttype(this.model.attributes)),this.model.on("change",this.render,this),this.model.on("destroy",this.remove,this);var html=this.template(this.model.attributes);this.el.innerHTML=html,this.$el.attr("data-snid",this.model.id),this.nameLabel=this.el.querySelector("td:nth-child(2)"),this.vendorLabel=this.el.querySelector("td:nth-child(3)"),this.productLabel=this.el.querySelector("td:nth-child(4)"),this.valTemp=this.el.querySelector("td:nth-child(5)"),this.valSetpoint=this.el.querySelector("td:nth-child(6)"),this.valuesLabelPhoneTablet=this.el.querySelector(".item-attr"),this.unit=" °C",-1!==navigator.language.indexOf("US")&&(this.unit=" °F"),this.service=null,this.render()},events:{click:function(){app.router.navigate("thermostat/"+this.model.id,{trigger:!0})}},render:function(){this.model.get("config").reachable||"PHDL00"===this.model.get("modelid")?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable");const name=this.model.get("name");this.nameLabel.querySelector(".name-val").textContent!==name&&(this.nameLabel.querySelector(".name-val").textContent=name);const product=this.model.get("product");this.productLabel.textContent!==product&&(this.productLabel.textContent=product);var vendor=this.model.get("vendor")||this.model.get("manufacturername");return vendor="PHDL00"===this.model.get("modelid")?"Phoscon":vendor,this.vendorLabel.textContent!==vendor&&(this.vendorLabel.textContent=vendor),getStateValues(this.model,this.unit).then(stateValues=>{this.valTemp.innerHTML=stateValues[0],this.valSetpoint.innerHTML=stateValues[1],this.valuesLabelPhoneTablet.innerHTML=stateValues[1]}),this}});return{overview:new OverviewView,emptyview:new EmptyView,tableView:tableView,bottomView:bottomView}};function getStateValues(model,unit){return new Promise((resolve,reject)=>{var thermostats=app.thermostats.filter(sn=>sn.get("mac")===model.get("mac"))||[],statesToShow=["temperature","heatsetpoint"],states={},values=[];for(var state in thermostats.forEach(sn=>{states=Object.assign(states,sn.get("state")||{}),(statesToShow.filter(s=>s in model.get("config"))||[]).forEach(state=>{states=Object.assign(states,{[state]:sn.get("config")[state]})})}),states)if(-1!==statesToShow.indexOf(state)){var value=states[state];"temperature"===state?(value/=100," °F"===unit&&(value=40),value=Math.round(2*value)/2,value+=unit):"heatsetpoint"===state&&(value/=100," °F"===unit&&(value=40),value=Math.round(2*value)/2,value+=unit),values.push(value)}resolve(values)})}