<!-- template for sensor details -->
<script type="text/us-templ" id="sensor-details-template">
    <div class="main-head">
        <h1>
            <img src="#" data-svgInject="switchWizzardSvg" data-wiz-page="none" class="svg-icon mq-desktop"/>
            <span><%- name %></span>
            <div class="item-edit pencil mq-desktop" data-toggle="modal" data-target="#renameSensorModal" data-swid="<%- id %>">
                <svg width="24" height="24"><use transform="scale(0.48)" xlink:href="#icon-rename" /></svg>
            </div>
        </h1>

        <a id="deleteSensor_btn" type="button" class="hdr-delete-btn mq-desktop" data-toggle="modal" data-target="#deleteSensorModal">
            <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#delete-icon-sm" /></svg>
            <span data-translateid="deleteSensor">Delete sensor</span>
        </a>

        <div class="mq-phone context-menu-box">
            <div class="context-menu-outer"></div>
            <svg class="context-menu-icon" width="24" height="24"><use transform="scale(0.48)" xlink:href="#dot-menu" /></svg>
            <ul class="context-menu">
                <li data-toggle="modal" data-target="#renameSensorModal" data-snid="<%- id %>">
                    <svg width="18" height="18"><use transform="scale(0.36)" xlink:href="#icon-rename" /></svg>
                    <span>Umbenennen</span>
                </li>
                <li data-toggle="modal" data-target="#deleteSensorModal">
                    <!-- templ-include: img/24px/delete.svg -->
                    <span>Löschen</span>
                </li>
            </ul>
        </div>
    </div>

    <div class="main-content">
        <img id="detailImg" src="#" data-svgInject="sensorWizzardSvg" data-wiz-page="none"/>

        <div id="detailInfos">
            <div class="detail-info-generals">
                <span data-translateid="th_vendor">Vendor</span> 
                <span class="details-content"><%- manufacturername %></span>
            </div>

            <div class="detail-info-generals">
                <span data-translateid="th_product">Product</span> 
                <span class="product data-val details-content">{product}</span>
            </div>

            <div class="not-reachable">
                <span data-translateid="th_status">State</span> 
                <span class="details-content" data-translateid="text_sensor_not_reachable"></span>
            </div>

            <div class="version">
                <span data-translateid="th_version">Version</span>
                <span class="data-val details-content">{swversion}</span>
            </div>

            <div class="battery hide">
                <span data-translateid="th_battery">Battery</span>
                <span class="data-val details-content">{battery}</span>
            </div>

            <div class="lowbattery hide">
                <span data-translateid="th_battery">Battery</span>
                <span class="data-val details-content">{lowbattery}</span>
            </div>

            <div class="temperature hide">
                <span data-translateid="th_temperature">Temperature</span>
                <span class="data-val details-content">{temperature}</span>
            </div>

            <div class="humidity hide">
                <span data-translateid="th_humidity">Humidity</span>
                <span class="data-val details-content">{humidity}</span>
            </div>

            <div class="moisture hide">
                <span data-translateid="th_moisture">Moisture</span>
                <span class="data-val details-content">{moisture}</span>
            </div>

            <div class="water hide">
                <span data-translateid="th_water">Water</span>
                <span class="data-val details-content">{water}</span>
            </div>

            <div class="lightlevel hide">
                <span data-translateid="th_lightlevel">Lightlevel</span>
                <span class="data-val details-content">{lightlevel}</span>
            </div>

            <div class="pressure hide">
                <span data-translateid="th_airpressure">Air pressure</span>
                <span class="data-val details-content">{pressure}</span>
            </div>

            <div class="open hide">
                <span data-translateid="th_state">State</span>
                <span class="data-val details-content">{open}</span>
            </div>

            <div class="presence hide">
                <span data-translateid="th_movement">Movement</span>
                <span class="data-val details-content">{presence}</span>
            </div>

            <div class="fire hide">
                <span data-translateid="th_fire">Fire</span>
                <span class="data-val details-content">{fire}</span>
            </div>

            <div class="carbonmonoxide hide">
                <span data-translateid="th_co">CO</span>
                <span class="data-val details-content">{carbonmonoxide}</span>
            </div>

            <div class="carbondioxide hide">
                <span data-translateid="th_co2">CO2</span>
                <span class="data-val details-content">{carbondioxide}</span>
            </div>

            <div class="formaldehyde hide">
                <span data-translateid="th_formaldehyde">Formaldehyde</span>
                <span class="data-val details-content">{formaldehyde}</span>
            </div>

            <div class="particularmatter hide">
                <span data-translateid="th_particular">Particular matter</span>
                <span class="data-val details-content">{particularmatter}</span>
            </div>

            <div class="alarm hide">
                <span data-translateid="th_alarm">Alarm</span>
                <span class="data-val details-content">{alarm}</span>
            </div>

            <div class="vibration hide">
                <span data-translateid="th_vibration">Vibration</span>
                <span class="data-val details-content">{vibration}</span>
            </div>

            <div class="airquality hide">
                <span data-translateid="th_airquality">Airquality</span>
                <span class="data-val details-content">{airquality}</span>
            </div>

             <div class="replacefilter hide">
                <span data-translateid="th_filter">Filter status</span>
                <span class="data-val details-content">{replacefilter}</span>
            </div>

             <div class="speed hide">
                <span data-translateid="th_speed">Speed</span>
                <span class="data-val details-content">{speed}</span>
            </div>

            <div class="lastupdated">
                <span data-translateid="th_lastupdated">Last seen</span>
                <span class="data-val details-content">{lastupdated}</span>
            </div>
        </div>
    </div>
</script>