/*! phoscon-app 2025-11-11 */

export const getResourceListView=c=>Backbone.View.extend({el:"#resourcelinks",template:_.template(document.getElementById("resourcelink-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),this.service=null,this.c=c,this.listView=new RlListView(this.c),this.head=this.el.querySelector(".resourcelinks-head"),this.headName=this.head.querySelector(".item-name"),this.listenTo(app,"swModelChanged",this.setHeadName)},events:{"click [data-btn-ev]:not(.disabled)":function(ev){let sendEv=ev.currentTarget.getAttribute("data-btn-ev"),rlid=ev.currentTarget.getAttribute("data-rlid")||void 0;this.service&&sendEv&&rlid?this.service.send({type:sendEv,rlid:rlid}):this.service&&sendEv&&!rlid&&this.service.send(sendEv)}},show:function(){this.el.parentNode.classList.add("resourcelinks")},hide:function(){this.el.parentNode.classList.remove("resourcelinks")},setActiveSwitch:function(swid){let sw=app.switches.get(swid);if(!sw)return;this.headName.innerText=sw.get("name");let headIcon=this.head.querySelector(".item-icon"),img=document.createElement("img"),iconPath=this.c.getSvgIconPath(sw,"img/switches/","svgPathsSwitches");var btnMap=getBtnMap(sw);-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&this.head.replaceChild(svg,headIcon)}).catch(console.log):(img.setAttribute("src",iconPath),img.classList.add("item-icon"),this.head.replaceChild(img,headIcon),this.c.injectSvg([img]))},setHeadName:function({model:model}){this.headName.innerHTML=model.get("name")}});const RlItemView=Backbone.View.extend({tagName:"a",className:"resourcelink list-group-item hidden",template:_.template(document.getElementById("resourcelinks-item-template").innerHTML),initialize:function({c:c,sw:sw,dataBtn:dataBtn}){if(this.c=c,void 0==dataBtn){let rule=app.rules.find(r=>r.get("id")===this.model.attributes.links[2].split("/")[2]);"gt"==rule.attributes.conditions[0].operator&&(dataBtn="5000"),"lt"==rule.attributes.conditions[0].operator&&(dataBtn="6000")}let itemData=c.getRlDataMap(this.model);if(!itemData)return;if(this.renderModel={name:translate(itemData.translateid),transIdName:itemData.translateid,info:translate(this.model.get("name")),transIdInfo:this.model.get("name"),btn:dataBtn,btnGeneric:"",btnVal:""},this.model.get("classid")==this.c.CLASSIDCALLSCENE){let scene=this.c.helperFuncs.getScene(this.model);this.renderModel.info=this.renderModel.info+scene.get("name")}this.el.innerHTML=this.template(this.renderModel),this.el.setAttribute("data-rlid",this.model.get("id")),this.el.setAttribute("data-swid",sw.get("id")),sw.get("id")==app.session.swid&&this.el.classList.remove("hidden"),this.el.setAttribute("data-btn-ev","RL_PRESSED"),this.listenTo(this.model,"change",this.render),this.listenTo(this.model,"destroy",this.remove),this.icon=this.el.querySelector(".item-icon");let iconPath=this.c.getSvgIconPath(sw,"img/switches/","svgPathsSwitches");-1===sw.get("modelid").indexOf("lumi.sensor_cube")&&-1===sw.get("modelid").indexOf("lumi.remote.cagl")||(iconPath="img/switches/xiaomi/48px/xiaomi-magic-cube-gesture-icon.svg#xiaomi-aqara-cube-gestures-icon");var btnMap=getBtnMap(sw);-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&(svg.setAttribute("class","item-icon"),this.icon.replaceWith(svg))}).catch(console.log):(this.icon.setAttribute("src",iconPath),this.c.injectSvg([this.icon])),this.el.style.setProperty("--btn-"+dataBtn,"0.6"),"RDM002"!=sw.get("modelid")||5e3!=dataBtn&&6e3!=dataBtn||this.el.classList.add("tap-icons-none")},render:function(sw){return this}}),RlItemGroupModeView=Backbone.View.extend({tagName:"a",className:"resourcelink list-group-item hidden",template:_.template(document.getElementById("resourcelinks-item-template").innerHTML),initialize:function({model:model,c:c}){this.model=model,this.c=c;let m={name:translate("func_dimming"),transIdName:"func_dimming",info:translate("opt_pushDim"),transIdInfo:"opt_pushDim",btn:"",btnGeneric:"",btnVal:""};this.el.innerHTML=this.template(m),this.el.setAttribute("data-rlid","groupMode"),this.el.setAttribute("data-swid",this.model.get("id")),this.el.setAttribute("data-btn-ev","RL_PRESSED"),this.$el.css("--btn-1000","0.6"),this.icon=this.el.querySelector(".item-icon");let iconPath=this.c.getSvgIconPath(this.model,"img/switches/","svgPathsSwitches");var d=app.devices.get(this.model.get("uniqueid")),btnMap=d?d.attributes:void 0;-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&(svg.setAttribute("class","item-icon"),this.icon.replaceWith(svg))}).catch(console.log):(this.icon.setAttribute("src",iconPath),this.c.injectSvg([this.icon]))},render:function(){return this}}),RlListView=Backbone.View.extend({el:"#activeSwRlList",initialize:function(c){this.c=c,this.service=null,this.views=[],this.listenTo(app.resourcelinks,"add",this.addRl),this.listenTo(app,"swToGroupMode",this.renderGroupMode),this.listenTo(app,"removeSwGroupMode",this.destroyGroupModeModel),app.resourcelinks.models.forEach(rl=>{let classid=rl.get("classid");!classid||classid<c.SW_CLASSID_MIN||classid>c.SW_CLASSID_MAX||this.addRl(rl)}),app.switches.forEach(sw=>{sw.get("config").group&&hasConfigGroup(sw,app.session.gid)&&this.renderGroupMode(sw)})},renderGroupMode:function(model){let view=this.views.find(v=>v.model===model);view||(view=new RlItemGroupModeView({model:model,c:this.c}),this.el.appendChild(view.render().el),this.views.push(view))},destroyGroupModeModel:function(model){let view=this.views.find(v=>v.model===model);view&&view.remove()},addRl:function(rl){let classid=rl.get("classid");classid!=this.c.CLASSIDBRIDIMUP&&classid!=this.c.CLASSIDBRIDIMDOWN&&checkResourcelink(rl,this.c).then(({rl:rl,sw:sw,dataBtn:dataBtn})=>{console.log(dataBtn);let view=this.views.find(v=>v.model.attributes.links[1]===rl.attributes.links[1]);view=new RlItemView({model:rl,c:this.c,sw:sw,dataBtn:dataBtn}),this.el.insertBefore(view.render().el,this.el.firstChild),this.views.push(view);try{let rlid=this.el.attributes[0].baseURI,parts=rlid.split("/");const lastPart=parts[parts.length-1];if(null!==lastPart&&void 0!==lastPart&&lastPart.match(/\d+$/)){const lastNumber=lastPart.match(/\d+$/)[0];rlid=lastNumber,this.views.forEach(v=>{v.el.getAttribute("data-rlid")==rlid?v.el.classList.add("active-rl"):v.el.classList.remove("active-rl")})}else console.log("Skipping processing because lastPart is null or undefined.")}catch(error){console.error("An error occurred while processing the RL ID:",error)}}).catch(err=>console.log(err))},showActiveSWResourcelinks:function(swid){this.views.forEach(v=>{v.el.getAttribute("data-swid")!=swid?v.el.classList.add("hidden"):v.el.classList.remove("hidden")})},setRlActive:function(rlid){rlid&&this.views.forEach(v=>{v.el.getAttribute("data-rlid")==rlid?v.el.classList.add("active-rl"):v.el.classList.remove("active-rl")})}});function checkResourcelink(rl,c){return new Promise((resolve,reject)=>{var sw=void 0;let classid=rl.get("classid");classid||reject("no classid found"),(classid<c.SW_CLASSID_MIN||classid>c.SW_CLASSID_MAX)&&reject("classid not between min and max"),classid!=c.CLASSIDBRIDIMUP&&classid!=c.CLASSIDBRIDIMDOWN||"opt_briDimDown"!=rl.get("name")&&"opt_briDimUp"!=rl.get("name")||reject("classid == subfunction"),rl.isNew()&&setTimeout(()=>checkResourcelink(rl,c),100);let links=rl.get("links")||[],gid=getRlGroupId(links);gid!=app.session.gid&&0!=gid&&reject("gid not active group"),getRlSensorIds(links).then(sIds=>{if(sIds.forEach(id=>{let sn=getSensorFromId(id);sn&&-1===sn.get("type").indexOf("CLIP")&&((sw=app.switches.get(sn.get("mac")))||reject("switch not found"))}),sw)return getRlButtonEvent(rl,sw)}).then(dataBtn=>{resolve({rl:rl,sw:sw,dataBtn:dataBtn})}).catch(console.log)})}function getRlButtonEvent(rl,sw){return new Promise((resolve,reject)=>{let btn,val,dataBtn,rules=rl.get("links")||[];rules=rules.filter(x=>-1!==x.indexOf("rule")).map(x=>x.split("/")[2]);let modelId=sw.get("modelid");rules.forEach(rid=>{if(btn)return;const r=app.rules.get(rid);if(!r||!r.has("conditions"))return;const c=r.get("conditions").filter(c=>c.address&&c.value).find(c=>(-1!==c.address.indexOf("buttonevent")||-1!==c.address.indexOf("gesture"))&&c.value>0);c&&(val=c.value,btn=(btn=c.value/1e3).toFixed(0),dataBtn=1e3*btn,(["lumi.sensor_switch","lumi.sensor_switch.aq2","lumi.remote.b1acn01","lumi.sensor_switch.aq3","button"].find(x=>x===modelId)||-1!==modelId.indexOf("lumi.sensor_cube")||-1!==modelId.indexOf("lumi.remote.cagl"))&&(dataBtn=val))}),resolve(dataBtn)})}function getRlGroupId(links){return links.find(l=>-1!==l.indexOf("/groups/")).split("/")[2]}function getRlSensorIds(links){return new Promise((resolve,reject)=>{resolve(links.filter(l=>-1!==l.indexOf("/sensors/")).map(item=>item.split("/")[2]))})}function getSensorFromId(id){return app.sensors.find(s=>s.get("id")===id||s.get("uniqueid")===id)}function hasConfigGroup(sw,gid){if(sw.attributes.config&&sw.attributes.config.group){return-1!==(sw.get("config").group||"").split(",").indexOf(gid)}return!1}function getBtnMap(sw){var d=app.devices.get(sw.get("uniqueid")),btnMap=d?d.attributes:void 0;if("RDM001"===sw.get("modelid")||"RDM004"===sw.get("modelid")){let mode=sw.get("config").devicemode;btnMap="dualpushbutton"===mode||"dualrocker"===mode?{buttons:{1:{name:"left button"},2:{name:"right button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1},2001:{action:"HOLD",button:2},2002:{action:"SHORT_RELEASE",button:2},2003:{action:"LONG_RELEASE",button:2}}}:{buttons:{1:{name:"middle button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1}}}}return btnMap}