/*! phoscon-app 2025-11-11 */

export function initOverview(injectSwitchWizzardSvg,pageParams){let tableView,getSvgIconPath=pageParams.constants.getSvgIconPath||null,sortView=!1;if(!getSvgIconPath)throw new Error("getSvg function is missing, initOverview");const OverviewView=Backbone.View.extend({el:"#overview",template:_.template(document.getElementById("switch-overview-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),tableView=new TableView},events:{},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),EmptyView=Backbone.View.extend({el:".empty-div",template:_.template(document.getElementById("switch-empty-template").innerHTML),initialize:function(){this.el.innerHTML=this.template()},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),TableView=Backbone.View.extend({el:"#switchTable",collection:app.switches,initialize:function(){this.views=[],this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne),this.listenTo(this.collection,"sort",this.sortList),this.collection.forEach(this.addOne,this)},sortList:function(){if(!1===sortView)return;sortView=!1;let sortKey=this.collection.sortKey,elem=document.querySelector('[data-sort="'+sortKey+'"] svg'),cl=elem?elem.classList:null;$('b:not([data-sort="'+sortKey+'"]) svg').removeClass("sort-asc"),$('b:not([data-sort="'+sortKey+'"]) svg').removeClass("sort-desc"),cl.contains("sort-asc")?(elem.classList.remove("sort-asc"),elem.classList.add("sort-desc"),this.collection.models.reverse()):(elem.classList.add("sort-asc"),elem.classList.remove("sort-desc")),this.views=[],this.$el.empty(),this.reload()},reload:function(){this.collection.forEach(this.addOne,this)},addOne:function(model){if(app.testEmptyState)console.log("don't add device in test empty state");else if(model.has("modelid")&&-1===model.get("modelid").indexOf("lumi.vibration")){var view=new TableRowView({model:model});this.$el.append(view.render().el),this.views.push(view)}},removeOne:function(model){let views=this.views.filter(v=>v.model.get("id")!==model.get("id"));this.views=views,0!==this.views.length&&-1===window.location.hash.indexOf(model.get("id"))||app.router.navigate("table",{trigger:!0})}}),TableRowView=Backbone.View.extend({tagName:"tr",template:_.template($("#switch-item-template").html()),initialize:function(){this.model.on("change",this.render,this),this.model.on("change",this.onChange,this),this.model.on("destroy",this.remove,this);var html=this.template(this.model.attributes);this.$el.html(html),this.$el.attr("data-swid",this.model.id),this.nameLabel=this.el.querySelector("td:nth-child(2)"),this.vendorLabel=this.el.querySelector("td:nth-child(3)"),this.productLabel=this.el.querySelector("td:nth-child(4)"),this.iconImg=this.el.querySelector(".item-icon"),this.modelid=this.model.get("modelid"),this.model.set("product",getDeviceProductName(this.model.attributes));var iconPath=getSvgIconPath(this.model,"img/switches/","svgPathsSwitches"),d=app.devices.get(this.model.get("uniqueid")),btnMap=d?d.attributes:void 0;if("RDM001"===this.model.get("modelid")||"RDM004"===this.model.get("modelid")){let mode=this.model.get("config").devicemode;btnMap="dualpushbutton"===mode||"dualrocker"===mode?{buttons:{1:{name:"left button"},2:{name:"right button"}}}:{buttons:{1:{name:"middle button"}}}}-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&this.iconImg.replaceWith(svg)}).catch(console.log):(this.iconImg.setAttribute("src",iconPath),injectSwitchWizzardSvg([this.iconImg])),this.service=null,this.render()},events:{click:function(){let id=this.model.get("id");app.router.navigate("switch/"+id,{trigger:!0})}},onChange:function(model){let change=model.changed;if(!change)return;let changeSize=_.size(change);if(change.buttonevent||1==changeSize&&change.lastupdated){let id=this.model.get("id"),elem=document.querySelector('[data-swid="'+id+'"]');if(7e3===model.get("buttonevent"))return;var rect=elem.getBoundingClientRect();rect.top<0?(document.querySelector("#tableArrowTop").classList.add("active-sw"),setTimeout(()=>{document.querySelector("#tableArrowTop").classList.remove("active-sw")},600)):rect.bottom>(window.innerHeight||document.documentElement.clientHeight)&&(document.querySelector("#tableArrowBottom").classList.add("active-sw"),setTimeout(()=>{document.querySelector("#tableArrowBottom").classList.remove("active-sw")},600)),elem.classList.add("active-row"),setTimeout(()=>{elem.classList.remove("active-row")},1e3)}},render:function(){this.model.get("reachable")?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable");const name=this.model.get("name");this.nameLabel.textContent!==name&&(this.nameLabel.textContent=name);const vendor=this.model.get("vendor")||this.model.get("manufacturername");this.vendorLabel.textContent!==vendor&&(this.vendorLabel.textContent=vendor);const product=this.model.get("product");return this.productLabel.textContent!==product&&(this.productLabel.textContent=product),this}});return{overview:new OverviewView,emptyview:new EmptyView,tableView:tableView}};