/*! phoscon-app 2025-11-11 */

import{DeviceItemView}from"./device-item-view.js";import{getOnOffView}from"../main/room-on-off-view.js";import{SceneItemView,ScheduleItemView,OtherItemView}from"../groups-page/control-views.js";import{eventSettingsExpanded,updateNewChartData,findMatchingRoomData,addSensorValuetoRoomNew,restoreIntervals,getColumns,toggleRoomExpansion,closeFavouriteChart}from"./dashboard-functions.js";const roomViewIntervals={};export const getRoomView=(constants,service)=>{let currentOpenDropdown=null;const RoomItemView=Backbone.View.extend({tagName:"li",className:"roomItemView",template:_.template($("#roomItemViewTemplate").html()),initialize:async function(){if(this.$el.html(this.template(this.model)),this.service=service,this.placeholderName,this.roomNameInput=document.querySelector("#roomRenameModal input"),this.orignalDragDevice,this.roomid=this.model.get("id"),this.name=this.model.get("name"),this.expanded="true"===localStorage.getItem(`${this.roomid}_expanded`),this.roomList=document.querySelector("#roomList"),this.roomDeviceItemViews=[],this.resourcelink=void 0,this.lastHoveredElement=null,this.favoriteSensorValue=void 0,this.dropPlaceHolder=!1,this.isDraggingDevice=!1,this.checkRoomDrag=!1,this.isDraggableMobile=!1,this.isButtonClickRooms=!1,this.cloneElement=void 0,this.checkLongPressTimeout=null,this.roomOnOffButton=this.el.querySelector("#btn-group-control"),this.isOpeningChart=!1,this.scrollInterval=null,this.roomList.classList.contains("disable-dragging")?(this.el.setAttribute("draggable",!0),this.el.addEventListener("dragstart",this.eventRoomDragStart.bind(this)),this.el.addEventListener("dragover",this.eventRoomDragOver.bind(this)),this.el.addEventListener("drop",this.eventRoomDrop.bind(this)),this.el.addEventListener("dragleave",this.eventRoomDragLeave.bind(this)),this.el.addEventListener("touchstart",this.eventRoomTouchStart.bind(this),{passive:!1}),this.el.addEventListener("touchmove",this.throttle(this.eventRoomTouchMove.bind(this),100),{passive:!1}),this.el.addEventListener("touchend",this.eventRoomTouchEnd.bind(this),{passive:!1}),this.el.addEventListener("touchcancel",this.eventRoomTouchCancel.bind(this),{passive:!1})):this.el.setAttribute("draggable",!1),app.resourcelinks.forEach(link=>{6e3===link.get("classid")&&link.attributes.name.split(" ")[1]==this.roomid&&(this.resourcelink=link)}),!this.resourcelink){let group=app.groups.get(this.roomid);if(group&&group.get("lights")){let groupLights=[];group.get("lights").forEach(lid=>{groupLights.push("/lights/"+lid)});let rlId=await restCreateResource(app.resourcelinks,{name:"room "+this.roomid,description:"Link to contain groups, scenes and devices inside a room",classid:6e3,links:groupLights});await restGetResource(app.resourcelinks),this.resourcelink=app.resourcelinks.get(rlId)}}this.listenTo(app.sensors,"change",this.renderRoomsFavorites),this.listenTo(app.sensors,"change",this.eventUpdateChart),this.listenTo(this.model,"change",this.toggleOnOffIcon),this.render()},events:{'click [data-btn-ev="DASHBOARD_ROOM_CLICKED"]':"eventRoomClicked",'pointerdown [data-btn-ev="DASHBOARD_ROOM_OFF"]':"eventRoomOffClicked",'pointerup [data-btn-ev="DASHBOARD_ROOM_OFF"]':"eventCheckRoomOffLongPress",'click [data-btn-ev="DASHBOARD_ROOM_EXPANDED"]':"eventRoomExpanded",'click [data-btn-ev="DASHBOARD_ROOM_SETTINGS"]':"expandSettings",'click [data-btn-ev="DASHBOARD_ROOM_RENAME"]':"eventRoomRename",'click [data-btn-ev="DASHBOARD_DEVICE_SETTINGS"]':"eventRoomSettings"},render:function(){const chartBtn=this.el.querySelector('[data-btn-ev="DASHBOARD_UPDATE_CHART"]');chartBtn?(chartBtn.disabled=!0,chartBtn.classList.add("hidden")):(chartBtn.disabled=!1,chartBtn.classList.remove("hidden")),this.cloneElement&&(this.cloneElement.remove(),this.cloneElement=null),this.model.get("state")&&(this.model.get("state").any_on||this.model.get("state").all_on)?this.roomOnOffButton.classList.remove("li-off"):this.roomOnOffButton.classList.add("li-off"),this.roomDeviceItemViews.forEach(itemView=>{itemView.stopListening(),itemView.remove()}),this.roomDeviceItemViews=[],this.resourcelink.attributes.links.forEach(link=>{let device=null,linksplit=link.split("/");"lights"==linksplit[1]&&(device=app.lights.get(linksplit[2])),"sensors"==linksplit[1]&&(device=app.sensors.get(linksplit[2])),"blinds"==linksplit[1]&&(device=app.lights.get(linksplit[2])),"thermostats"==linksplit[1]&&(device=app.sensors.get(linksplit[2])),"groups"==linksplit[1]&&(device=app.groups.get(linksplit[2])),device&&this.addDevice(device,linksplit[1])}),this.model.get("scenes")&&this.model.get("scenes").forEach(scene=>{this.addScene(scene)}),app.schedules.models.forEach(schedule=>{schedule.get("command").address.split("/")[4]===this.roomid&&this.addSchedule(schedule)});let roomElements=countRoomElements(this.model.get("id")),isPhone=!(!screenMax(SCREEN_MAX_WIDTH_PHONE_LANDSCAPE)||!isThisPortrait());return(0!==roomElements.automations||0!==roomElements.sensorControls&&!isPhone||0!==roomElements.switches)&&this.addOther(roomElements),this.getMainColumn=document.querySelector(".column"),this.deviceArrow=this.el.querySelector(".deviceValueSelect"),this.nameField=this.el.querySelector("#roomName"),this.favoriteSensorValue=this.el.querySelector("#favSensorValue"),this.favoriteSensorSvg=this.el.querySelector("#favSensorSvg"),this.dropDownSettings=this.el.querySelector(".dropdown-content"),this.expand_icon=this.el.querySelector("#expand_icon"),this.drag_placeholder=this.el.querySelector(".drag-placeholder"),this.noDeviceTest=this.el.querySelector("#noDevices"),this.deviceList=this.el.querySelector("#roomDeviceItemList"),this.roomListItem=this.el.querySelector("#roomDeviceItemList"),this.favouriteChart=this.el.querySelector("#favouriteChart"),this.column=this.el.querySelector("#column"),this.nameField&&(this.nameField.textContent=this.name),this.expanded?(this.expand_icon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#collapse-icon"></use>',this.el.classList="roomItemView expanded"):(this.expand_icon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#expand-icon"></use>',this.el.classList="roomItemView"),0==this.roomDeviceItemViews.length?this.noDeviceTest.classList.remove("hidden"):this.noDeviceTest.classList.add("hidden"),this.deviceList.innerHTML="",this.roomDeviceItemViews.forEach(view=>{this.deviceList.appendChild(view.el),this.deviceList.classList.remove("hidden")}),this.el.querySelector("#roomSettingsRename").innerHTML=translate("text_rename"),this.el.querySelector("#roomSettingsFavourite").innerHTML=translate("text_favourite"),this.el.querySelector("#roomSettingsSettings").innerHTML=translate("text_settings"),this.el.querySelector("#roomSettingsOnOff").innerHTML=translate("text_roomOnoff"),this.el.querySelector("#roomSettingsDelete").innerHTML=translate("text_delete"),this},updateName:function(name){this.nameField.textContent=name},throttle:function(func,limit){let lastFunc,lastRan;return function(...args){lastRan?(clearTimeout(lastFunc),lastFunc=setTimeout(function(){Date.now()-lastRan>=limit&&(func.apply(this,args),lastRan=Date.now())},limit-(Date.now()-lastRan))):(func.apply(this,args),lastRan=Date.now())}},quickToggleOnOffIcon:function(on){on?this.roomOnOffButton.classList.remove("li-off"):this.roomOnOffButton.classList.add("li-off")},toggleOnOffIcon:function(){this.model.get("state")&&(this.model.get("state").any_on||this.model.get("state").all_on?this.roomOnOffButton.classList.remove("li-off"):this.roomOnOffButton.classList.add("li-off"))},eventRoomOffClicked:function(event){this.checkLongPressTimeout=setTimeout(()=>{this.evaluateLongPress()},500)},eventCheckRoomOffLongPress:function(){null!==this.checkLongPressTimeout&&(clearTimeout(this.checkLongPressTimeout),this.checkLongPressTimeout=null,service.send({type:constants.events.DASHBOARD_ROOM_OFF,view:this}))},evaluateLongPress:function(){clearTimeout(this.checkLongPressTimeout),this.checkLongPressTimeout=null,app.lightSliderViews.selectLight(this.model),document.getElementById("deviceValueSettingsOuter").classList.remove("hidden")},eventRoomSettings:function(event){},eventRoomDragStart:function(event){event.stopPropagation();var draggedItem=event.target.closest("li.roomItemView");if(draggedItem){this.placeholder=this.model.attributes.name,app.roomViews.checkRoomDrag=!1,app.roomViews.orignalDragDevice=draggedItem,event.dataTransfer.setData("text/plain",this.roomid);var dragImage=draggedItem.cloneNode(!0);event.dataTransfer.setDragImage(dragImage,0,0)}},eventRoomDragOver:function(event){event.preventDefault(),event.stopPropagation();let hoveredElement=event.target.closest(".roomItemView");this.handleHoverHighlight(hoveredElement);const rect=hoveredElement.getBoundingClientRect(),existingPlaceholder=document.querySelector(".placeholder");if(hoveredElement){existingPlaceholder&&existingPlaceholder.remove(),this.lastHighlightedElement=hoveredElement;const mouseY=event.clientY;let newPlaceholder=this.createPlaceholder();newPlaceholder.style.height=`${Math.min(hoveredElement.offsetHeight,150)}px`,mouseY<rect.bottom&&(hoveredElement.parentNode.insertBefore(newPlaceholder,hoveredElement.nextSibling),newPlaceholder.classList.add("visible"))}else existingPlaceholder&&existingPlaceholder.remove();let newExistingPlaceholder=document.querySelector(".placeholder");newExistingPlaceholder&&(newExistingPlaceholder.textContent=app.roomViews.orignalDragDevice.innerText.split("\n")[0].trim())},eventRoomDrop:async function(event){const existingPlaceholder=document.querySelector(".placeholder");if(event.dataTransfer&&this.lastHoveredElement){const draggedRoomHoverId=event.dataTransfer.getData("text/plain")||this.lastHoveredElement.dataset.roomid;if(!draggedRoomHoverId)return;const draggedRoomView=document.querySelector(`[data-roomid="${draggedRoomHoverId}"]`);if(!app.roomViews.isDraggingDevice&&draggedRoomView){this.el.parentNode.insertBefore(draggedRoomView,existingPlaceholder),existingPlaceholder.remove(),await this.updateRoomOrder(),app.roomViews.checkRoomDrag=!0}}this.isDragging=!1},eventRoomDragLeave:function(event){this.lastHoveredElement&&(this.lastHoveredElement.classList.remove("highlighted"),this.lastHoveredElement.style.boxShadow="",this.lastHoveredElement=null)},preventDefaultHandler(event){this.isDragging&&event.preventDefault()},eventRoomTouchStart:function(event){if(event.touches&&event.touches.length>0){/Mobi|Android/i.test(navigator.userAgent)&&event.preventDefault()}if(this.isDragging=!0,this.isButtonClickRooms)return;this.draggedRoomId=event.currentTarget.dataset.roomid;const clone=document.createElement("div");clone.classList.add("dragged-clone");const roomText=document.createElement("span");roomText.textContent=this.model.attributes.name,clone.appendChild(roomText);const touchLocation=event.targetTouches[0];this.lastTouchLocation=[touchLocation.pageX,touchLocation.pageY],this.updateClonePosition(clone,touchLocation),document.body.appendChild(clone),this.cloneElement=clone},eventRoomTouchMove:async function(event){const touch=event.touches[0],closestRoomItemView=document.elementFromPoint(touch.clientX,touch.clientY).closest(".roomItemView");this.handleHoverHighlight(closestRoomItemView),this.cloneElement&&this.updateClonePosition(this.cloneElement,touch);const existingPlaceholder=document.querySelector(".placeholder"),parent=closestRoomItemView?closestRoomItemView.parentNode:null;if(closestRoomItemView){if(existingPlaceholder)existingPlaceholder.style.height=`${closestRoomItemView.offsetHeight}px`,existingPlaceholder.textContent=this.model.attributes.name,this.dropPlaceHolder=!0,existingPlaceholder.nextSibling!==closestRoomItemView&&(closestRoomItemView.nextSibling?parent.insertBefore(existingPlaceholder,closestRoomItemView):parent.appendChild(existingPlaceholder));else{let newPlaceholder=this.createPlaceholder();newPlaceholder.style.height=`${Math.min(closestRoomItemView.offsetHeight,150)}px`,newPlaceholder.textContent=this.model.attributes.name,newPlaceholder.classList.add("visible"),this.dropPlaceHolder=!0,closestRoomItemView.nextSibling?parent.insertBefore(newPlaceholder,closestRoomItemView):parent.appendChild(newPlaceholder)}this.lastHoveredElement=closestRoomItemView}else existingPlaceholder&&existingPlaceholder.remove(),this.lastHoveredElement=null},eventRoomTouchEnd:function(event){clearInterval(this.scrollInterval),this.scrollInterval=null;const existingPlaceholder=document.querySelector(".placeholder");existingPlaceholder&&(this.lastHoveredElement?this.eventRoomDropMobile(this.draggedRoomId):existingPlaceholder.remove()),this.cloneElement&&(this.cloneElement.remove(),this.cloneElement=null),this.isDragging=!1,event.currentTarget.style.display="",document.querySelectorAll(".roomItemView").forEach(roomItem=>{roomItem.classList.remove("expanded")})},eventRoomDropMobile:function(draggedRoomHoverId){const draggedRoomView=document.querySelector(`[data-roomid="${draggedRoomHoverId}"]`),existingPlaceholder=document.querySelector(".placeholder");if(draggedRoomView&&existingPlaceholder){existingPlaceholder.parentNode.insertBefore(draggedRoomView,existingPlaceholder),existingPlaceholder.remove();const existingPlaceholderRemove=document.querySelector(".placeholder");existingPlaceholderRemove&&existingPlaceholderRemove.remove(),this.updateRoomOrder()}else this.eventRoomTouchCancel()},updateClonePosition:function(clone,touch){requestAnimationFrame(()=>{clone.style.transform=`translate(${touch.pageX-clone.offsetWidth/2}px, ${touch.pageY-clone.offsetHeight/2}px)`;const currentY=touch.clientY,container=document.querySelector("#mainContainer");this.isDragging&&(container&&currentY<300?this.scrollInterval||(this.scrollInterval=setInterval(()=>{container.scrollBy(0,-5)},16)):container&&currentY>window.innerHeight-200?this.scrollInterval||(this.scrollInterval=setInterval(()=>{container.scrollBy(0,5)},16)):(clearInterval(this.scrollInterval),this.scrollInterval=null))})},handleHoverHighlight:function(closestRoomItemView){this.lastHoveredElement&&(this.lastHoveredElement.classList.remove("highlighted"),this.lastHoveredElement.style.boxShadow=""),closestRoomItemView?(closestRoomItemView.classList.add("highlighted"),closestRoomItemView.style.boxShadow="0 0 5px white",this.lastHoveredElement=closestRoomItemView):this.lastHoveredElement=null},eventRoomTouchCancel:function(event){const existingPlaceholder=document.querySelector(".placeholder");existingPlaceholder&&existingPlaceholder.remove()},createPlaceholder:function(){const placeholder=document.createElement("div");return placeholder.classList.add("placeholder"),placeholder.classList.add("roomItemView"),placeholder},updateRoomOrder:function(){const roomData={};document.querySelectorAll(".column").forEach((column,index)=>{const roomItems=column.querySelectorAll(".roomItemView");roomData[index]=[],roomItems.forEach(item=>{const roomId=item.dataset.roomid;roomData[index].push(roomId)})}),localStorage.setItem("roomOrder",JSON.stringify(roomData)),debouncedSaveLocalStorageToUserParameter()},loadCheckboxState:function(checkboxName,checkbox){const savedState=localStorage.getItem(checkboxName);null!==savedState&&(checkbox.checked="true"===savedState,checkbox.dispatchEvent(new Event("change")))},expandSettings:async function(event){app.session.gid=event.currentTarget.parentElement.parentElement.parentElement.parentElement.dataset.roomid,event.preventDefault(),app.session.roomOnOffView=getOnOffView(app.session.gid),currentOpenDropdown&&currentOpenDropdown!==this&&currentOpenDropdown.closeSettings(),currentOpenDropdown=this,eventSettingsExpanded(this,this.dropDownSettings,this.favoriteSensorValue),$(document).off("click.dropdownContent touchstart.dropdownContent keydown.dropdownContent"),$(document).on("touchstart.dropdownContent click.dropdownContent",event=>{const $target=$(event.target);$target.closest(this.el).length||$target.closest(".dropdownContent").length||$target.closest(this.dropDownSettings).length||$target.closest("#deviceItemView").length||$target.closest("#roomDeviceItemList").length||this.closeSettings();const targetModal={roomSettingsFavourite:"#favouriteRoomModal",roomSettingsSettings:"#roomSettingsModal",roomSettingsDelete:"#roomDeleteModal",roomSettingsRename:"#roomRenameModal"}[event.target.id];targetModal&&"touchstart"===event.type&&($(targetModal).modal("show"),this.closeSettings(),this.render())}),$("ul#roomDeviceItemList, #noDevices").click(function(event){let dropdowns=document.getElementsByClassName("dropdownContent");for(let i=0;i<dropdowns.length;i++)dropdowns[i].classList.remove("show")}),$(this.dropDownSettings).find("li").on("click",()=>{this.closeSettings()}),$(document).on("keydown.dropdownContent",event=>{"Escape"===event.key&&this.closeSettings()})},closeSettings:function(){this.dropDownSettings.classList.remove("show"),currentOpenDropdown===this&&(currentOpenDropdown=null),$(document).off("click.dropdownContent"),currentOpenDropdown===this&&(currentOpenDropdown=null)},eventRoomRename:function(event){if(this.roomNameInput.value=this.model.get("name"),"touchstart"===event.type){$("#roomRenameModal").modal("show")}},addDevice:function(model,type){let view=this.roomDeviceItemViews.find(view=>view.model===model);view||((view=new DeviceItemView({model:model,service:this.service,parentRoomView:this})).render(),this.roomDeviceItemViews.push(view))},addScene:function(model){let view=this.roomDeviceItemViews.find(view=>view.model===model);view||(view=new SceneItemView({model:model}),this.el.appendChild(view.el),this.roomDeviceItemViews.push(view))},addSchedule:function(model){let view=this.roomDeviceItemViews.find(view=>view.model===model);view||(view=new ScheduleItemView({model:model}),this.el.appendChild(view.el),this.roomDeviceItemViews.push(view))},addOther:function(roomElements){let view=new OtherItemView(roomElements);this.el.appendChild(view.el),this.roomDeviceItemViews.push(view)},eventRoomClicked:function(event){storeBackHash(),app.session.roomId=this.model.get("id"),app.session.gid=this.model.get("id"),document.querySelector("#group-wrapper").setAttribute("data-group-id",this.model.get("id")),app.session.groupType="lights",app.session.roomName=this.model.get("name"),app.router.navigate("groups",{trigger:!0})},eventSettingsExpanded:eventSettingsExpanded,renderRoomsFavorites:async function(){findMatchingRoomData(this.model,this)},createCloseButton:function(){let button=document.createElement("button");return button.type="button",button.className="close",button.setAttribute("data-btn-ev","DASHBOARD_CHART_CLOSE"),button.style.position="absolute",button.innerHTML="&times;",button.onclick=(()=>closeFavouriteChart(this.chartUpdateIntervalId)),button},createLegendChart:function(dataType){let sensor,sensorName,legend=document.createElement("div");legend.id="custom-legend-container";const svgIcon=document.createElementNS("http://www.w3.org/2000/svg","svg");if(svgIcon.setAttribute("width","20"),svgIcon.setAttribute("height","20"),"voltage"===dataType||"power"===dataType||"consumption"===dataType||"current"===dataType?(svgIcon.innerHTML='<use transform="scale(0.3)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#socket-icon"></use>',svgIcon.classList.add("li-off"),this.favoriteSensorValue&&this.favoriteSensorValue.dataset&&(sensor=app.lights.get(this.favoriteSensorValue.dataset.id))):(svgIcon.innerHTML='<use transform="scale(0.3)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#generic-sensor-icon"></use>',this.favoriteSensorValue&&this.favoriteSensorValue.dataset&&(sensor=app.sensors.get(this.favoriteSensorValue.dataset.id))),sensor&&(sensorName=sensor.get("name")),legend.appendChild(svgIcon),sensorName){let nameLabel=document.createElement("span");nameLabel.innerHTML=sensorName,legend.appendChild(nameLabel)}return legend},generateUniqueId:async function(event){return"chart-"+Math.random().toString(36).substr(2,9)},eventOpenChart:async function(event){let roomId=event.delegateTarget.getAttribute("data-roomid"),favChart=null;if(Object.keys(roomViewIntervals).forEach(intervalKey=>{clearInterval(roomViewIntervals[intervalKey]),delete roomViewIntervals[intervalKey]}),closeFavouriteChart(),!event)return;let sensorValue=event.currentTarget,dataType=event.currentTarget.getAttribute("data-type");if("sunrise"===dataType||"sunset"===dataType)return;localStorage.setItem("dataType",JSON.stringify([dataType]));let storedFav=[];(JSON.parse(localStorage.getItem("ChartIdStorage"))||[]).forEach(chartId=>{let chartElement=document.getElementById(chartId);chartElement&&chartElement.remove()});const canvasContainer=document.getElementById("canvas-container");canvasContainer.classList.remove("hidden"),canvasContainer.style.display="block";let outer=document.getElementById("deviceValueSettingsOuter");outer.classList.remove("hidden"),outer.addEventListener("click",()=>{closeFavouriteChart(this.chartUpdateIntervalId)});let canvas=document.createElement("canvas");const chartId=this.generateUniqueId();canvas.id=chartId;let chartIdStorage=JSON.parse(localStorage.getItem("ChartIdStorage"))||[];chartIdStorage.push(chartId),localStorage.setItem("ChartIdStorage",JSON.stringify(chartIdStorage)),canvas.className="favouriteChart";let width,getRoomSize=localStorage.getItem("roomSize");width="large"===getRoomSize?"800px":"medium"===getRoomSize?"600px":"500px",canvasContainer.style.width=width,canvasContainer.appendChild(canvas),canvasContainer.appendChild(this.createCloseButton()),canvasContainer.appendChild(this.createLegendChart(dataType)),this.isOpeningChart=!0;const handleChartDestruction=(intervalId,favChart)=>{favChart&&(favChart.destroy(),favChart=null,clearInterval(intervalId),localStorage.removeItem("chartData"))},processSensorData=(sensorSavedData,chartData)=>{Array.isArray(sensorSavedData)&&sensorSavedData.length>0&&sensorSavedData.forEach(entry=>{null!==entry&&void 0!==entry&&((entry=String(entry).trim()).includes(":")?chartData.labels.push(entry):"true"===entry||"false"===entry?chartData.isReachable.push(entry):chartData.data.push(entry))})},updateChartData=(chartData,chartType,favChart,sensorId,intervalId,deviceCharts,translateLabel)=>{handleChartDestruction(favChart);const{validData:validData,validLabels:validLabels,validReachable:validReachable}=filterValidData(chartData.data,chartData.labels,chartData.reachable);favChart?(favChart.data.labels=validLabels,favChart.data.datasets[0].data=validData,favChart.data.datasets[1].data=validReachable,favChart.update()):initializeNewChart(deviceCharts,chartData,chartType,intervalId,translateLabel,sensorId),updateChartInterval(chartData,chartType,sensorId,favChart)},filterValidData=(data,labels)=>data.reduce((acc,value,index)=>(null!==value&&void 0!==value&&(acc.validData.push(value),acc.validLabels.push(labels[index]),acc.validReachable.push(value[2])),acc),{validData:[],validLabels:[],validReachable:[]}),updateChartInterval=(chartData,chartType,sensorId,favChart)=>{if(sensorId){const sensor=getSensorByType(sensorId,chartType),deviceInfo=app.getSensorArrayInfo(sensor).find(item=>item.type.toLowerCase()===chartType.toLowerCase());if(deviceInfo){const value=deviceInfo.value;console.log(`Chart Type: ${chartType}, Value: ${value}`);const formattedTime=(new Date).toLocaleTimeString([],{hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!1});chartData.data.push(value),chartData.labels.push(formattedTime),chartData.data=chartData.data.slice(-3600),chartData.labels=chartData.labels.slice(-3600),updateChart(favChart,chartData.labels,chartData.data)}}},initializeNewChart=(deviceCharts,chartData,chartType,intervalId,translateLabel,sensorId)=>{let labelIndicator={particulateMatter:" 5µg/m³",temperature:" °C",battery:" %",humidity:" %",tvoc:" ppb",formaldehyde:" ppm",cO2:" ppm",current:" mA",power:" W",voltage:" V",consumption:" kWh",lightlevel:" lux",pressure:" hPa",airpressure:" hPa",moisture:" %",tiltangle:" °"}[chartType]||"";const yAxisLabels={daylight:{0:translate("text_day"),1:translate("text_night")},openClose:{0:translate("text_open"),1:translate("text_closed")},presence:{0:translate("text_detected_true"),1:translate("text_detected")},window:{0:translate("text_open"),1:translate("text_closed")},water:{0:translate("text_detected_true"),1:translate("text_detected")},windowopen:{0:translate("text_open"),1:translate("text_closed")},open:{0:translate("text_open"),1:translate("text_closed")},airQuality:{0:translate("txt_excellent"),1:translate("txt_good"),2:translate("txt_moderate"),3:translate("txt_poor"),4:translate("txt_unhealthy")},vibration:{0:translate("text_vibration_true"),1:translate("text_vibration_false")},alarm:{0:translate("text_detected_true"),1:translate("text_detected")},filter:{0:translate("text_please_change"),1:translate("text_okay")},fire:{0:translate("th_fire"),1:translate("th_nofire")},preset:{0:translate("th_manual"),1:translate("th_auto")},locked:{0:translate("text_on"),1:translate("text_off")},th_fireTest:{0:translate("th_firetest"),1:translate("th_nofiretest")}},isOnOffChart=["openClose","presence","daylight","window","open","water","windowopen","airQuality","vibration","alarm","filter","preset","locked"].includes(chartType),rootStyles=getComputedStyle(document.documentElement),colorText=rootStyles.getPropertyValue("--color-text").trim(),colorTextAlt=rootStyles.getPropertyValue("--color-text-alt").trim(),config={type:"line",data:{labels:chartData.labels,datasets:[{label:chartType,data:chartData.data,backgroundColor:"rgba(255, 255, 255, 0.1)",borderColor:chartData.isReachable.map(reachable=>"false"===reachable?colorTextAlt:colorText),pointRadius:0,borderWidth:2,pointBackgroundColor:colorText,pointBorderColor:colorText,pointHoverBackgroundColor:colorText,pointHoverBorderColor:colorText,segment:{borderColor:ctx=>{const index=ctx.p1DataIndex;return void 0!==index&&chartData.isReachable[index]&&"false"===chartData.isReachable[index]?colorTextAlt:colorText}}}]},options:{responsive:!0,maintainAspectRatio:!0,scales:{x:{position:"bottom",title:{display:!0,text:translate("text_time"),color:colorText,font:{size:12}},ticks:{color:colorText,maxRotation:20,minRotation:5}},y:isOnOffChart?{type:"category",labels:Object.values(yAxisLabels[chartType]),title:{display:!0,text:translateLabel+labelIndicator,color:colorText},ticks:{color:colorText}}:{title:{display:!0,text:translateLabel+labelIndicator,color:colorText},beginAtZero:!1,ticks:{color:colorText,callback:function(value){return"battery"===chartType&&value>100?"":"tiltangle"===chartType&&value>360?"":("power"===chartType||"voltage"===chartType||"consumption"===chartType||"current"===chartType)&&value<0?"":value}}}},plugins:{legend:{display:!1},tooltip:{enabled:!0,mode:"index",intersect:!1}},animation:{duration:500,easing:"easeOutQuart"}}};favChart=new Chart(deviceCharts,config),this.chartUpdateIntervalId=setInterval(()=>{updateChartInterval(chartData,chartType,sensorId,favChart)},1e3),roomViewIntervals[this.roomid]=this.chartUpdateIntervalId},getSensorByType=(sensorId,chartType)=>["power","voltage","consumption","current"].includes(chartType)?app.lights.get(sensorId):app.sensors.get(sensorId),updateChart=(chart,labels,data)=>{chart&&(chart.data.labels=labels,chart.data.datasets[0].data=data,chart.options.scales.x.ticks.callback=((value,index)=>labels[index]),chart.options.animation=!1,chart.update())},getSensorValue=event=>{let sensorData,dataType=JSON.parse(localStorage.getItem("dataType")),sensorId=void 0===sensorValue?storedFav[0]:sensorValue.getAttribute("data-id");storedFav=[sensorId],sensorData=["current","power","voltage","consumption"].includes(dataType[0])?app.lights.get(sensorId):app.sensors.get(sensorId);const deviceInfo=app.getSensorArrayInfo(sensorData).find(item=>item.type.toLowerCase()===dataType[0].toLowerCase());if(deviceInfo){const id=sensorData.attributes.id,existingData=localStorage.getItem("savedChartData"),dataArray=existingData?JSON.parse(existingData):[];let newData=(id=>{const sensorIndex=dataArray.findIndex(sensor=>sensor.sensorId===id);return-1!==sensorIndex?dataArray[sensorIndex].stortedvalueData:null})(id);if(null===newData){newData=[];let sensorType=dataType[0];return updateNewChartData(roomId,sensorId,sensorType),{sensorSavedData:newData,chartType:deviceInfo.type,sensorId:sensorId,translateLabel:deviceInfo.label}}return newData?{sensorSavedData:newData,chartType:deviceInfo.type,sensorId:sensorId,translateLabel:deviceInfo.label}:null}return null};(async(event,intervalId,favChart)=>{const chart=document.getElementById(chartId);if(!chart)return;const deviceCharts=chart.getContext("2d");let{sensorSavedData:sensorSavedData,chartType:chartType,sensorId:sensorId,translateLabel:translateLabel}=getSensorValue();if(!deviceCharts)return void handleChartDestruction(intervalId,favChart);let chartData=JSON.parse(localStorage.getItem("chartData"))||{labels:[],data:[],isReachable:[]};(sensorSavedData.length<1||"sunrise"===chartType||"sunset"===chartType)&&closeFavouriteChart(),Array.isArray(sensorSavedData)&&sensorSavedData.length>0&&(processSensorData(sensorSavedData,chartData),updateChartData(chartData,chartType,favChart,sensorId,intervalId,deviceCharts,translateLabel))})(0,void 0)},eventRoomExpanded:function(e){e.preventDefault(),this.isButtonClickRooms=!0;let roomView=this.el;roomView&&(this.expanded?(this.expand_icon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#expand-icon"></use>',roomView.classList.remove("expanded")):(this.expand_icon.innerHTML='<use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#collapse-icon"></use>',roomView.classList.add("expanded")),this.expanded=!this.expanded,localStorage.setItem(`${this.roomid}_expanded`,this.expanded),findMatchingRoomData(this.model,this),debouncedSaveLocalStorageToUserParameter())}});return new(Backbone.View.extend({el:"#roomList",model:app.rooms,initialize:function(){this.views=[],this.service=service,this.columns=[],restGetResource(app.groups).then(()=>{restGetResource(app.rooms).then(()=>{this.createColumnsDashboard(),this.loadRoomOrder()})}),this.listenTo(app.rooms,"add",()=>{console.log(" app.rooms added: "+app.rooms.length),this.loadRoomOrder()}),window.addEventListener("resize",this.handleResize.bind(this))},getRoomSize:function(){let columnWidth;switch(localStorage.getItem("roomSize")||"medium"){case"small":return columnWidth=450;case"medium":return columnWidth=600;case"large":return columnWidth=800;default:return columnWidth=450}},createColumnsDashboard:function(){let columnCount;this.views.forEach(view=>{view.stopListening(),view.roomDeviceItemViews.forEach(itemView=>{itemView.stopListening(),itemView.remove()}),view.remove()}),this.el.innerHTML="",this.columns=[];let getRoomWidthColumn=this.getRoomSize();document.querySelector("#roomList").style.gridTemplateColumns=`repeat(auto-fill, minmax(250px, ${getRoomWidthColumn}px))`;const containerWidth=this.el.clientWidth;columnCount=containerWidth<769?containerWidth<769?1:Math.floor(containerWidth/450):containerWidth<769?1:Math.floor(containerWidth/getRoomWidthColumn);for(let i=0;i<columnCount;i++){const column=document.createElement("ul");column.className="column",column.id=`column-el-${i+1}`,this.el.appendChild(column),this.columns.push(column)}this.columns.forEach(column=>{column.addEventListener("dragover",event=>{event.preventDefault();const existingPlaceholderColumns=column.querySelector(".column-drag-over");existingPlaceholderColumns&&existingPlaceholderColumns.remove();let checkPlaceHolderExits=this.el.querySelector(".placeholder");if(checkPlaceHolderExits&&checkPlaceHolderExits.remove(),this.el.classList.contains("disable-dragging")){column.querySelectorAll(".roomItemView").length>0||column.classList.add("column-drag-over")}}),column.addEventListener("move",event=>{event.preventDefault();const roomid=event.dataTransfer.getData("text/plain");roomid&&this.handleMove(roomid,column)}),column.addEventListener("drop",event=>{event.preventDefault();const roomid=event.dataTransfer.getData("text/plain");roomid&&this.handleDrop(roomid,column),column.classList.remove("column-drag-over")}),column.addEventListener("dragleave",event=>{event.preventDefault(),column.classList.remove("column-drag-over")})})},handleMove:function(roomid,column){if(column.querySelectorAll(".roomItemView").length>0)return;const placeholder=document.createElement("div");placeholder.classList.add("column-drag-over"),placeholder.textContent="Drop here",column.appendChild(placeholder)},handleDrop:function(roomid,column){if(app.roomViews.checkRoomDrag||!roomid)return;const roomOrder=JSON.parse(localStorage.getItem("roomOrder"))||{},roomColumnNumber=parseInt(column.id.split("-").pop(),10),newValue=roomColumnNumber>0?roomColumnNumber-1:0,placeholder=column.querySelector(".column-drag-over");placeholder&&placeholder.remove(),Object.keys(roomOrder).forEach(key=>{Array.isArray(roomOrder[key])&&(roomOrder[key]=roomOrder[key].filter(id=>id!==roomid))}),roomOrder[newValue]||(roomOrder[newValue]=[]),roomOrder[newValue].includes(roomid)||roomOrder[newValue].push(roomid),localStorage.setItem("roomOrder",JSON.stringify(roomOrder)),debouncedSaveLocalStorageToUserParameter(),this.refreshRooms()},distributeRooms:function(){this.views.forEach(view=>{view.stopListening(),view.roomDeviceItemViews.forEach(itemView=>{itemView.stopListening(),itemView.remove()}),view.remove()}),this.views=[],this.columns.forEach(column=>column.innerHTML="");const roomsPerColumn=Math.ceil(app.rooms.length/this.columns.length);app.rooms.forEach((room,index)=>{const columnIndex=Math.floor(index/roomsPerColumn);this.columns[columnIndex]&&this.addRoom(room,this.columns[columnIndex])})},refreshRooms:function(){this.loadRoomOrder()},handleResize:function(){this.createColumnsDashboard(),this.loadRoomOrder()},handleIconChange:function(){this.createColumnsDashboard(),this.loadRoomOrder(),app.quickDeviceViews.sensorViews.forEach(view=>{view.render()})},addRoom:function(model,column){if(!(column&&column instanceof HTMLElement||(column=document.querySelector("#column-el-1"))))return;let roomResourceId,view=new RoomItemView({model:model}),roomId=null;app.resourcelinks.forEach(link=>{link.attributes.name.split(" ")[1]==model.id&&(roomResourceId=link.id,roomId=link.get("name").split(" ")[1])}),view.el.classList.contains("disable-dragging")?view.el.setAttribute("draggable","false"):view.el.setAttribute("draggable","true"),view.el.setAttribute("data-resourceid",roomResourceId),view.el.setAttribute("data-roomid",roomId),this.views.push(view);const existingRoom=Array.from(column.children).some(child=>child.getAttribute("data-roomid")===roomId);view.el&&(existingRoom?console.warn(`Room with ID ${roomId} already exists in this column.`):column.appendChild(view.el)),view.gl&&column.appendChild(view.gl),this.findRoomMatch(model.id),window.addEventListener("resize",()=>{this.checkRoomVisibility(column)})},checkRoomVisibility:function(column){if(column){const rect=column.getBoundingClientRect();rect.width<=0||rect.height}},loadRoomOrder:function(){let roomOrder,checkPlaceHolderExits=this.el.querySelector(".placeholder");if(checkPlaceHolderExits&&checkPlaceHolderExits.remove(),roomOrder=JSON.parse(localStorage.getItem("roomOrder"))){this.views.forEach(view=>{view.stopListening(),view.roomDeviceItemViews.forEach(itemView=>{itemView.stopListening(),itemView.remove()}),view.remove()}),this.views=[];const addedRoomIds=new Set;var roomsToDelete=[];Object.keys(roomOrder).forEach(columnIndex=>{roomOrder[columnIndex].forEach(roomId=>{const roomModel=app.rooms.models.find(room=>room.id===roomId);roomModel?(this.addRoom(roomModel,this.columns[columnIndex]),addedRoomIds.add(roomId)):(console.log(`Room model for ID ${roomId} not found.`),roomsToDelete.push(roomId))})}),0!==roomsToDelete.length&&(roomsToDelete.forEach(roomId=>{for(const key in roomOrder)Array.isArray(roomOrder[key])&&(roomOrder[key]=roomOrder[key].filter(item=>item!==roomId))}),localStorage.setItem("roomOrder",JSON.stringify(roomOrder)),debouncedSaveLocalStorageToUserParameter()),app.rooms.forEach(room=>{if(!addedRoomIds.has(room.id)){const firstAvailableColumn=this.columns.find(column=>column.childElementCount<Math.ceil(app.rooms.length/this.columns.length));firstAvailableColumn&&this.addRoom(room,firstAvailableColumn)}})}else this.distributeRooms();this.checkLockDragRoomStatus()},findRoomMatch:function(modelId){findMatchingRoomData(modelId,this)},toggleRoomExpansion:toggleRoomExpansion,removeRoom:function(model){let view=this.views.find(view=>view.model===model);view&&(view.roomDeviceItemViews.forEach(itemView=>{itemView.stopListening(),itemView.remove()}),view.remove(),this.views=this.views.filter(v=>v!==view),this.distributeRooms())},checkLockDragRoomStatus(){const roomList=document.getElementById("roomList"),deviceList=document.querySelectorAll(".deviceItemView"),dragLock=document.getElementById("dragLock"),isRoomLocked=app.dragRoomLockState,isDeviceLocked=app.dragDeviceLockState,roomItems=document.querySelectorAll(".roomItemView");let toggleMoveRoomButton=document.getElementById("toggleMoveRoom"),logMoveDevicesButton=document.getElementById("logMoveDevices"),dotMenuSettings=document.getElementById("dotMenuSettings"),dotMenuOnOff=document.getElementById("dotMenuOnOff"),outer=document.getElementById("deviceValueSettingsOuter");if(!toggleMoveRoomButton.classList.contains("hidden")&&!logMoveDevicesButton.classList.contains("hidden")||!dotMenuSettings.classList.contains("hidden")&&!dotMenuOnOff.classList.contains("hidden")?outer.classList.remove("hidden"):outer.classList.add("hidden"),isRoomLocked){dragLock.classList.add("active"),dragLock.classList.add("highlight");toggleMoveRoomButton.classList.add("active"),roomItems.forEach(roomItem=>{roomItem.classList.add("room-move"),roomItem.classList.remove("expanded"),roomItem.setAttribute("draggable",!0)}),roomList.classList.add("disable-dragging"),dragLock.classList.add("update-toggle"),outer.classList.add("hidden")}else dragLock.classList.remove("active"),dragLock.classList.contains("highlight")&&(toggleMoveRoomButton.classList.add("hidden"),logMoveDevicesButton.classList.add("hidden"),outer.classList.add("hidden"),console.log("Add deviceStatusOuter Hidden!")),dragLock.classList.remove("highlight"),dragLock.classList.remove("update-toggle"),roomList.classList.remove("disable-dragging"),roomItems.forEach(roomItem=>{roomItem.setAttribute("draggable",!1)});isDeviceLocked?(dragLock.classList.add("active"),dragLock.classList.add("highlight"),logMoveDevicesButton.classList.add("active"),deviceList.forEach(deviceItem=>{deviceItem.draggable&&(deviceItem.classList.contains("quickDevice")?deviceItem.classList.remove("room-move"):(deviceItem.classList.add("room-move"),deviceItem.setAttribute("draggable",!0)))}),dragLock.classList.add("update-toggle"),outer.classList.add("hidden")):(logMoveDevicesButton.classList.remove("active"),dragLock.classList.remove("update-toggle"),deviceList.forEach(deviceItem=>{deviceItem.classList.contains("quickDevice")?deviceItem.setAttribute("draggable",!0):deviceItem.setAttribute("draggable",!1)}))},eventSettingsExpanded:eventSettingsExpanded,addSensorValuetoRoomNew:addSensorValuetoRoomNew}))};function storeBackHash(){sessionStorage.setItem("app.back.hash",document.location.hash),console.log("stored",sessionStorage.getItem("app.back.hash"))}