/*! phoscon-app 2025-11-11 */

var scanInProgress=!1;let SEARCH_SENSORS_DISABLED=0,SEARCH_SENSORS_ENABLED=1;var lastWidth=0;let startTime,endTime,lastHeight=0,FAST_POLL_DELAY=500,SLOW_POLL_DELAY=5e3;var pollState=SEARCH_SENSORS_DISABLED,pollDelay=SLOW_POLL_DELAY;let min=void 0,intervals={},roomStates={};export let removeExistingChartData=roomId=>{let existingData=localStorage.getItem("savedChartData"),dataArray=[];try{dataArray=existingData?JSON.parse(existingData):[]}catch(error){dataArray=[]}dataArray=dataArray.filter(item=>item.roomId!==roomId);try{localStorage.setItem("savedChartData",JSON.stringify(dataArray))}catch(error){console.error("Error saving data to localStorage:",error)}};export let chartIntervalRemove=roomId=>{Object.keys(intervals).forEach(intervalKey=>{intervalKey.split("-")[0]===roomId&&(clearInterval(intervals[intervalKey]),delete intervals[intervalKey])});const updatedState=(JSON.parse(localStorage.getItem("intervalState"))||[]).filter(interval=>interval.roomId!==roomId);localStorage.setItem("intervalState",JSON.stringify(updatedState)),removeExistingChartData(roomId)};export let updateNewChartData=(roomId,sensorId,sensorType)=>{let sensor;if(!roomId||!sensorId||!sensorType)return;if(chartIntervalRemove(roomId),!(sensor=["power","voltage","consumption","current"].includes(sensorType)?app.lights.get(sensorId):app.sensors.get(sensorId)))return;const getInfo=app.getSensorArrayInfo(sensor);if(!getInfo)return;const deviceInfo=getInfo.find(item=>item.type===sensorType);if(deviceInfo){const dataInfo=deviceInfo.value;let isReachable=void 0===deviceInfo.isReachable||deviceInfo.isReachable;if(void 0===dataInfo||void 0===isReachable)return;const collectDataInterval=setInterval(()=>{const getInfo=app.getSensorArrayInfo(sensor);if(!getInfo)return void clearInterval(collectDataInterval);const deviceInfo=getInfo.find(item=>item.type===sensorType);if(deviceInfo){const dataInfo=deviceInfo.value,time=(new Date).toLocaleTimeString([],{hour:"2-digit",minute:"2-digit",second:"2-digit",hour12:!1});if(void 0===dataInfo)return void clearInterval(collectDataInterval);const stortedvalueData=[dataInfo,time,isReachable.toString()];setFavDataArrayLocalStorage(roomId,sensorId,sensorType,stortedvalueData)}},1e3);intervals[`${roomId}-${sensorId}`]=collectDataInterval;const intervalState=JSON.parse(localStorage.getItem("intervalState"))||[];intervalState.push({roomId:roomId,sensorId:sensorId,sensorType:sensorType}),localStorage.setItem("intervalState",JSON.stringify(intervalState))}else console.log(`Device info not found for sensorType: ${sensorType}`)};document.addEventListener("DOMContentLoaded",()=>{restoreIntervals()});export const restoreIntervals=()=>{if(app.sensors.models.length<1&&app.lights.models.length<1);else{(JSON.parse(localStorage.getItem("intervalState"))||[]).forEach(({roomId:roomId,sensorId:sensorId,sensorType:sensorType})=>{console.log(`Restoring interval for roomId: ${roomId}, sensorId: ${sensorId}, sensorType: ${sensorType}`),updateNewChartData(roomId,sensorId,sensorType)})}};export var setFavDataArrayLocalStorage=(roomId,sensorId,sensorType,stortedvalueData)=>{if("sunrise"===sensorType||"sunset"===sensorType)return;const newSensorData={roomId:roomId,sensorId:sensorId,type:sensorType,stortedvalueData:stortedvalueData};let existingData=localStorage.getItem("savedChartData"),dataArray=existingData?JSON.parse(existingData):[];const existingSensorDataIndex=dataArray.findIndex(data=>data.roomId===roomId&&data.sensorId===sensorId&&data.type===sensorType);-1!==existingSensorDataIndex?(dataArray[existingSensorDataIndex].stortedvalueData=[...dataArray[existingSensorDataIndex].stortedvalueData,...stortedvalueData],dataArray[existingSensorDataIndex].stortedvalueData.length>10800&&(dataArray[existingSensorDataIndex].stortedvalueData=dataArray[existingSensorDataIndex].stortedvalueData.slice(-9e3))):dataArray.push(newSensorData),localStorage.setItem("savedChartData",JSON.stringify(dataArray))};export var toggleRoom=()=>async(ctx,event)=>{let room=event.view.model;if(!room)return;let group=app.groups.where({name:"phoscon_room_"+room.get("id")+"_on_off_group"})[0];if(group&&0!==group.get("lights").length){var noneReachable=!0;if(group.get("lights").forEach(lid=>{let light=app.lights.get(lid);light&&!0===light.get("state").reachable&&(noneReachable=!1)}),!noneReachable){var on=group.get("state").any_on;$.ajax({url:"//"+app.session.gw+"/api/"+app.apikey+"/groups/"+group.id+"/action",dataType:"json",type:"PUT",cache:!1,data:JSON.stringify({on:!on}),contentType:"application/json; charset=utf-8",headers:{Accept:apiversion},success:function(json){restGetResource(app.groups),event.view.quickToggleOnOffIcon(!on)},error:function(xhr,status,error){console.error("Error toggle room: ",error)}})}}};export var deleteRoomView=()=>async(ctx,view)=>{if(!view||!view.room)return;let room=app.rooms.find(view.room);if(!room)return;let roomName=room.attributes.name;const filteredData=(JSON.parse(sessionStorage.getItem("starredItems"))||[]).filter(item=>item.id!==roomName);sessionStorage.setItem("starredItems",JSON.stringify(filteredData)),localStorage.removeItem(`${room.id}_expanded`);let resourcelink=app.resourcelinks.find(l=>6e3===l.get("classid")&&l.attributes.name.split(" ")[1]===room.id);if(!resourcelink)return;await resourcelink.attributes.links.forEach(async l=>{if(l.startsWith("/groups/")){let group=await app.groups.find(g=>g.id===l.split("/groups/")[1]);group&&await restDeleteResource(group)}});let onOffGroupName="phoscon_room_"+room.get("id")+"_on_off_group",onOffGroup=app.groups.where({name:onOffGroupName})[0];restDeleteResource(room).then(()=>{restDeleteResource(resourcelink)}).then(()=>{onOffGroup&&restDeleteResource(onOffGroup)}).then(()=>restGetResource(app.rooms)).then(()=>restGetResource(app.groups)).then(()=>restGetResource(app.resourcelinks)).then(deleteOrphanGroups()).then(()=>{app.roomViews&&app.roomViews.refreshRooms()});const roomOrder=JSON.parse(localStorage.getItem("roomOrder"))||{};let roomid=room.id;Object.keys(roomOrder).forEach(key=>{Array.isArray(roomOrder[key])&&(roomOrder[key]=roomOrder[key].filter(id=>id!==roomid))}),"number"==typeof newValue&&(roomOrder[newValue]||(roomOrder[newValue]=[]),roomOrder[newValue].includes(roomid)||roomOrder[newValue].push(roomid)),localStorage.setItem("roomOrder",JSON.stringify(roomOrder)),checkRoomAmount()};export var createRoomView=()=>(ctx,name)=>{let groupid;restCreateResource(app.groups,{name:name.name,type:"Room"}).then(gid=>{groupid=gid,localStorage.setItem(`${groupid}_expanded`,!0)}).then(()=>restGetResource(app.resourcelinks)).then(()=>{restCreateResource(app.resourcelinks,{name:"room "+groupid,description:"Link to contain groups, scenes and devices inside a room",classid:6e3,links:[]}).then(()=>{let onOffGroup=app.groups.find(group=>group.get("name")==="phoscon_room_"+groupid+"_on_off_group");onOffGroup||restCreateResource(app.groups,{name:"phoscon_room_"+groupid+"_on_off_group"}).then(gid=>{onOffGroup=app.groups.get(gid)}).then(()=>{restUpdateResource(app.groups.get(onOffGroup.get("id")),{lights:lights,hidden:!0})})}).then(()=>{restGetResource(app.rooms)}).then(()=>{app.router.navigate("dashboard-overview",{trigger:!1})}).then(()=>{app.roomViews&&app.roomViews.refreshRooms()}).then(()=>{checkRoomAmount()})})};export const getColumns=()=>{const columns=document.querySelectorAll(".column");return columns.length>0?Array.from(columns):[]};export var allOFF=()=>(ctx,event)=>{$.ajax({url:"//"+app.session.gw+"/api/"+app.apikey+"/groups/"+app.alloffgroup.id+"/action",dataType:"json",type:"PUT",cache:!1,data:JSON.stringify({on:!1}),contentType:"application/json; charset=utf-8",headers:{Accept:apiversion},success:function(json){restGetResource(app.groups),app.roomViews.views.forEach(view=>{view.quickToggleOnOffIcon(!1)})},error:function(xhr,status,error){console.error("Error updating backend:",error)}})};export var toggleDevice=()=>(ctx,event)=>{let model=null;if(null!=(model=event.view.model?event.view.model:event.view)){let type="lights",stateType="state",on=model.attributes.state.on;if("LightGroup"==model.get("type")){if(model.get("lights")&&0===model.get("lights").length)return;type="groups",stateType="action",on=model.get("state").any_on?model.get("state").any_on:model.attributes.action.on}if($.ajax({url:`//${app.session.gw}/api/${app.apikey}/${type}/${model.id}/${stateType}`,method:"PUT",contentType:"application/json",data:JSON.stringify({on:!on}),success:function(response){"LightGroup"==model.get("type")?(restGetResource(app.groups),event.view.quickUpdateBulbIconsForGroup(!on,event.view,model)):"FLS-PP3"!==model.get("modelid")&&(restGetResource(app.lights),event.view.quickUpdateBulbIcon(!on)),event.view.quickUpdateRoomOnOffIcon(!on,event.view)},error:function(jqXHR,textStatus,errorThrown){console.error("Request failed:",textStatus,errorThrown)}}),"FLS-PP3"===model.get("modelid")){let l=getFlsPpWhite(model);l&&$.ajax({url:`//${app.session.gw}/api/${app.apikey}/${type}/${l.get("id")}/${stateType}`,method:"PUT",contentType:"application/json",data:JSON.stringify({on:!on}),success:function(response){restGetResource(app.lights),event.view.quickUpdateBulbIcon(!on)},error:function(jqXHR,textStatus,errorThrown){console.error("Request failed:",textStatus,errorThrown)}})}}};export var applyMigration=()=>ctx=>{let migrationGroups=[];var groupid,rlId;if(app.migrationGroupView2.views.forEach(view=>{1==view.selected&&migrationGroups.push("/groups/"+view.model.id)}),0==document.getElementById("inputUpdateCreateRoom").classList.contains("hidden")){let name=document.getElementById("inputUpdateCreateRoom").value;restCreateResource(app.groups,{name:name,type:"Room"}).then(gid=>{groupid=gid,restGetResource(app.rooms)}).then(()=>restGetResource(app.resourcelinks)).then(()=>{restCreateResource(app.resourcelinks,{name:"room "+groupid,description:"Link to contain groups, scenes and devices inside a room",classid:6e3,links:migrationGroups}).then(id=>{rlId=id,restGetResource(app.rooms)}).then(()=>{updateRoomWithGroupsLights(rlId,groupid,migrationGroups)})})}else{var id=document.getElementById("updateRoomSelect")[document.getElementById("updateRoomSelect").selectedIndex].value;app.resourcelinks.forEach(link=>{6e3===link.get("classid")&&link.attributes.name.split(" ")[1]===id&&restUpdateResource(link,{links:link.attributes.links.concat(migrationGroups)}).then(()=>{updateRoomWithGroupsLights(link.get("id"),id,migrationGroups)})})}app.resourcelinks.forEach(link=>{if("migration room"==link.attributes.name){let oldgroups=link.attributes.links;oldgroups=oldgroups.filter(el=>!migrationGroups.includes(el)),restUpdateResource(link,{links:oldgroups}).then(()=>{restGetResource(app.resourcelinks)}).then(()=>{app.migrationGroupView2.checkButton(),app.roomViews&&app.roomViews.refreshRooms(),checkMigrationRoom()})}})};async function updateRoomWithGroupsLights(rlId,groupid,migrationGroups){var newRoomLights=[],newRoomLightLinks=[];migrationGroups.forEach(groupLink=>{let group=app.groups.get(groupLink.split("groups/")[1]);group&&group.get("lights").forEach(lid=>{newRoomLights.push(lid),"FLS-PP3 White"!==app.lights.get(lid).get("modelid")&&newRoomLightLinks.push("/lights/"+lid)})});let rl=app.resourcelinks.get(rlId);rl&&restGetResource(app.groups).then(()=>{restUpdateResource(rl,{links:rl.get("links").concat(newRoomLightLinks)}).then(()=>{let roomGroup=app.groups.get(groupid);if(roomGroup){var onOffGroup=app.groups.where({name:"phoscon_room_"+groupid+"_on_off_group"})[0],onOffGroupLights=[];onOffGroup&&(onOffGroupLights=onOffGroup.get("lights")||[]),newRoomLights.forEach(lid=>{let l=app.lights.get(lid);if(l){if(-1===roomGroup.get("lights").indexOf(l.get("id"))&&roomGroup.get("lights").push(lid),l.get("modelid")===FLS_PP){let flsWhite=getFlsPpWhite(l);flsWhite&&-1===roomGroup.get("lights").indexOf(flsWhite.get("id"))&&roomGroup.get("lights").push(flsWhite.get("id"))}if(-1===onOffGroupLights.indexOf(l.get("id"))&&onOffGroupLights.push(l.get("id")),l.get("modelid")===FLS_PP){let flsWhite=getFlsPpWhite(l);flsWhite&&-1===onOffGroupLights.indexOf(flsWhite.get("id"))&&onOffGroupLights.push(flsWhite.get("id"))}}}),restUpdateResource(roomGroup,{lights:roomGroup.get("lights")}).then(()=>{onOffGroup?restUpdateResource(onOffGroup,{lights:onOffGroupLights}).then(()=>restGetResource(onOffGroup)).then(()=>{checkFlsSpecialGroups(onOffGroup)}):restCreateResource(app.groups,{name:"phoscon_room_"+groupid+"_on_off_group"}).then(onOffGroupId=>{let onOffGroup=app.groups.get(onOffGroupId);onOffGroup&&restUpdateResource(onOffGroup,{lights:onOffGroupLights,hidden:!0}).then(()=>restGetResource(app.groups)).then(()=>checkFlsSpecialGroups(onOffGroup))})}).then(()=>{migrationGroups.forEach(async groupLink=>{await deleteGroupFromMigration(groupLink.split("groups/")[1])})}).then(async()=>{await restGetResource(app.groups),await restGetResource(app.resourcelinks),app.roomViews&&app.roomViews.refreshRooms()}).then(()=>{checkRoomAmount()})}})})}export var checkMigrationRoom=()=>ctx=>{restGetResource(app.resourcelinks).then(()=>{var exists=!1;if(app.resourcelinks.forEach(link=>{"migration room"==link.attributes.name&&(exists=!0,restDeleteResource(link).then(()=>{restGetResource(app.resourcelinks)}).then(()=>{let links=[],alreadyInRoom=!1;app.groups.forEach(group=>{alreadyInRoom=!1,app.resourcelinks.some(rl=>{if(rl.get("name").startsWith("room")&&rl.get("links").includes("/groups/"+group.get("id")))return alreadyInRoom=!0,!0}),group.attributes.hidden||group.get("name").startsWith("FLS-PP3 helper")||"Room"===group.get("type")||group.get("name").startsWith("phoscon_room_")||alreadyInRoom||group.get("devicemembership")&&0===group.get("devicemembership").length&&links.push("/groups/"+group.id)}),restCreateResource(app.resourcelinks,{name:"migration room",description:"this room is used to store not migrated groups from before the rooms update",classid:6e3,links:links}).then(()=>{restGetResource(app.rooms)}).then(()=>{app.migrationGroupView2.checkButton()})}))}),!exists){let links=[],alreadyInRoom=!1;app.groups.forEach(group=>{alreadyInRoom=!1,app.resourcelinks.some(rl=>{if(rl.get("name").startsWith("room")&&rl.get("links").includes("/groups/"+group.get("id")))return alreadyInRoom=!0,!0}),group.attributes.hidden||group.get("name").startsWith("FLS-PP3 helper")||"Room"===group.get("type")||alreadyInRoom||group.get("devicemembership")&&0===group.get("devicemembership").length&&links.push("/groups/"+group.id)}),restCreateResource(app.resourcelinks,{name:"migration room",description:"this room is used to store not migrated groups from before the rooms update",classid:6e3,links:links}).then(()=>{restGetResource(app.rooms)}).then(()=>{app.migrationGroupView2.checkButton()})}})};export let addSensorValuetoRoom=value=>{favouriteRoomSensorValue?favouriteRoomSensorValue.textContent=value||"":console.warn('Element with ID "favSensorValue" not found in the last room view.')};const getIconSvg={sensorTypeIcons:{Daylight:"#daylight-sensor-icon",ZHAAirQuality:"#humidity-icon",ZHAAlarm:"#siren",ZHACarbonMonoxid:"#humidity-icon",ZHAParticulateMatter:"#humidity-icon",ZHAFormaldehyde:"#humidity-icon",ZHACarbonDioxide:"#humidity-icon",ZHAFire:"#fire-icon",ZHAHumidity:"#humidity-icon",ZHALightLevel:"#sun-icon",ZHAOpenClose:"#door-icon",ZHAPresence:"#motion-sensor-icon",ZHAPressure:"#sensor-pressure-icon",ZHATemperature:"#sensor-temperature-icon",ZHAThermostat:"#thermostat-icon",ZHAVibration:"#ZHAVibration-icon",ZHAWater:"#water-drop-icon"}};export let addSensorValuetoRoomNew=(value,ctx,bbb,deviceId,type,deviceType,isReachable,svgIcon)=>{let lastRoomView;if(lastRoomView=void 0===ctx.views?ctx:ctx.views[ctx.views.length-1]){lastRoomView.favoriteSensorSvg&&(lastRoomView.favoriteSensorSvg.innerHTML=svgIcon);let favouriteRoomSensorValue=lastRoomView.favoriteSensorValue;lastRoomView.favoriteSensorValue.getAttribute("data-previous-value");const currentSensorValue=value;lastRoomView.favoriteSensorValue.setAttribute("data-previous-value",currentSensorValue),favouriteRoomSensorValue?(favouriteRoomSensorValue.setAttribute("data-id",deviceId),favouriteRoomSensorValue.setAttribute("data-type",type),favouriteRoomSensorValue.setAttribute("device-type",deviceType),lastRoomView.favoriteSensorSvg.setAttribute("data-id",deviceId),lastRoomView.favoriteSensorSvg.setAttribute("data-type",type),lastRoomView.favoriteSensorSvg.setAttribute("device-type",deviceType),!1===isReachable?(favouriteRoomSensorValue.classList.add("not-reachable"),favouriteRoomSensorValue.parentElement.querySelector("svg").classList.add("not-reachable")):(favouriteRoomSensorValue.classList.remove("not-reachable"),favouriteRoomSensorValue.parentElement.querySelector("svg").classList.remove("not-reachable")),"battery"===type?(favouriteRoomSensorValue.innerHTML=value||"",favouriteRoomSensorValue.style.float="right"):favouriteRoomSensorValue.textContent=value||""):console.warn('Element with ID "favSensorValue" not found in the last room view.')}else console.warn("No room views available.")};export let findMatchingRoomData=(modelId,ctx)=>{const storedData=localStorage.getItem("savedFavSensorData");if(storedData)try{const dataArray=JSON.parse(storedData);if(!Array.isArray(dataArray))return;void 0!==modelId.id&&null!==modelId.id&&(modelId=modelId.id);const roomData=app.rooms.get(modelId);if(!roomData)return;const roomLights=roomData.attributes.lights||[],roomSensors=roomData.attributes.sensors||[],roomThermostats=roomData.attributes.thermostats||[],allDevices=[...roomSensors,...roomThermostats,...roomLights];allDevices.forEach(deviceId=>{const matchingData=dataArray.find(data=>data.sensorId===deviceId&&data.roomId===modelId);if(matchingData){let deviceInfoView=app.thermostats.get(deviceId)||app.sensors.get(deviceId);"current"!==matchingData.type&&"power"!==matchingData.type&&"voltage"!==matchingData.type&&"consumption"!==matchingData.type||(deviceInfoView=app.lights.get(deviceId));const deviceInfoArray=app.getSensorArrayInfo(deviceInfoView);deviceInfoArray&&deviceInfoArray.forEach(device=>{if(device.type===matchingData.type){const svgIcon=device.icon,deviceSymbol=`${device.value}${device.unit}`;let isReachable=device.isReachable;addSensorValuetoRoomNew(deviceSymbol,ctx,allDevices,deviceId,device.type,matchingData.deviceType,isReachable,svgIcon)}})}})}catch(error){console.error("Error processing stored data:",error)}};export let eventSettingsExpanded=(ctx,dropDownSettings,favoriteSensorValue)=>{if(app.settings_room=ctx,void 0!==dropDownSettings){const{dropDownSettings:dropDownSettings,favoriteSensorValue:favoriteSensorValue}=ctx,sensorList=document.getElementById("sensor-list");if(sensorList.innerHTML="",ctx.el.querySelector(".dropdown-content").classList.toggle("show"),void 0!==dropDownSettings){const sensorList=document.getElementById("sensor-list");sensorList.classList.add("hide"),sensorList.innerHTML="";const dropdownContent=dropDownSettings,dropdownButton=ctx.el.querySelector(".expand-btn");if(dropdownContent&&dropdownButton){const buttonRect=dropdownButton.getBoundingClientRect(),viewportHeight=window.innerHeight,dropdownHeight=dropdownContent.offsetHeight;let topPosition=buttonRect.bottom+window.scrollY;topPosition+dropdownHeight>viewportHeight&&(topPosition=buttonRect.top-dropdownHeight+window.scrollY),topPosition<window.scrollY&&(topPosition=buttonRect.bottom+window.scrollY),dropdownContent.style.position="absolute",dropdownContent.style.top=`${topPosition}px`,dropdownContent.style.left=`${buttonRect.left}px`,screenMax(SCREEN_MAX_WIDTH_PHONE_LANDSCAPE)&&isThisPortrait()||(dropdownContent.style.transform="translateX(-50%)");const dropdownRightEdge=buttonRect.left+dropdownContent.offsetWidth,viewportWidth=window.innerWidth;dropdownRightEdge>viewportWidth&&(dropdownContent.style.left=`${viewportWidth-dropdownContent.offsetWidth-10}px`)}}if(!app.settings_room)return void console.warn("app.settings_room is not defined.");const select=document.getElementById("select-sensor")||(()=>{const newSelect=document.createElement("select");return newSelect.name="sensorConfig",newSelect.id="select-sensor",sensorList.appendChild(newSelect),newSelect})();ctx.roomDeviceItemViews.forEach(device=>{if(device.model&&device.model.attributes&&("sensors"===device.type||"thermostats"===device.type||"Smart plug"===device.model.attributes.type)){let reachable=device.model.get("state").reachable||device.model.get("config").reachable||!1;const deviceLabel=device.model.attributes.name||"",deviceId=device.model.attributes.id||"",deviceKey=device.deviceKey||"",option=document.createElement("option");option.id=deviceId,option.value=deviceKey,option.textContent=deviceLabel,!1===reachable&&(option.disabled=!0),select.appendChild(option)}});const createSensorDetailHTML=(sensor,sensorId)=>`\n        <label class="checkbox-container">\n            <input type="checkbox" class="tick-checkbox" data-sensor="${sensor.type}" data-value="${sensor.value+" "+sensor.unit}" data-sensor-id="${sensorId}">\n            <h7 class="checkBoxLabel ${!1===sensor.isReachable?"not-reachable":""}">${sensor.label}</h7>\n        </label>\n        `,renderSensorFav=()=>{sensorList.classList.remove("hide");const sensorDetails=document.createElement("div");sensorDetails.className="sensor-details",app.settings_room.roomDeviceItemViews.forEach(device=>{if(!device.model)return;const sensorArray=app.getSensorArrayInfo(device.model);sensorArray.some(sensor=>sensor.value===select.value)&&(sensorArray.forEach(sensor=>{["macid","product","manufacture","updated"].includes(sensor.type)||(sensorDetails.innerHTML+=createSensorDetailHTML(sensor,device.model.id))}),sensorList.appendChild(sensorDetails))}),sensorDetails.querySelectorAll(".tick-checkbox").forEach(checkbox=>{checkbox.addEventListener("change",event=>{dropDownSettings.classList.remove("show");const selectedType=event.target.dataset.sensor;if(sensorDetails.querySelectorAll(".tick-checkbox").forEach(otherCheckbox=>{otherCheckbox.dataset.sensor!==selectedType&&(otherCheckbox.checked=!1)}),event.target.checked)favoriteSensorValue&&(favoriteSensorValue.textContent=event.target.dataset.value,favoriteSensorValue.setAttribute("data-id",event.target.dataset.sensorId)),saveSensorDataLocal(event.target);else{Array.from(sensorDetails.querySelectorAll(".tick-checkbox")).some(checkbox=>checkbox.checked)||(removeSensorDataLocal(event.target),app.settings_room.favoriteSensorValue&&(app.settings_room.favoriteSensorValue.textContent="",app.settings_room.favoriteSensorSvg.textContent=""))}})});const savedData=localStorage.getItem("savedFavSensorData");if(savedData){const dataArray=JSON.parse(savedData);sensorDetails.querySelectorAll(".tick-checkbox").forEach(checkbox=>{const sensorId=checkbox.dataset.sensorId,sensorType=checkbox.dataset.sensor,isChecked=dataArray.some(sensorData=>sensorData.sensorId===sensorId&&sensorData.roomId===app.settings_room.roomid&&sensorData.type===sensorType);checkbox.checked=isChecked})}};select.addEventListener("change",()=>{sensorList.querySelectorAll(".sensor-details").forEach(detail=>detail.remove()),renderSensorFav()});const savedData=localStorage.getItem("savedFavSensorData");if(savedData){const favoriteSensor=JSON.parse(savedData).find(sensorData=>sensorData.roomId===app.settings_room.roomid);if(favoriteSensor){let sensor,value;"current"===favoriteSensor.type||"power"===favoriteSensor.type||"voltage"===favoriteSensor.type||"consumption"===favoriteSensor.type?value=(sensor=app.lights.find(sensorData=>sensorData.attributes.id===favoriteSensor.sensorId)).attributes.uniqueid.split("-")[0]:(sensor=app.sensors.find(sensorData=>sensorData.attributes.id===favoriteSensor.sensorId))?value=sensor.attributes.mac:(select.selectedIndex=0,select.dispatchEvent(new Event("change"))),select.value=value,select.dispatchEvent(new Event("change"))}else if(select.options.length>0){let selectedOptionFound=!1;for(let i=0;i<select.options.length;i++)if(!select.options[i].disabled){select.selectedIndex=i,select.dispatchEvent(new Event("change")),selectedOptionFound=!0;break}selectedOptionFound||(select.selectedIndex=-1,select.dispatchEvent(new Event("change")))}}else if(select.options.length>0){let selectedOptionFound=!1;for(let i=0;i<select.options.length;i++)if(!select.options[i].disabled){select.selectedIndex=i,select.dispatchEvent(new Event("change")),selectedOptionFound=!0;break}selectedOptionFound||(select.selectedIndex=-1,select.dispatchEvent(new Event("change")))}}};export let saveSensorDataLocal=value=>{let stortedvalueData=[];const roomId=app.settings_room.roomid,sensorId=value.attributes["data-sensor-id"].nodeValue,sensorType=value.attributes["data-sensor"].nodeValue;chartIntervalRemove(roomId);const newSensorData={roomId:roomId,sensorId:sensorId,type:sensorType},updateData=async(roomId,sensorId,sensorType)=>{let sensor,scrollPosition=document.getElementById("mainContainer").scrollTop;localStorage.setItem("scrollPosition",scrollPosition),chartIntervalRemove(roomId),sensor=["power","voltage","consumption","current"].includes(sensorType)?app.lights.get(sensorId):app.sensors.get(sensorId);let existingData=localStorage.getItem("savedFavSensorData"),dataArray=[];try{dataArray=existingData?JSON.parse(existingData):[]}catch(error){console.error("Error parsing data from localStorage:",error),dataArray=[]}for(let i=0;i<dataArray.length;i++)if(dataArray[i].roomId===roomId){console.log(`Removing old data for roomId: ${roomId}`),dataArray.splice(i,1);break}dataArray.push(newSensorData);try{localStorage.setItem("savedFavSensorData",JSON.stringify(dataArray))}catch(error){console.error("Error saving data to localStorage:",error)}const deviceInfo=(await app.getSensorArrayInfo(sensor)).find(item=>item.type===sensorType);if(deviceInfo){const dataInfo=deviceInfo.value;stortedvalueData.push(dataInfo),updateNewChartData(roomId,sensorId,sensorType)}};["power","voltage","consumption","current"].includes(sensorType),updateData(roomId,sensorId,sensorType),app.roomViews.refreshRooms();let savedPosition=localStorage.getItem("scrollPosition");savedPosition&&(mainContainer.scrollTop=savedPosition)};export let removeSensorDataLocal=value=>{const roomId=app.settings_room.roomid,sensorId=value.attributes["data-sensor-id"].nodeValue;let existingData=localStorage.getItem("savedFavSensorData");if(!existingData)return;let dataArray=JSON.parse(existingData);const sensorIndex=dataArray.findIndex(data=>data.roomId===roomId&&data.sensorId===sensorId);-1!==sensorIndex&&dataArray.splice(sensorIndex,1),localStorage.setItem("savedFavSensorData",JSON.stringify(dataArray)),chartIntervalRemove(roomId),removeExistingChartData(roomId)};const sendRoomRename=async name=>{try{let group=app.groups.get(app.session.gid),room=app.rooms.get(app.session.gid);await new Promise((resolve,reject)=>{group.save({name:name},{patch:!0,success:response=>{room.save({name:name}),resolve(response),app.roomViews.refreshRooms(),app.roomViews.views.find(room=>room.model.get("id")===app.session.gid).updateName(name)},error:response=>{reject(response)}})})}catch(error){console.error("Error in sendData function:",error)}},checkRoomName=()=>{var inputField=document.getElementById("inputRenameRoom"),errorMessage=document.getElementById("renameRoomErrorMessage");if(""===inputField.value.trim())return errorMessage.textContent="Room name cannot be empty!",void inputField.focus();errorMessage.textContent="";let name=document.getElementById("inputRenameRoom").value.trim().toLowerCase(),roomNames=[];app.rooms&&app.rooms.models?roomNames=app.rooms.models.map(model=>{let name=model.attributes.name;return void 0!==name&&null!==name?String(name).toLowerCase():""}):console.error("app.rooms or app.rooms.models is undefined or null.");let errorMessageDiv=document.getElementById("renameRoomErrorMessage"),renameButton=document.getElementById("room-rename-btn");roomNames.includes(name)?(errorMessageDiv.textContent="Room name already exists. Please choose a different name.",errorMessageDiv.classList.remove("hidden"),renameButton.disabled=!0,document.getElementById("inputRenameRoom").classList.add("text-danger")):(errorMessageDiv.textContent="",errorMessageDiv.classList.add("hidden"),renameButton.disabled=!1,document.getElementById("inputRenameRoom").classList.remove("text-danger"))},sendGroupRename=async(name,groupId)=>{try{let group=app.groups.get(groupId);await new Promise((resolve,reject)=>{group.save({name:name},{patch:!0,success:response=>{resolve(response)},error:response=>{reject(response)}})})}catch(error){console.error("Error in sendData function:",error)}},checkGroupName=()=>{var inputField=document.getElementById("inputRenameGroup"),errorMessage=document.getElementById("renameGroupErrorMessage");if(""===inputField.value.trim())return errorMessage.textContent="Group name cannot be empty!",void inputField.focus();errorMessage.textContent="";let name=document.getElementById("inputRenameGroup").value.trim().toLowerCase(),groupNames=[];app.rooms&&app.groups.models?groupNames=app.groups.models.map(model=>{let name=model.attributes.name;return void 0!==name&&null!==name?String(name).toLowerCase():""}):console.error("app.rooms or app.groups.models is undefined or null.");let errorMessageDiv=document.getElementById("renameGroupErrorMessage"),renameButton=document.getElementById("group-rename-btn");groupNames.includes(name)?(errorMessageDiv.textContent="Group name already exists. Please choose a different name.",errorMessageDiv.classList.remove("hidden"),renameButton.disabled=!0,document.getElementById("inputRenameGroup").classList.add("text-danger")):(errorMessageDiv.textContent="",errorMessageDiv.classList.add("hidden"),renameButton.disabled=!1,document.getElementById("inputRenameGroup").classList.remove("text-danger"))};document.getElementById("inputRenameGroup").addEventListener("input",checkGroupName),document.getElementById("group-rename-btn").addEventListener("click",()=>{let name=document.getElementById("inputRenameGroup").value.trim();document.getElementById("group-rename-btn").disabled||sendGroupRename(name,app.groupId)}),document.getElementById("inputRenameRoom").addEventListener("input",checkGroupName),document.getElementById("room-rename-btn").addEventListener("click",()=>{let name=document.getElementById("inputRenameRoom").value.trim();document.getElementById("room-rename-btn").disabled||sendRoomRename(name)});export let closeFavouriteChart=intervalId=>{intervalId&&(clearInterval(intervalId),intervalId=null);let canvasContainer=document.getElementById("canvas-container"),allElements=canvasContainer.querySelectorAll(".favouriteChart, #custom-legend-container, .close");localStorage.removeItem("chartData"),allElements.forEach(element=>{element.remove()}),document.getElementById("deviceValueSettingsOuter").classList.add("hidden"),canvasContainer&&(canvasContainer.style.display="none")};export let toggleQuickType=type=>{""===type&&(type="lights");const lightsList=document.querySelector("#quickDeviceLights"),sensorsList=document.querySelector("#quickDeviceSensors"),blindsList=document.querySelector("#quickDeviceBlinds"),thermostatsList=document.querySelector("#quickDeviceThermostats"),lightsButton=document.querySelector("#toggleQuickDeviceListLights"),sensorsButton=document.querySelector("#toggleQuickDeviceListSensors"),blindsButton=document.querySelector("#toggleQuickDeviceListBlinds"),thermostatsButton=document.querySelector("#toggleQuickDeviceListThermostats"),lightsButtonMobile=document.querySelector("#toggleQuickDeviceListLightsMobile"),sensorsButtonMobile=document.querySelector("#toggleQuickDeviceListSensorsMobile"),blindsButtonMobile=document.querySelector("#toggleQuickDeviceListBlindsMobile"),thermostatsButtonMobile=document.querySelector("#toggleQuickDeviceListThermostatsMobile");switch([lightsList,sensorsList,blindsList,thermostatsList].forEach(list=>list.classList.add("hidden")),[lightsButton,sensorsButton,blindsButton,thermostatsButton].forEach(button=>button.classList.remove("active")),type){case"lights":quickScanButton.setAttribute("data-btn-ev","BTN_ADD_LIGHT_PRESSED"),lightsButton.classList.add("active"),lightsButtonMobile.classList.add("active"),lightsList.classList.remove("hidden"),sensorsList.classList.add("hidden"),blindsList.classList.add("hidden"),thermostatsList.classList.add("hidden"),sensorsButton.classList.remove("active"),blindsButton.classList.remove("active"),thermostatsButton.classList.remove("active"),sensorsButtonMobile.classList.remove("active"),blindsButtonMobile.classList.remove("active"),thermostatsButtonMobile.classList.remove("active"),localStorage.setItem("toggleQuickType",type);break;case"sensors":quickScanButton.setAttribute("data-btn-ev","BTN_ADD_SENSOR_PRESSED"),sensorsList.classList.remove("hidden"),sensorsButton.classList.add("active"),sensorsButtonMobile.classList.add("active"),lightsList.classList.add("hidden"),blindsList.classList.add("hidden"),thermostatsList.classList.add("hidden"),lightsButton.classList.remove("active"),blindsButton.classList.remove("active"),thermostatsButton.classList.remove("active"),lightsButtonMobile.classList.remove("active"),blindsButtonMobile.classList.remove("active"),thermostatsButtonMobile.classList.remove("active"),localStorage.setItem("toggleQuickType",type);break;case"blinds":quickScanButton.setAttribute("data-btn-ev","BTN_ADD_BLINDS_PRESSED"),blindsList.classList.remove("hidden"),blindsButton.classList.add("active"),blindsButtonMobile.classList.add("active"),lightsList.classList.add("hidden"),sensorsList.classList.add("hidden"),thermostatsList.classList.add("hidden"),lightsButton.classList.remove("active"),sensorsButton.classList.remove("active"),thermostatsButton.classList.remove("active"),lightsButtonMobile.classList.remove("active"),sensorsButtonMobile.classList.remove("active"),thermostatsButtonMobile.classList.remove("active"),localStorage.setItem("toggleQuickType",type);break;case"thermostats":quickScanButton.setAttribute("data-btn-ev","BTN_ADD_THERMOSTAT_PRESSED"),thermostatsList.classList.remove("hidden"),thermostatsButton.classList.add("active"),thermostatsButtonMobile.classList.add("active"),lightsList.classList.add("hidden"),sensorsList.classList.add("hidden"),blindsList.classList.add("hidden"),lightsButton.classList.remove("active"),sensorsButton.classList.remove("active"),blindsButton.classList.remove("active"),lightsButtonMobile.classList.remove("active"),sensorsButtonMobile.classList.remove("active"),blindsButtonMobile.classList.remove("active"),localStorage.setItem("toggleQuickType",type);break;default:quickScanButton.setAttribute("data-btn-ev","BTN_ADD_SENSOR_PRESSED"),sensorsList.classList.remove("hidden"),sensorsButton.classList.add("active"),sensorsButtonMobile.classList.add("active"),lightsList.classList.add("hidden"),blindsList.classList.add("hidden"),thermostatsList.classList.add("hidden"),lightsButton.classList.remove("active"),blindsButton.classList.remove("active"),thermostatsButton.classList.remove("active"),lightsButtonMobile.classList.remove("active"),blindsButtonMobile.classList.remove("active"),thermostatsButtonMobile.classList.remove("active"),localStorage.setItem("toggleQuickType","sensors")}};export let removeAllClones=ctx=>{document.querySelectorAll(".dragging").forEach(clone=>{clone.remove()})};export let toggleQuickDeviceList=ctx=>{const expandIconUse=document.querySelector("#expand_icon_quickDevice use"),quickDeviceListView=document.getElementById("quickDeviceListView"),quickScanButton=document.getElementById("quickScanButton"),roomList=document.getElementById("roomList");"#collapse-icon"===expandIconUse.getAttribute("xlink:href")?(expandIconUse.setAttribute("xlink:href","#expand-icon"),quickDeviceListView.classList.remove("collapsed"),quickScanButton.classList.remove("hidden"),roomList.style.marginBottom="100px",localStorage.setItem("quickDeviceListState","expanded")):(expandIconUse.setAttribute("xlink:href","#collapse-icon"),quickDeviceListView.classList.add("collapsed"),quickScanButton.classList.add("hidden"),roomList.style.marginBottom="5px",localStorage.setItem("quickDeviceListState","collapsed")),window.innerWidth>768&&checkExpandMoveSplitButtons(),debouncedSaveLocalStorageToUserParameter()};export let initializeQuickDeviceListState=()=>{const storedBarState=localStorage.getItem("quickDeviceListState"),storedQuickType=localStorage.getItem("toggleQuickType"),quickScanButton=document.getElementById("quickScanButton"),expandIconUse=document.querySelector("#expand_icon_quickDevice use"),quickDeviceListView=document.getElementById("quickDeviceListView"),roomList=document.getElementById("roomList"),isCollapsed="collapsed"===storedBarState||null===storedBarState;expandIconUse.setAttribute("xlink:href",isCollapsed?"#collapse-icon":"#expand-icon"),quickScanButton.classList.toggle("hidden",isCollapsed),quickDeviceListView.classList.toggle("collapsed",isCollapsed),roomList.style.marginBottom=isCollapsed?"5px":"100px";const deviceTypes=[{type:"lights",list:"#quickDeviceLights",button:"#toggleQuickDeviceListLights",buttonMobile:"#toggleQuickDeviceListLightsMobile",btnEv:"BTN_ADD_LIGHT_PRESSED"},{type:"sensors",list:"#quickDeviceSensors",button:"#toggleQuickDeviceListSensors",buttonMobile:"#toggleQuickDeviceListSensorsMobile",btnEv:"BTN_ADD_SENSOR_PRESSED"},{type:"blinds",list:"#quickDeviceBlinds",button:"#toggleQuickDeviceListBlinds",buttonMobile:"#toggleQuickDeviceListBlindsMobile",btnEv:"BTN_ADD_BLIND_PRESSED"},{type:"thermostats",list:"#quickDeviceThermostats",button:"#toggleQuickDeviceListThermostats",buttonMobile:"#toggleQuickDeviceListThermostatsMobile",btnEv:"BTN_ADD_THERMOSTAT_PRESSED"}];deviceTypes.forEach(({list:list,button:button,buttonMobile:buttonMobile})=>{document.querySelector(list).classList.add("hidden"),document.querySelector(button).classList.remove("active"),document.querySelector(buttonMobile).classList.remove("active")});const selectedType=deviceTypes.find(dt=>dt.type===storedQuickType)||deviceTypes[1];document.querySelector(selectedType.list).classList.remove("hidden"),document.querySelector(selectedType.button).classList.add("active"),document.querySelector(selectedType.buttonMobile).classList.add("active"),quickScanButton.setAttribute("data-btn-ev",selectedType.btnEv),localStorage.setItem("toggleQuickType",selectedType.type),debouncedSaveLocalStorageToUserParameter()};document.addEventListener("DOMContentLoaded",function(){function handleHorizontalScroll(ev){ev.currentTarget.scrollLeft+=ev.deltaY}function attachScrollListeners(){const quickDeviceLightsList=document.getElementById("quickDeviceLights"),quickDeviceSensorsList=document.getElementById("quickDeviceSensors"),quickDeviceBlindsList=document.getElementById("quickDeviceBlinds"),quickDeviceThermostatsList=document.getElementById("quickDeviceThermostats");window.matchMedia("(min-width: 768px)").matches?(quickDeviceLightsList.addEventListener("wheel",handleHorizontalScroll,{passive:!0}),quickDeviceSensorsList.addEventListener("wheel",handleHorizontalScroll,{passive:!0}),quickDeviceBlindsList.addEventListener("wheel",handleHorizontalScroll,{passive:!0}),quickDeviceThermostatsList.addEventListener("wheel",handleHorizontalScroll,{passive:!0})):(quickDeviceLightsList.removeEventListener("wheel",handleHorizontalScroll),quickDeviceSensorsList.removeEventListener("wheel",handleHorizontalScroll),quickDeviceBlindsList.removeEventListener("wheel",handleHorizontalScroll),quickDeviceThermostatsList.removeEventListener("wheel",handleHorizontalScroll))}window.addEventListener("load",attachScrollListeners),window.addEventListener("resize",attachScrollListeners)});export let checkRoomAmount=()=>{restGetResource(app.rooms).then(()=>{0===app.rooms.length?document.getElementById("norooms").classList="":document.getElementById("norooms").classList="hidden"})};export let enableHelpMenu=()=>{$("#helpMenuModal").modal("show"),$("#helpMenuModal").on("shown.bs.modal",function(){onModalOpen(),switchView(1)})};export let enableHelpMenuGroups=()=>{$("#helpMenuGroupsModal").modal("show"),$("#helpMenuGroupsModal").on("shown.bs.modal",function(){onModalOpen(),handleViewChange(1)})};export function handleOutsideClick(event){let now=new Date;if(app.closeDeviceSettingsTimer){if(now-app.closeDeviceSettingsTimer<500)return}if(event.target.classList.contains("hidden"))return;[{container:document.getElementById("deviceValueSettings"),closeButton:document.getElementById("closeDeviceSettings")},{container:document.getElementById("wrapperThermostat"),closeButton:document.getElementById("closeThermostatChange")},{container:document.getElementById("sliderWrapper"),closeButton:document.getElementById("closeLightSlider")},{container:document.getElementById("sliderWrapperBlinds"),closeButton:document.getElementById("closeBlindSlider")},{container:document.getElementById("canvas-container"),closeButton:document.querySelector("#canvas-container button")},{container:document.getElementById("dotMenuOnOff"),closeButton:null},{container:document.getElementById("dotMenuSettings"),closeButton:null},{container:document.getElementById("toggleMoveRoom"),closeButton:null},{container:document.getElementById("logMoveDevices"),closeButton:null}].forEach(({container:container,closeButton:closeButton})=>{try{if(container&&!container.classList.contains("hidden")&&("object"!=typeof event.target.className&&event.target.className.includes("device")&&container.classList.add("hidden"),!container.contains(event.target)&&event.target!==closeButton)){const nameRow=container.querySelector("li:first-child"),sensorNameText=container.querySelector(".deviceNameText"),sensorNameInput=container.querySelector(".nameInput"),saveButton=container.querySelector(".saveButton");nameRow&&nameRow.classList.remove("no-hover"),sensorNameText&&sensorNameText.classList.remove("hidden"),sensorNameInput&&sensorNameInput.classList.add("hidden"),saveButton&&saveButton.classList.add("hidden"),container.classList.add("hidden")}}catch(error){console.log(error)}}),document.querySelector("#deviceValueSettingsOuter").classList.add("hidden")};function getRoomStates(){return roomStates}function saveRoomStates(updatedStates){roomStates={...updatedStates}}export function toggleRoomExpansion(){try{document.querySelectorAll(".roomItemView[data-roomid]").forEach(roomItem=>{const roomId=roomItem.attributes["data-roomid"].value;roomItem.classList.contains("expanded")?(roomItem.classList.remove("expanded"),roomStates[roomId]=!1):(roomItem.classList.add("expanded"),roomStates[roomId]=!0)})}catch(error){console.error("Error toggling rooms:",error)}};export function restoreRoomExpansions(){try{document.querySelectorAll(".roomItemView").forEach(roomItem=>{const roomId=roomItem.attributes["data-roomid"].value;!0===roomStates[roomId]?roomItem.classList.add("expanded"):roomItem.classList.remove("expanded")})}catch(error){console.error("Error restoring room expansions:",error)}};export function startScanProgress(){scanInProgress||(scanInProgress=!0,document.getElementById("progress-bar").style.width="0%",document.getElementById("progress-bar").style.height="0%",startTime=Date.now(),endTime=startTime+1e4,app.lightScan.start(),startScan(min,pollState))};export function stopScanning(){scanInProgress&&(scanInProgress=!1,min=void 0,app.timerSeconds=0,cancelAnimationFrame(app.searchRaf),document.getElementById("progress-bar").style.width="0%",document.getElementById("progress-bar").style.height="0%",app.$time.css("opacity","0"),disableSensorSearch())};function startScan(min,pollState){pollState!==SEARCH_SENSORS_ENABLED&&(app.lightsBeforeSearch=[],app.lights.forEach(l=>{isFlsPpWhite(l)||app.lightsBeforeSearch.push(l.id)})),enableSensorSearch();const isMobile=window.innerWidth<=767,progressBar=document.getElementById("progress-bar");let duration=app.config.get("networkopenduration");if(duration>0&&app.timerSeconds>0)return;if(!(duration>0))return void(app.timerSeconds>0&&(app.timerSeconds=0));app.timerSeconds=duration,app.$time=$("#time"),app.$timeLabels=app.$time.find("span");let startTime=Date.now(),endTime=startTime+1e3*app.timerSeconds;app.searchRaf=requestAnimationFrame(function frame(){app.searchRaf=null;let pos=(Date.now()-startTime)/(endTime-startTime);pos=Math.max(0,Math.min(1,pos));const progressBarContainer=document.getElementById("progress-bar-container"),maxWidth=progressBarContainer.offsetWidth,maxHeight=progressBarContainer.offsetHeight;if(isMobile?(progressBarContainer.style.height="100vh",progressBar.style.width="4px",progressBar.style.height=maxHeight*pos+"px"):(progressBarContainer.style.height="100%",progressBar.style.height="4px",progressBar.style.width=maxWidth*pos+"px"),pos>=1||0===app.timerSeconds){app.timerSeconds=0,app.$time.css("opacity","0"),disableSensorSearch(),stopScanning();const iconUse=document.getElementById("iconUse");iconUse.setAttribute("xlink:href","#add-icon-sm"),iconUse.parentElement.parentElement.classList.remove("deleteIcon"),scanInProgress=!1}else app.searchRaf=requestAnimationFrame(frame)})}function enableSensorSearch(){pollState!==SEARCH_SENSORS_ENABLED&&(pollState=SEARCH_SENSORS_ENABLED,console.log("enable sensor search"))}function disableSensorSearch(){pollState!==SEARCH_SENSORS_DISABLED&&(pollState=SEARCH_SENSORS_DISABLED,console.log("disable sensor search"))}