/*! phoscon-app 2025-10-13 */

export const getThermostatChangeView=(constants,service)=>{return new(Backbone.View.extend({el:"#thermostatChangeContainer",initialize:function(){this.sensor=null,this.measureMouseClickTimerStart=null,this.measureMouseClickTimerEnd=null,this.changeValueInterval=null,this.measureMouseClickTimeout=null,this.value=0,document.getElementById("closeThermostatChange").addEventListener("click",this.eventClose.bind(this)),this.render()},events:{'click [data-btn-event="DEVICE_VALUE"]':"eventSelectDeviceValue",'pointerdown [data-btn-event="INCREASE_TEMP"]':"startMouseClickIncreaseTemp",'pointerup  [data-btn-event="INCREASE_TEMP"]':"stopMouseClickIncreaseTemp",'pointerdown [data-btn-event="DECREASE_TEMP"]':"startMouseClickDecreaseTemp",'pointerup  [data-btn-event="DECREASE_TEMP"]':"stopMouseClickDecreaseTemp"},render:function(){return this.$el.empty(),null!=this.sensor&&(this.el.innerHTML=`\n                    <li class="deviceValueSettingsItem">\n                        <div class="deviceValueWrapper">\n                            <div class="nameContainer">\n                                <svg data-btn-event="EDIT_DEVICE_NAME" width="24" height="24" aria-hidden="true">\n                                    <use transform="scale(0.5)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#temperature-icon"></use>\n                                </svg>\n                            </div>\n                            <div class="deviceValueLabel">${translate("text_temperature")}</div>\n                            <div class="deviceNameWrapper">\n                            <button data-btn-event="DECREASE_TEMP" class="tempButton">\n                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="17" fill="currentColor" class="bi bi-dash" viewBox="0 0 16 16">\n                                    <use transform="scale(0.7)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#minus-icon-sm"></use>\n                                </svg>\n                            </button>\n                                <span id="temperatureDisplay" class="deviceNameText">${this.getFormattedTemperature()}</span>\n                                <button data-btn-event="INCREASE_TEMP" class="tempButton">\n                                    <svg data-btn-event="EDIT_DEVICE_NAME" width="17" height="17" aria-hidden="true">\n                                        <use transform="scale(0.7)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#add-icon-sm"></use>\n                                    </svg>\n                                </button> \n                            </div>\n                        </div>\n                    </li>`),this.tempText=this.el.querySelector("#temperatureDisplay"),this},startMouseClickIncreaseTemp:function(){this.measureMouseClickTimerStart=new Date,this.measureMouseClickTimeout||(this.measureMouseClickTimeout=setTimeout(()=>{this.value=Number(this.tempText.innerHTML.split("°")[0]),this.value>=35||this.changeValueInterval||(this.changeValueInterval=setInterval(()=>{this.value+=1,this.value%1==0?this.tempText.innerHTML=this.value+".0°C":this.tempText.innerHTML=this.value+"°C",this.value>=35&&(clearInterval(this.changeValueInterval),this.changeValueInterval=null)},250))},300))},stopMouseClickIncreaseTemp:function(){clearTimeout(this.measureMouseClickTimeout),this.measureMouseClickTimeout=null,clearInterval(this.changeValueInterval),this.changeValueInterval=null,this.measureMouseClickTimerEnd=new Date;let timeEllapsed=this.measureMouseClickTimerEnd.getTime()-this.measureMouseClickTimerStart.getTime();console.log(timeEllapsed),timeEllapsed<300?this.eventIncreaseTemp():this.sensor&&this.sensor.attributes.config&&(this.sensor.attributes.config.heatsetpoint=100*this.value,this.saveTemperature())},startMouseClickDecreaseTemp:function(){this.measureMouseClickTimerStart=new Date,this.measureMouseClickTimeout||(this.measureMouseClickTimeout=setTimeout(()=>{this.value=Number(this.tempText.innerHTML.split("°")[0]),this.value<=5||this.changeValueInterval||(this.changeValueInterval=setInterval(()=>{this.value-=1,this.value%1==0?this.tempText.innerHTML=this.value+".0°C":this.tempText.innerHTML=this.value+"°C",this.value<=5&&(clearInterval(this.changeValueInterval),this.changeValueInterval=null)},250))},300))},stopMouseClickDecreaseTemp:function(){clearTimeout(this.measureMouseClickTimeout),this.measureMouseClickTimeout=null,clearInterval(this.changeValueInterval),this.changeValueInterval=null,this.measureMouseClickTimerEnd=new Date;let timeEllapsed=this.measureMouseClickTimerEnd.getTime()-this.measureMouseClickTimerStart.getTime();console.log(timeEllapsed),timeEllapsed<300?this.eventDecreaseTemp():this.sensor&&this.sensor.attributes.config&&(this.sensor.attributes.config.heatsetpoint=100*this.value,this.saveTemperature())},getFormattedTemperature:function(){return this.sensor&&this.sensor.attributes.config?(this.sensor.attributes.config.heatsetpoint/100).toFixed(1)+"°C":"N/A"},selectThermostat:function(sensor){document.getElementById("wrapperThermostat").classList.remove("hidden");document.getElementById("wrapperThermostat");this.el.parentElement.querySelector("#deviceName").innerHTML=sensor.get("name"),this.sensor=sensor,this.render()},eventClose:function(event){document.getElementById("wrapperThermostat").classList.add("hidden"),document.querySelector("#deviceValueSettingsOuter").classList.add("hidden"),this.clearSettings()},clearSettings:function(){this.sensor=null,this.$el.empty()},eventIncreaseTemp:function(event){if(this.sensor&&this.sensor.attributes.config){if(Number(this.tempText.innerHTML.split("°")[0])>=35)return;let currentTemp=100*Number(this.tempText.innerHTML.split("°")[0]);currentTemp+=50,this.sensor.attributes.config.heatsetpoint=currentTemp,this.updateTemperatureDisplay(),this.saveTemperature()}},eventDecreaseTemp:function(event){if(!(Number(this.tempText.innerHTML.split("°")[0])<=5)&&this.sensor&&this.sensor.attributes.config){let currentTemp=100*Number(this.tempText.innerHTML.split("°")[0]);currentTemp-=50,this.sensor.attributes.config.heatsetpoint=currentTemp,this.updateTemperatureDisplay(),this.saveTemperature()}},updateTemperatureDisplay:function(){const temperatureDisplay=document.getElementById("temperatureDisplay");temperatureDisplay&&(temperatureDisplay.textContent=this.getFormattedTemperature())},saveTemperature:function(){if(this.sensor){let sensor=app.sensors.get(this.sensor.attributes.id);sensor.save({config:this.sensor.attributes.config},{patch:!0,success:()=>{this.sensor=sensor},error:(model,response)=>{console.error("Failed to save temperature:",response)}})}}}))};