/*! phoscon-app 2025-10-13 */

import*as constants from"./main/main-constants.js";import*as factories from"./main/main-factory-functions.js";import*as dashboardFactories from"./dashboard/dashboard-functions.js";import*as groupsFactories from"./groups-page/group-functions.js";import{getAllOffView}from"./main/all-off-view.js";import{getRoomView}from"./dashboard/room-view.js";import{getMainView}from"./main/main-view.js";import{getQuickDeviceView}from"./dashboard/quickdevice-view.js";import{getGroupView}from"./groups-page/group-view.js";import{getDeviceValueSelectView}from"./main/device-view.js";import{getMachine}from"./main/main-machine.js";import{getMigrationGroupView}from"./dashboard/migration-wizzard-view.js";import{getLightSliderView}from"./main/light-slider-view.js";import{getBlindSliderView}from"./main/blind-slider-view.js";import{getThermostatChangeView}from"./main/thermostat-change-view.js";import{checkRoomAmount,restoreIntervals,removeExistingChartData,chartIntervalRemove,removeSensorDataLocal}from"./dashboard/dashboard-functions.js";initApp();try{restGetResource(app.config).then(()=>restGetResource(app.lights)).then(()=>restGetResource(app.sensors)).then(()=>restGetResource(app.rooms)).then(()=>restGetResource(app.groups)).then(()=>restGetResource(app.resourcelinks)).then(()=>restGetResource(app.schedules)).then(()=>restGetResource(app.userparameter)).then(res=>{setTimeout(()=>app.poll.pollRepeated(app.config),5e3),setTimeout(()=>app.poll.pollRepeated(app.lights),5e3),setTimeout(()=>app.poll.pollRepeated(app.sensors),5e3),setTimeout(()=>app.poll.pollRepeated(app.rooms),5e3),setTimeout(()=>app.poll.pollRepeated(app.groups),5e3),setTimeout(()=>app.poll.pollRepeated(app.resourcelinks),5e3),setTimeout(()=>app.poll.pollRepeated(app.schedules),5e3),setTimeout(()=>app.poll.pollRepeated(app.userparameter),5e3)}).then(()=>{"60"==app.config.get("networkopenduration")&&app.config.save({networkopenduration:"180"},{patch:!0})}).then(()=>initLogic())}catch(error){console.error("Error during app initialization:",error)}async function initLogic(){loadLocalStorageFromUserParameter(),app.session.roomElements=0;let{service:service}=getMachine(factories,dashboardFactories,groupsFactories);var Router=Backbone.Router.extend({routes:{"dashboard-overview":"showDashboardOverview",groups:"showGroups","groups/:id":"reloadGroups"},showDashboardOverview:function(id){service.send({type:constants.events.DASHBOARD_INIT})},showGroups:function(){window.location.href+="/"+app.session.roomId,service.send({type:constants.events.DASHBOARD_ROOM_CLICKED})},reloadGroups:function(){app.session.roomId=location.hash.split("/")[1],service.send({type:constants.events.DASHBOARD_ROOM_CLICKED})}});app.router=new Router,Backbone.history.start(),window.location.href.split("#")[1]||app.router.navigate("dashboard-overview",{trigger:!0}),service.send({type:constants.events.DASHBOARD_CHECK_MIGRATION}),app.SegmentCol=new DLSEGMENT_Collection,setTimeout(checkPirRulesConsistency,3e3),app.main=document.querySelector(".body-content .main"),app.mainView=getMainView(constants,service),app.roomViews=getRoomView(constants,service),app.groupPageViews=getGroupView(constants,service),app.quickDeviceViews=getQuickDeviceView(constants,service),app.deviceValuesListView=getDeviceValueSelectView(constants,service),app.thermostatChangeViews=getThermostatChangeView(constants,service),app.lightSliderViews=getLightSliderView(constants,service),app.blindSliderViews=getBlindSliderView(constants,service),app.allOffViews=getAllOffView(),app.migrationGroupView=getMigrationGroupView(constants,service)[0],app.migrationGroupView2=getMigrationGroupView(constants,service)[1],app.migrationGroupView.checkButton(),app.show_create_room_btn=document.getElementById("showCreateRoom"),app.show_create_group_btn=document.getElementById("showCreateGroup"),app.create_room_btn=document.getElementById("room-create-btn"),app.first_create_room_btn=document.getElementById("first-room-create-btn"),app.toggle_on_off_btn=document.getElementById("toggleOnOff"),app.delete_room_btn=document.getElementById("rely-delete-room-btn"),app.delete_group_btn=document.getElementById("deleteGroupBtn"),app.migration_apply_btn=document.getElementById("update-apply-btn"),window.addEventListener("pagehide",function(){sessionStorage.setItem("app.index.hash",location.hash),sessionStorage.setItem("app.index.path",location.pathname+(location.search||"?"+app.pageDate))}),$("#updateAssistantModal2").on("hide.bs.modal",()=>{service.send({type:constants.events.DASHBOARD_CHECK_MIGRATION})}),$("#dotmenuModal").on("show.bs.modal",()=>{document.getElementById("dotMenuOnOff").classList.add("hidden"),document.getElementById("dotMenuSettings").classList.add("hidden"),document.getElementById("deviceValueSettingsOuter").classList.add("hidden")}),$("#allOffModal").on("show.bs.modal",()=>{document.getElementById("dotMenuOnOff").classList.add("hidden"),document.getElementById("dotMenuSettings").classList.add("hidden"),document.getElementById("deviceValueSettingsOuter").classList.add("hidden")}),app.show_create_room_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_ROOM_SHOW_CREATE})}),app.show_create_group_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_GROUP_SHOW_CREATE})}),app.create_room_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_GROUP_SHOW_CREATE,name:document.getElementById("inputCreateGroup").value})}),app.delete_room_btn.addEventListener("click",()=>{if(app.settings_room){service.send({type:constants.events.DASHBOARD_ROOM_DELETED,room:app.settings_room.model});let id=app.settings_room.model.id;removeExistingChartData(id),chartIntervalRemove(id),close_settings_modal()}}),app.delete_group_btn.addEventListener("click",()=>{app.session.group&&service.send({type:constants.events.DASHBOARD_GROUP_DELETED,group:app.session.group})}),app.create_room_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_ROOM_CREATE,name:document.getElementById("inputCreateRoom").value})}),app.first_create_room_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_ROOM_CREATE,name:document.getElementById("inputCreateFirstRoom").value})}),app.toggle_on_off_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_ALL_OFF})}),app.migration_apply_btn.addEventListener("click",()=>{service.send({type:constants.events.DASHBOARD_APPLY_MIGRATION})}),document.getElementById("showHelpMenu").classList.remove("hidden"),document.getElementById("showHelpMenuGroups").classList.remove("hidden"),checkRoomAmount(),restoreIntervals(),restGetResource(app.rooms).then(()=>{0===app.rooms.length&&(document.querySelector("#showUpdateAssistant").classList.contains("hidden")?(clearFirstRoomNameInputField(),$("#firstRoomModal").modal("show")):$("#migrationWelcomeModal").modal("show"))}),void 0!==app.resourcelinks&&await checkGroupResourcelinks(),setTimeout(function(){let bridgeid=app.config.get("bridgeid")||"",apikey=app.apikey||"",ip=app.config.get("ipaddress")||"";app.Devicetype.sendMessage("INDEX_PAGE_READY",'{"bridgeid":"'+bridgeid+'", "apikey":"'+apikey+'", "ip":"'+ip+'"}')},300)}function getSensorArrayInfo(sensor){if(!sensor)return;let uniqueIdPrefix,sensors=[];if("function"==typeof sensor.get){const uniqueId=sensor.get("uniqueid")||sensor.get("mac");null!=uniqueId&&"string"==typeof uniqueId&&(uniqueIdPrefix=uniqueId.split("-")[0])}if(uniqueIdPrefix){if(app.sensors.forEach(searchSensor=>{const searchSensorUniqueId=searchSensor.get("uniqueid");if(null!=searchSensorUniqueId&&"string"==typeof searchSensorUniqueId){searchSensorUniqueId.split("-")[0]===uniqueIdPrefix&&sensors.push(searchSensor)}}),"Window covering device"===sensor.get("type")){let blind=app.lights.get(sensor.get("id"));blind&&sensors.push(blind)}}else{if("function"!=typeof sensor.get)return[];if("PHDL00"!==sensor.get("modelid")||!sensor.get("name").includes("Daylight"))return[];sensors=[sensor]}let battery,temperature,current,power,voltage,consumption,humidity,tvoc,airquality,airpressure,formaldehyde,particulateMatter,cO2,daylight,sunrise,sunset,window,openClose,water,presence,lightlevel,airqualityppb,alarm,carbonmonoxide,fire,fireTest,lux,buttonevent,gesture,angle,x,y,pressure,on,errorcode,fanmode,floortemperature,heating,value,vibration,tiltangle,vibrationstrength,charging,presenceevent,mode,windowcoveringtype,externalsensortemp,externalwindowopen,locked,preset,swingmode,coolsetpoint,heatsetpoint,sensitivity,sensitivitymax,triggerdistance,pulseconfiguration,moisture,replacefilter,speed,lift,orientation,alarmLabel,{manufacturername:manufacturername,modelid:modelid,state:state}=sensor.attributes,open=void 0,alarmIcon=void 0,isReachable=void 0;const getValue=function(sensor,key){let value,{config:config,state:state,capabilities:capabilities}=sensor.attributes;return state&&void 0!==(value=state[key])&&null!==value?value:config&&void 0!==(value=config[key])&&null!==value?value:(capabilities&&capabilities.measured_value&&key===capabilities.measured_value.substance&&(value=void 0!==state?state.measured_value:void 0!==config?config.measured_value:void 0),null!==value?value:void 0)};return sensors.forEach(sensor=>{let{config:config,state:state}=sensor.attributes;if(isReachable=config&&void 0!==config.reachable?config.reachable:!(!state||void 0===state.reachable)&&state.reachable,void 0==battery&&(battery=getValue(sensor,"battery")),void 0==temperature&&(temperature=getValue(sensor,"temperature")),void 0==current&&(current=getValue(sensor,"current")),void 0==power&&(power=getValue(sensor,"power")),void 0==voltage&&(voltage=getValue(sensor,"voltage")),void 0==moisture&&(moisture=getValue(sensor,"moisture")),void 0==fire&&(fire=getValue(sensor,"fire")),void 0==fireTest&&(fireTest=getValue(sensor,"fireTest")),void 0==lux&&(lux=getValue(sensor,"lux")),void 0==lightlevel&&(lightlevel=getValue(sensor,"lightlevel")),void 0==buttonevent&&(buttonevent=getValue(sensor,"buttonevent")),void 0==gesture&&(gesture=getValue(sensor,"gesture")),void 0==angle&&(angle=getValue(sensor,"angle")),void 0==x&&(x=getValue(sensor,"x")),void 0==y&&(y=getValue(sensor,"y")),void 0==pressure&&(pressure=getValue(sensor,"pressure")),void 0==on&&(on=getValue(sensor,"on")),void 0==errorcode&&(errorcode=getValue(sensor,"errorcode")),void 0==floortemperature&&(floortemperature=getValue(sensor,"floortemperature")),void 0==heating&&(heating=getValue(sensor,"heating")),void 0==value&&(value=getValue(sensor,"value")),void 0==vibration&&(vibration=getValue(sensor,"vibration")),void 0==tiltangle&&(tiltangle=getValue(sensor,"tiltangle")),void 0==vibrationstrength&&(vibrationstrength=getValue(sensor,"vibrationstrength")),void 0==charging&&(charging=getValue(sensor,"charging")),void 0==presenceevent&&(presenceevent=getValue(sensor,"presenceevent")),void 0==mode&&(mode=getValue(sensor,"mode")),void 0==windowcoveringtype&&(windowcoveringtype=getValue(sensor,"windowcoveringtype")),void 0==externalsensortemp&&(externalsensortemp=getValue(sensor,"externalsensortemp")),void 0==externalwindowopen&&(externalwindowopen=getValue(sensor,"externalwindowopen")),void 0==fanmode&&(fanmode=getValue(sensor,"fanmode")),void 0==locked&&(locked=getValue(sensor,"locked")),void 0==preset&&(preset=getValue(sensor,"preset")),void 0==swingmode&&(swingmode=getValue(sensor,"swingmode")),void 0==coolsetpoint&&(coolsetpoint=getValue(sensor,"coolsetpoint")),void 0===heatsetpoint&&(heatsetpoint=getValue(sensor,"heatsetpoint")),void 0==sensitivity&&(sensitivity=getValue(sensor,"sensitivity")),void 0==sensitivitymax&&(sensitivitymax=getValue(sensor,"sensitivitymax")),void 0==triggerdistance&&(triggerdistance=getValue(sensor,"triggerdistance")),void 0==pulseconfiguration&&(pulseconfiguration=getValue(sensor,"pulseconfiguration")),void 0==consumption&&(consumption=getValue(sensor,"consumption")),void 0==humidity&&(humidity=getValue(sensor,"humidity")),void 0==tvoc&&(tvoc=getValue(sensor,"tVOC")),void 0==carbonmonoxide&&(carbonmonoxide=getValue(sensor,"carbonmonoxide")),void 0==airqualityppb&&(airqualityppb=getValue(sensor,"airqualityppb")),void 0==airquality&&(airquality=getValue(sensor,"airquality")),void 0==airpressure&&(airpressure=getValue(sensor,"airpressure")),void 0==formaldehyde&&(formaldehyde=getValue(sensor,"Formaldehyde")),void 0==particulateMatter&&(particulateMatter=getValue(sensor,"PM2.5")),void 0==cO2&&(cO2=getValue(sensor,"CO")),void 0==orientation&&(orientation=getValue(sensor,"orientation")),void 0==daylight&&(daylight=getValue(sensor,"daylight")),void 0==alarm&&(alarm=getValue(sensor,"alarm")),void 0==sunrise&&state&&void 0!=state.sunrise){let year=state.sunrise.split("-")[0],month=state.sunrise.split("-")[1],day=state.sunrise.split("-")[2].split("T")[0],hour=state.sunrise.split("T")[1].split(":")[0],minute=state.sunrise.split("T")[1].split(":")[1],sec=state.sunrise.split("T")[1].split(":")[2];sunrise=new Date(Date.UTC(year,month,day,hour,minute,sec)).toLocaleTimeString(navigator.language)}if(void 0==sunset&&state&&void 0!=state.sunset){let year=state.sunset.split("-")[0],month=state.sunset.split("-")[1],day=state.sunset.split("-")[2].split("T")[0],hour=state.sunset.split("T")[1].split(":")[0],minute=state.sunset.split("T")[1].split(":")[1],sec=state.sunset.split("T")[1].split(":")[2];sunset=new Date(Date.UTC(year,month,day,hour,minute,sec)).toLocaleTimeString(navigator.language)}void 0==window&&(window=getValue(sensor,"windowopen")),void 0==openClose&&(openClose=getValue(sensor,"openclose")),void 0==lift&&(lift=getValue(sensor,"lift")),void 0==open&&(open=getValue(sensor,"open")),void 0==water&&(water=getValue(sensor,"water")),void 0==presence&&(presence=getValue(sensor,"presence")),void 0==replacefilter&&(replacefilter=getValue(sensor,"replacefilter")),void 0==speed&&(speed=getValue(sensor,"speed")),void 0==mode&&(mode=getValue(sensor,"mode")),state&&void 0!==alarm&&(alarm=state.alarm?translate("text_detected_true"):translate("text_detected"),sensor.get("modelid").includes("water")?(alarmLabel=translate("text_water"),alarmIcon=void 0!=alarm?alarm?'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-detected-icon"></use>':'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-drop-icon"></use>':void 0):sensor.get("modelid").includes("fire")&&(alarmLabel=translate("th_fire"),alarmIcon=void 0!=alarm?alarm?'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-detected-icon"></use>':'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-drop-icon"></use>':void 0))}),[{label:translate("text_mac"),unit:"",type:"macid",value:uniqueIdPrefix,isReachable:isReachable},{label:translate("text_vendor"),unit:"",type:"manufacture",value:manufacturername,isReachable:isReachable},{label:translate("text_product"),unit:"",type:"product",value:modelid,isReachable:isReachable},{label:translate("text_battery"),unit:"%",type:"battery",value:battery,isReachable:isReachable,icon:`<svg xmlns="http://www.w3.org/2000/svg" width="24" height="15" viewBox="0 0 20 8">\x3c!-- Outer battery container --\x3e<rect x="0" y="0" width="16" height="6" rx="1" ry="1" fill="#555" />\x3c!-- Inner battery fill --\x3e<rect x="1" y="1" width="${.14*battery}" height="4" rx="0.5" ry="0.5" fill="${battery>20?"#4caf50":"#ffeb3b"}" />\x3c!-- Battery terminal --\x3e<rect x="16" y="2" width="2" height="3" rx="0.5" ry="0.5" fill="#555" /></svg>`},{label:translate("text_temperature"),unit:"°C",type:"temperature",value:void 0!==temperature?(temperature/100).toFixed(1):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#sensor-temperature-icon"></use>'},{label:translate("text_current"),unit:"mA",type:"current",value:current,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#socket-icon"></use>'},{label:translate("text_sensorPower"),unit:"W",type:"power",value:power,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#socket-icon"></use>'},{label:translate("text_voltage"),unit:"V",type:"voltage",value:voltage,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#socket-icon"></use>'},{label:translate("text_humidity"),unit:"%",type:"moisture",value:void 0!==moisture?(moisture/100).toFixed(1).replace(/\.00$/,""):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_heatsetpoint"),unit:"°C",type:"heatsetpoint",value:void 0!==heatsetpoint?heatsetpoint/100:void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#thermostat-icon"></use>'},{label:translate("text_consumption"),unit:"kWh",type:"consumption",value:void 0!==consumption?(consumption/1e3).toFixed(1):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#socket-icon"></use>'},{label:translate("text_humidity"),unit:"%",type:"humidity",value:void 0!=humidity?(humidity/100).toFixed(1).replace(/\.00$/,""):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_tvoc"),unit:"ppb",type:"tvoc",value:tvoc,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_airQuality"),unit:"",type:"airQuality",value:airquality?translate("txt_"+airquality):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_airQuality"),unit:"ppb",type:"airQualityppb",value:airqualityppb,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_airPressure"),unit:"hPa",type:"airpressure",value:airpressure,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#sensor-pressure-icon"></use>'},{label:translate("text_airPressure"),unit:"hPa",type:"pressure",value:pressure,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#sensor-pressure-icon"></use>'},{label:translate("text_formaldehyde"),unit:"ppm",type:"formaldehyde",value:formaldehyde,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_particulateMatter"),unit:"µg/m³",type:"particulateMatter",value:65535==particulateMatter?"---":particulateMatter,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("text_cO2"),unit:"ppm",type:"cO2",value:cO2,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#humidity-icon"></use>'},{label:translate("th_fire"),unit:"",type:"fire",value:void 0!=fire?fire?translate("th_fire"):translate("th_nofire"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#fire-icon"></use>'},{label:translate("th_fireTest"),unit:"",type:"test",value:void 0!=fireTest?fireTest?translate("th_firetest"):translate("th_nofiretest"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#fire-icon"></use>'},{label:translate("text_daylight"),unit:"",type:"daylight",value:void 0!=daylight?daylight?translate("text_day"):translate("text_night"):void 0,isReachable:!0,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#daylight-sensor-icon"></use>'},{label:translate("text_sunrise"),unit:"",type:"sunrise",value:sunrise,isReachable:!0,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#daylight-sensor-icon"></use>'},{label:translate("text_sunset"),unit:"",type:"sunset",value:sunset,isReachable:!0,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#daylight-sensor-icon"></use>'},{label:translate("text_window"),unit:"",type:"window",value:void 0!=window?window?translate("text_open"):translate("text_closed"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#window-icon"></use>'},{label:translate("text_openClose"),unit:"",type:"openClose",value:void 0!=openClose?openClose?translate("text_open"):translate("text_closed"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#door-icon"></use>'},{label:translate("text_water"),unit:"",type:"water",value:void 0!=water?water?translate("text_detected_true"):translate("text_detected"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-drop-icon"></use>'},{label:translate("text_presence"),unit:"",type:"presence",value:void 0!=presence?presence?translate("text_detected_true"):translate("text_detected"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#motion-detected-icon"></use>'},{label:translate("text_updated"),unit:"",type:"updated",value:new Date(state.lastupdated||sensor.attributes.lastseen).toLocaleString(),isReachable:isReachable},{label:translate("text_lightLevel"),unit:"lux",type:"lightlevel",value:calcLux(lightlevel),isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#sun-icon"></use>'},{label:translate("text_filter"),unit:"",type:"filter",value:void 0!=replacefilter?replacefilter?translate("text_please_change"):translate("text_okay"):void 0,isReachable:isReachable},{label:translate("th_speed"),unit:"",type:"speed",value:void 0!=speed?speed/20:void 0,isReachable:isReachable},{label:translate("th_mode"),unit:"",type:"mode",value:selectMode(mode),isReachable:isReachable},{label:translate("th_vibration"),unit:"",type:"vibration",value:void 0!=vibration?vibration?translate("text_detected_true"):translate("text_detected"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#ZHAVibration-icon"></use>'},{label:alarmLabel||translate("text_alarm"),unit:"",type:"alarm",value:void 0!=alarm?alarm?translate("text_detected_true"):translate("text_detected"):void 0,raw_value:alarm,isReachable:isReachable,icon:alarmIcon},{label:translate("text_tilt"),unit:"°",type:"tiltangle",value:tiltangle,isReachable:isReachable},{label:translate("txt_opened"),unit:"%",type:"lift",value:lift,isReachable:isReachable},{label:translate("text_orientation"),unit:"",type:"orientation",value:orientation,isReachable:isReachable},{label:translate("text_charging"),unit:"",type:"charging",value:void 0!=charging?1==charging?translate("text_charge"):translate("text_discharge"):void 0,isReachable:isReachable},{label:translate("text_presenceevent"),unit:"",type:"presenceevent",value:presenceevent,isReachable:isReachable},{label:translate("text_windowcoveringtype"),unit:"",type:"windowcoveringtype",value:windowcoveringtype,isReachable:isReachable},{label:translate("text_externalsensortemp"),unit:"°C",type:"externalsensortemp",value:void 0!==externalsensortemp?(externalsensortemp/100).toFixed(1):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#sensor-temperature-icon"></use>'},{label:translate("text_externalwindowopen"),unit:"",type:"externalwindowopen",value:void 0!==externalwindowopen?externalwindowopen?translate("text_open"):translate("text_closed"):void 0,isReachable:isReachable},{label:translate("text_fanmode"),unit:"",type:"fanmode",value:fanmode,isReachable:isReachable},{label:translate("text_locked"),unit:"",type:"locked",value:void 0!==locked?1==locked?translate("text_on"):translate("text_off"):void 0,isReachable:isReachable},{label:translate("text_preset"),unit:"",type:"preset",value:void 0!==preset?"manual"===preset?translate("th_manual"):translate("th_auto"):void 0,isReachable:isReachable},{label:translate("text_swingmode"),unit:"",type:"swingmode",value:swingmode,isReachable:isReachable},{label:translate("text_coolsetpoint"),unit:"°C",type:"coolsetpoint",value:coolsetpoint,isReachable:isReachable},{label:translate("text_sensitivity"),unit:"",type:"sensitivity",value:sensitivity,isReachable:isReachable},{label:translate("text_sensitivitymax"),unit:"",type:"sensitivitymax",value:sensitivitymax,isReachable:isReachable},{label:translate("text_triggerdistance"),unit:"",type:"triggerdistance",value:triggerdistance,isReachable:isReachable},{label:translate("text_pulseconfiguration"),unit:"",type:"pulseconfiguration",value:pulseconfiguration,isReachable:isReachable},{label:translate("text_vibrationstrength"),unit:"",type:"vibrationstrength",value:vibrationstrength,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#ZHAVibration-icon"></use>'},{label:translate("th_state"),unit:"",type:"open",value:void 0!=open?open?translate("text_open"):translate("text_closed"):void 0,isReachable:isReachable,icon:'<use transform="scale(0.4)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#water-drop-icon"></use>'}].filter(sensor=>void 0!==sensor.value)}function getSubSensors(sensor){let uniqueIdPrefix,sensors=[];if("function"==typeof sensor.get){const uniqueId=sensor.get("uniqueid");null!=uniqueId&&"string"==typeof uniqueId&&(uniqueIdPrefix=uniqueId.split("-")[0])}if(uniqueIdPrefix)app.sensors.forEach(searchSensor=>{const searchSensorUniqueId=searchSensor.get("uniqueid");if(null!=searchSensorUniqueId&&"string"==typeof searchSensorUniqueId){searchSensorUniqueId.split("-")[0]===uniqueIdPrefix&&sensors.push(searchSensor)}});else{if("function"!=typeof sensor.get)return[];if("PHDL00"!==sensor.get("modelid")||!sensor.get("name").includes("Daylight"))return[];sensors=[sensor]}return sensors}function selectMode(mode){switch(mode){case"off":return translate("text_off");case"auto":return translate("th_auto");case"speed_1":case"speed_2":case"speed_3":case"speed_4":case"speed_5":return translate("th_manual")}}function calcLux(lightlevel){if(void 0===lightlevel)return;let value=Math.pow(10,lightlevel/1e4);return value<1?value=0:1==value&&(value-=1),value=Math.round(value)}async function checkGroupResourcelinks(){await restGetResource(app.resourcelinks).then(async()=>{let copy=[],light_resource_link=!1,blind_resource_link=!1,thermostat_resource_link=!1;Object(app.resourcelinks).forEach(l=>{9e3===l.attributes.classid&&(light_resource_link=l),9001===l.attributes.classid&&(blind_resource_link=l),9002===l.attributes.classid&&(thermostat_resource_link=l)}),!1===light_resource_link&&await restCreateResource(app.resourcelinks,{name:"LightGroup",description:"Displaying lights in groupview",classid:9e3,links:[]}),!1===blind_resource_link&&await restCreateResource(app.resourcelinks,{name:"BlindGroup",description:"Displaying blinds in groupview",classid:9001,links:[]}),!1===thermostat_resource_link&&await restCreateResource(app.resourcelinks,{name:"ThermostatGroup",description:"Displaying thermostats in groupview",classid:9002,links:[]}),await restGetResource(app.resourcelinks).then(async()=>{Object(app.resourcelinks).forEach(l=>{9e3===l.attributes.classid&&(light_resource_link=l),9001===l.attributes.classid&&(blind_resource_link=l),9002===l.attributes.classid&&(thermostat_resource_link=l)}),await restGetResource(app.groups).then(async()=>{copy=light_resource_link.attributes.links,Object(light_resource_link.attributes.links).forEach(l=>{let exists=!1,linkGroupId=l.split("/groups/")[1];Object(app.groups).forEach(g=>{g.id===linkGroupId&&(exists=!0)}),!1===exists&&copy.splice(light_resource_link.attributes.links.indexOf(l),1)}),await restUpdateResource(light_resource_link,{links:copy}),copy=blind_resource_link.attributes.links,Object(blind_resource_link.attributes.links).forEach(l=>{let exists=!1,linkGroupId=l.split("/groups/")[1];Object(app.groups).forEach(g=>{g.id===linkGroupId&&(exists=!0)}),!1===exists&&copy.splice(blind_resource_link.attributes.links.indexOf(l),1)}),await restUpdateResource(blind_resource_link,{links:copy}),copy=thermostat_resource_link.attributes.links,Object(thermostat_resource_link.attributes.links).forEach(l=>{let exists=!1,linkGroupId=l.split("/groups/")[1];Object(app.groups).forEach(g=>{g.id===linkGroupId&&(exists=!0)}),!1===exists&&copy.splice(thermostat_resource_link.attributes.links.indexOf(l),1)}),await restUpdateResource(thermostat_resource_link,{links:copy}),Object(app.groups).forEach(group=>{"20000"!==group.id&&0===group.get("devicemembership").length&&"Room"!==group.get("type")&&-1===light_resource_link.attributes.links.indexOf("/groups/"+group.id)&&-1===blind_resource_link.attributes.links.indexOf("/groups/"+group.id)&&-1===thermostat_resource_link.attributes.links.indexOf("/groups/"+group.id)&&light_resource_link.attributes.links.push("/groups/"+group.id)}),await restUpdateResource(light_resource_link,{links:light_resource_link.attributes.links})})})})}app.getSensorArrayInfo=getSensorArrayInfo,app.getSubSensors=getSubSensors;export function checkGrouptype(groupId){return new Promise((resolve,reject)=>{let group=app.groups.get(groupId);return void 0===group||null===group?resolve(null):void 0===app.resourcelinks||null===app.resourcelinks?resolve(null):void restGetResource(app.resourcelinks).then(()=>{let light_resource_link=!1,blind_resource_link=!1,thermostat_resource_link=!1;return Object(app.resourcelinks).forEach(l=>{9e3===l.attributes.classid&&(light_resource_link=l),9001===l.attributes.classid&&(blind_resource_link=l),9002===l.attributes.classid&&(thermostat_resource_link=l)}),light_resource_link&&-1!==light_resource_link.attributes.links.indexOf("/groups/"+groupId)?(app.session.groupType="lights",resolve("lights")):blind_resource_link&&-1!==blind_resource_link.attributes.links.indexOf("/groups/"+groupId)?(app.session.groupType="blinds",resolve("blinds")):thermostat_resource_link&&-1!==thermostat_resource_link.attributes.links.indexOf("/groups/"+groupId)?(app.session.groupType="thermostats",resolve("thermostats")):(app.session.groupType="noClass",resolve("noClass"))})})};