/*! phoscon-app 2025-10-13 */

import*as helperFunctions from"../group-time/helper-functions.js";export const SceneItemView=Backbone.View.extend({tagName:"li",className:"scene-item-view",template:_.template($("#scene-item-view-template").html()),initialize:function(){this.el.setAttribute("data-scid",this.model.id),this.render()},events:{"click #deviceHead":"callScene","click #deviceInfo":"openSceneEdit",'mousedown [data-btn-event="DASHBOARD_DEVICE_DELETE"]':"deleteScene"},openSceneEdit:function(event){if(!0===setGroupIdFromItemView(event))return;storeBackHash();let sceneId=this.model.id;location.assign("group-scenes.html?"+createURLSearchHash()+"#lights/"+app.session.gid+"/"+sceneId)},deleteScene:function(event){let scid=event.currentTarget.parentElement.parentElement.dataset.scid,gid=app.session.gid;gid&&scid&&restDeleteSceneDashboard(gid,scid,()=>{this.remove()})},callScene:function(event){event.stopPropagation(),event.preventDefault(),app.session.scid=event.currentTarget.parentElement.parentElement.dataset.scid,setGroupIdFromItemView(event),recallScene()},render:function(){return this.el.innerHTML=this.template(this.model),this}});export const ScheduleItemView=Backbone.View.extend({tagName:"li",className:"schedule-item-view",template:_.template($("#schedule-item-view-template").html()),initialize:function(){this.el.setAttribute("data-schid",this.model.id),this.el.innerHTML=this.template(this.model),this.timeText=this.el.querySelector("#scheduleTime"),this.daysText=this.el.querySelector("#scheduleDays"),this.timerTime=helperFunctions.localTimeToString(this.model.get("localtime")),this.listenTo(this.model,"change",this.render),this.render()},events:{"click #deviceHead":"toggleSchedule","click #deviceInfo":"openScheduleEdit"},openScheduleEdit:function(event){storeBackHash(),setGroupIdFromItemView(event);let scheduleId=this.model.id;location.assign("group-time2.html?"+createURLSearchHash()+"#schedules/"+scheduleId)},toggleSchedule:function(event){if(event.stopPropagation(),event.preventDefault(),app.session.schid=event.currentTarget.parentElement.parentElement.dataset.schid,"disabled"===this.model.get("status")){let dateTime=this.model.get("time");if(-1===this.model.get("time").indexOf("W")&&-1===this.model.get("time").indexOf("P")){let now=new Date;dateTime=`${`${now.getFullYear()}-${String(now.getMonth()+1).padStart(2,"0")}-${String(now.getDate()).padStart(2,"0")}`}T${this.model.get("time").split("T")[1]}`}restUpdateResource(this.model,{status:"enabled",time:dateTime}).then(()=>{document.querySelector('[data-schid="'+app.session.schid+'"]').classList.remove("disabled")})}else restUpdateResource(this.model,{status:"disabled"}).then(()=>{document.querySelector('[data-schid="'+app.session.schid+'"]').classList.add("disabled")})},render:function(){if(this.timerTime=helperFunctions.localTimeToString(this.model.get("localtime")),-1!==this.model.get("time").indexOf("PT")?this.el.querySelector("#deviceItemIcon use").setAttribute("xlink:href","#egg-timer-icon"):this.el.querySelector("#deviceItemIcon use").setAttribute("xlink:href","#schedule-icon"),this.model.get("localtime")){let days=helperFunctions.getScheduleDays(this.model.get("localtime"),!1),fadingtime=helperFunctions.getScheduleFadingTime(this.model.attributes),timeArray=this.model.get("localtime").split("T")[1].split(":"),alarmTime=new Date;alarmTime.setHours(timeArray[0],timeArray[1],timeArray[2]);var normalisedTime=alarmTime;"end"===this.model.attributes.activation&&(normalisedTime=new Date(alarmTime.getTime()+1e3*fadingtime));let promise=[helperFunctions.weekBitmapToText(days)];Promise.all(promise).then(daysText=>{this.daysText.innerText=daysText+" "+helperFunctions.toTimeString(normalisedTime.getHours(),normalisedTime.getMinutes())})}return"disabled"===this.model.get("status")?this.el.classList.add("disabled"):this.el.classList.remove("disabled"),this},updateTimerCountdown:function(time){this.timeText.innerHTML=time}});export const AutomationItemView=Backbone.View.extend({tagName:"li",className:"automation-item-view",template:_.template($("#automation-item-view-template").html()),initialize:function(){this.el.setAttribute("data-rlid",this.model.id),this.render()},events:{'click [data-btn-event="AUTOMATION_ITEM_CLICKED"]':"openAutomation"},openAutomation:function(event){storeBackHash(),setGroupIdFromItemView(event);let rl=this.model.get("id");location.assign("group-sensors-v2.html?"+createURLSearchHash()+"#pir/states/"+rl)},render:function(){return this.el.innerHTML=this.template(this.model),this}});export const SensorControlItemView=Backbone.View.extend({tagName:"li",className:"sensor-control-item-view",template:_.template($("#automation-item-view-template").html()),initialize:function(){this.el.setAttribute("data-rlid",this.model.id),this.render()},events:{'click [data-btn-event="AUTOMATION_ITEM_CLICKED"]':"openSensorControl"},openSensorControl:function(event){storeBackHash(),setGroupIdFromItemView(event);let rl=this.model.get("id");location.assign("group-sensors.html?"+createURLSearchHash()+"#pir/states/"+rl)},render:function(){return this.el.innerHTML=this.template(this.model),this}});export const SwitchEditItemView=Backbone.View.extend({tagName:"li",className:"switch-edit-item-view",template:_.template($("#switch-edit-item-view-template").html()),initialize:function(){this.el.setAttribute("data-rlid",this.model.id),this.render()},events:{'click [data-btn-event="SWITCH_EDIT_ITEM_CLICKED"]':"openSwitchEdit"},openSwitchEdit:function(event){storeBackHash(),setGroupIdFromItemView(event);let swId=this.model.get("links").find(l=>-1!==l.indexOf("sensors")).split("/")[2].split("-")[0];location.assign("group-switches2.html?"+createURLSearchHash()+"#overview/switch/"+swId)},render:function(){this.el.innerHTML=this.template(this.model),this.switchNameField=this.el.querySelector("#switchName");let swId=this.model.get("links").find(l=>-1!==l.indexOf("sensors")).split("/")[2];var switchName;return app.sensors.every(s=>swId!==s.get("uniqueid")||(switchName=s.get("name"),!1)),switchName&&(this.switchNameField.innerHTML=switchName),this}});export const OtherItemView=Backbone.View.extend({tagName:"li",className:"other-item-view",template:_.template($("#other-item-view-template").html()),initialize:function(roomElements){this.el.innerHTML=this.template(),this.othersText=this.el.querySelector("#others"),this.automationsLabel=this.el.querySelector("#automations"),this.sensorControlsLabel=this.el.querySelector("#sensorControls"),this.switchesLabel=this.el.querySelector("#switches"),this.automationsText=this.el.querySelector("#n1"),this.sensorControlsText=this.el.querySelector("#n2"),this.switchesText=this.el.querySelector("#n3"),this.render(roomElements)},events:{click:"goToGroupsPage"},render:function(roomElements){let isPhone=!(!screenMax(SCREEN_MAX_WIDTH_PHONE_LANDSCAPE)||!isThisPortrait());(0===roomElements.sensorControls||isPhone)&&(this.sensorControlsLabel.classList.add("hidden"),this.sensorControlsText.classList.add("hidden")),this.othersText.innerHTML=translate("link_other"),this.automationsLabel.innerHTML=roomElements.automations,this.sensorControlsLabel.innerHTML=roomElements.sensorControls,this.switchesLabel.innerHTML=roomElements.switches,this.automationsText.innerHTML=translate("text_automations"),this.sensorControlsText.innerHTML=translate("text_sensorControls"),this.switchesText.innerHTML=translate("link_switches")},goToGroupsPage:function(event){storeBackHash(),setGroupIdFromItemView(event),app.session.roomId=app.session.gid,document.querySelector("#group-wrapper").setAttribute("data-group-id",app.session.gid),app.session.groupType="lights",app.session.roomName=event.currentTarget.parentElement.parentElement.parentElement.querySelector("#roomName").innerHTML,app.router.navigate("groups",{trigger:!0}),setTimeout(()=>{let element=document.querySelector(".groups-and-devices-container");element.scrollTo({top:element.scrollHeight,behavior:"smooth"})},50)}});function storeBackHash(){sessionStorage.setItem("app.back.hash",document.location.hash),console.log("stored",sessionStorage.getItem("app.back.hash"))}function setGroupIdFromItemView(event){let element=event.currentTarget;for(;element&&"deviceValueSettingsList"!==element.id;)element=element.parentElement;if(element&&"deviceValueSettingsList"===element.id){let id=element.dataset.gid;return console.log("gId: "+id),app.session.gid=id,!0}for(element=event.currentTarget;element&&!element.className.includes("roomItemView");)element=element.parentElement;if(null===element)console.log("roomId: "+location.hash.split("/")[1]),app.session.gid=location.hash.split("/")[1];else{let id=element.dataset.roomid;void 0!==id&&null!==id||(id=element.dataset.groupId),console.log("roomId/gId: "+id),app.session.gid=id}}function restDeleteSceneDashboard(gid,scid,success){$.ajax({url:"//"+app.session.gw+"/api/"+app.apikey+"/groups/"+gid+"/scenes/"+scid,dataType:"json",type:"DELETE",cache:!1,contentType:"application/json; charset=utf-8",headers:{Accept:apiversion},success:function(json,status,xhr){console.log("success delete scene "+scid),success()},error:function(jqXHR,textStatus,errorThrown){console.log("error delete scene: "+scid)},timeout:1e4})}