/*! phoscon-app 2025-08-28 */

import{CLASSIDBLINDDOWN}from"./group-switches/constants";const SW_CLASSID_MIN=3001,SW_CLASSID_MAX=3028,CLASSIDON=3001,CLASSIDOFF=3002,CLASSIDTOGGLEONOFF=3003,CLASSIDNEXTSCENE=3004,CLASSIDPREVSCENE=3005,CLASSIDCALLSCENE=3006,CLASSIDBRIUP=3007,CLASSIDBRIDOWN=3008,CLASSIDPUSHDIM=3009,CLASSIDPUSHDIMUP=3010,CLASSIDPUSHDIMDOWN=3011,CLASSIDBRIDIMUP=3012,CLASSIDBRIDIMDOWN=3013,CLASSIDCOLORLOOPSTART=3014,CLASSIDCOLORLOOPSTOP=3015,CLASSIDCOLORLOOPTOGGLE=3016,CLASSIDCTUP=3017,CLASSIDCTDOWN=3018,CLASSIDDIMCT=3019,CLASSIDDIMCTUP=3020,CLASSIDDIMCTDOWN=3021,CLASSIDCALLEFFECT=3022,CLASSIDNEXTEFFECT=3023,CLASSIDALLOFF=3022,onOffClassIds=[CLASSIDON,CLASSIDOFF,CLASSIDTOGGLEONOFF,CLASSIDALLOFF],sceneClassIds=[CLASSIDCALLSCENE,CLASSIDNEXTSCENE,CLASSIDPREVSCENE],brightClassIds=[CLASSIDBRIUP,CLASSIDBRIDOWN,CLASSIDPUSHDIM,CLASSIDPUSHDIMUP,CLASSIDPUSHDIMDOWN,CLASSIDBRIDIMUP,CLASSIDBRIDIMDOWN],effectClassIds=[CLASSIDCOLORLOOPSTART,CLASSIDCOLORLOOPSTOP,CLASSIDCOLORLOOPTOGGLE,CLASSIDCALLEFFECT,CLASSIDNEXTEFFECT],temperatureClassIds=[CLASSIDCTUP,CLASSIDCTDOWN,CLASSIDDIMCT,CLASSIDDIMCTUP,CLASSIDDIMCTDOWN];function createOn(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const r={name:"Rule ON",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!0},method:"PUT"}]},rs={classid:CLASSIDON,description:"Resourcelink for switch rule",name:"opt_on",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createOff(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const r={name:"Rule OFF",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!1},method:"PUT"}]},rs={classid:CLASSIDOFF,description:"Resourcelink for switch rule",name:"opt_off",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createAllOff(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const r={name:"Rule ALL_OFF",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/1/action",body:{on:!1},method:"PUT"}]},rs={classid:CLASSIDALLOFF,description:"Resourcelink for switch rule",name:"opt_allOff",links:["/groups/1","/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createToggleOnOff(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const rs={classid:CLASSIDTOGGLEONOFF,description:"Resourcelink for switch rule",name:"opt_toggleOnOff",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);const r1={name:"Rule TOOGLE_ON",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:!1}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!0},method:"PUT"}]},r2={name:"Rule TOOGLE_OFF",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:!0}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!1},method:"PUT"}]};restCreateResource(app.rules,r1).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.rules,r2)).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createNextScene(statekey,values,sensorId,extraFunctions){if(!statekey||!values||!sensorId)return Promise.reject(new Error("parameter is missing"));if(!app.session.gid)return Promise.reject(new Error("app.session.gid is missing"));if(!app.rules)return Promise.reject(new Error("app.rules is missing"));const r={name:"Rule CALL_NEXT_SCENE",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/scenes/next/recall",body:{},method:"PUT"}]},rs={classid:CLASSIDNEXTSCENE,description:"Resourcelink for switch rule",name:"opt_callNextScene",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});return sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),extraFunctions.forEach(id=>rs.links.push("/resourcelinks/"+id)),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs))}function createPrevScene(statekey,values,sensorId,extraFunctions){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const r={name:"Rule CALL_PREV_SCENE",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/scenes/prev/recall",body:{},method:"PUT"}]},rs={classid:CLASSIDPREVSCENE,description:"Resourcelink for switch rule",name:"opt_callPrevScene",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),extraFunctions.forEach(e=>rs.links.push("/resourcelinks/"+e)),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createCallScene(statekey,values,sensorId,extraFunctions){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const r={name:"Rule CALL_SCENE",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/scenes/"+app.session.sid+"/recall",body:{},method:"PUT"}]},rs={classid:CLASSIDCALLSCENE,description:"Resourcelink for switch rule",name:"opt_callSelectedScene",links:["/groups/"+app.session.gid,"/sensors/"+sensorId,"/scenes/"+app.session.sid]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),extraFunctions.forEach(e=>rs.links.push("/resourcelinks/"+e)),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createBriUp(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const briLevel=app.selBri||5,briPercent=Math.round(2.54*briLevel),r={name:"Rule BRI_UP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:briPercent,transitiontime:9},method:"PUT"}]},rs={classid:CLASSIDBRIUP,description:"Resourcelink for switch rule",name:"opt_dimUp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createBriDown(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const briLevel=app.selBri||5,briPercent=Math.round(2.54*briLevel),r={name:"Rule BRI_DOWN",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:-briPercent,transitiontime:9},method:"PUT"}]},rs={classid:CLASSIDBRIDOWN,description:"Resourcelink for switch rule",name:"opt_dimDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createPushDim(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));const rs={classid:CLASSIDPUSHDIM,description:"Resourcelink for switch rule",name:"opt_pushDim",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);const gs2={manufacturername:"Phoscon",modelid:"PHOSCON_FSM_FLAG",name:"CLIP-Sensor PUSHDIM-TOOGLE",state:{flag:!0},swversion:"1.0",type:"CLIPGenericFlag",uniqueid:sensorId+"-pushdim-toogle-"+app.session.gid+"-"+new Date};var rulePush=[],genericSensorPush=[];let r1={name:"Rule PUSHDIM_ON",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:!1}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!0},method:"PUT"}]},r2={name:"Rule PUSHDIM_OFF",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:!0}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!1},method:"PUT"}]},promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let gsPromise2=restCreateResource(app.sensors,gs2).then(id=>{let gsnid=id;if(rs.links.push("/sensors/"+id),!gsnid)return void reject(new Error("gsnid is missing"));let r1={name:"Rule PUSHDIM_START_UP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+statekey,operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!0}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:254,transitiontime:45},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!1},method:"PUT"}]},r2={name:"Rule PUSHDIM_START_DOWN",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+statekey,operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!1}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:-254,transitiontime:45},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!0},method:"PUT"}]},r3={name:"Rule PUSHDIM_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[2]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:0},method:"PUT"}]},promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),genericSensorPush.push(gsPromise2),Promise.all(rulePush,genericSensorPush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})}).catch(()=>reject(new Error("Genericsensor is not created")))})}function createPushDimUp(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDPUSHDIMUP,description:"Resourcelink for switch rule",name:"opt_pushDimUp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r1={name:"Rule PUSHDIMUP_ON",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!0},method:"PUT"}]},r2={name:"Rule PUSHDIMUP_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:254,transitiontime:30},method:"PUT"}]},r3={name:"Rule PUSHDIMUP_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[2]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:0},method:"PUT"}]};var rulePush=[];let promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),Promise.all(rulePush).then(()=>resolve(restCreateResource(app.resourcelinks,rs))).catch(reject)})}function createPushDimDown(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDPUSHDIMDOWN,description:"Resourcelink for switch rule",name:"opt_pushDimDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r1={name:"Rule PUSHDIMDOWN_OFF",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{on:!1},method:"PUT"}]},r2={name:"Rule PUSHDIMDOWN_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:-254,transitiontime:30},method:"PUT"}]},r3={name:"Rule PUSHDIMDOWN_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[2]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:0},method:"PUT"}]};var rulePush=[];let promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createBriDimUp(statekey,values,sensorId,bool){if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return Promise.reject(new Error("app.session.gid is missing"));if(!app.rules)return Promise.reject(new Error("app.rules is missing"));let rs={classid:CLASSIDBRIDIMUP,description:"Resourcelink for switch rule",name:bool?"opt_briDimUp_1":"opt_briDimUp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r2={name:"Rule BRIDIMUP_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:254,transitiontime:30},method:"PUT"}]},r3={name:"Rule BRIDIMUP_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:0},method:"PUT"}]};return restCreateResource(app.rules,r2).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.rules,r3)).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs))}function createBriDimDown(statekey,values,sensorId,bool){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDBRIDIMDOWN,description:"Resourcelink for switch rule",name:bool?"opt_briDimDown_1":"opt_briDimDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r2={name:"Rule BRIDIMDOWN_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:-254,transitiontime:30},method:"PUT"}]},r3={name:"Rule BRIDIMDOWN_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{bri_inc:0},method:"PUT"}]};resolve(restCreateResource(app.rules,r2).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.rules,r3)).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)))})}function createColorLoopStart(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let loopspeed=app.selColorSpeed||"15",satPercent=2.54*(app.selColorSat||"100"),r={name:"Rule COLORLOOP_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{sat:satPercent,effect:"colorloop",colorloopspeed:loopspeed},method:"PUT"}]},rs={classid:CLASSIDCOLORLOOPSTART,description:"Resourcelink for switch rule",name:"opt_startColorLoop",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);var rulePush=[];let promise=restCreateResource(app.rules,r).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createColorLoopStop(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let r={name:"Rule COLORLOOP_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{effect:"none"},method:"PUT"}]},rs={classid:CLASSIDCOLORLOOPSTOP,description:"Resourcelink for switch rule",name:"opt_stopColorLoop",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);var rulePush=[];let promise=restCreateResource(app.rules,r).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createColorLoopToggle(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let gs={manufacturername:"Phoscon",modelid:"PHOSCON_FSM_FLAG",name:"CLIP-Sensor TOOGLE-COLORLOOP",state:{flag:!0},swversion:"1.0",type:"CLIPGenericFlag",uniqueid:sensorId+"-toogle-colorloop-"+app.session.gid+"-"+(new Date).getTime()},rs={classid:CLASSIDCOLORLOOPTOGGLE,description:"Resourcelink for switch rule",name:"opt_toggleColorLoop",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let loopspeed=app.selColorSpeed||"15",satPercent=2.54*(app.selColorSat||"100");var rulePush=[];restCreateResource(app.sensors,gs).then(id=>{let gsnid=id;if(rs.links.push("/sensors/"+id),!gsnid)return void reject(new Error("gsnid is missing"));let r1={name:"Rule TOOGLE_START_COLORLOOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!0}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{sat:satPercent,effect:"colorloop",colorloopspeed:loopspeed},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!1},method:"PUT"}]},r2={name:"Rule TOOGLE_STOP_COLORLOOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!1}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{effect:"none"},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!0},method:"PUT"}]},promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})}).catch(err=>{reject(new Error("Genericsensor is not created"))})})}function createCtUp(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let ctPercent=3.47*(app.selCt||5),r={name:"Rule CT_UP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:ctPercent,transitiontime:9},method:"PUT"}]},rs={classid:CLASSIDCTUP,description:"Resourcelink for switch rule",name:"opt_ctUp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);var rulePush=[];let promise=restCreateResource(app.rules,r).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createCtDown(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let ctPercent=3.47*(app.selCt||5),r={name:"Rule CT_DOWN",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:-ctPercent,transitiontime:9},method:"PUT"}]},rs={classid:CLASSIDCTDOWN,description:"Resourcelink for switch rule",name:"opt_ctDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);var rulePush=[];let promise=restCreateResource(app.rules,r).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createDimCtUp(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDDIMCTUP,description:"Resourcelink for switch rule",name:"opt_dimTempUp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r2={name:"Rule DIMCTUP_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:500,transitiontime:60},method:"PUT"}]},r3={name:"Rule DIMCTUP_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:0},method:"PUT"}]};var rulePush=[];let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createDimCtDown(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDDIMCTDOWN,description:"Resourcelink for switch rule",name:"opt_dimTempDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r2={name:"Rule DIMCTDOWN_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:-500,transitiontime:60},method:"PUT"}]},r3={name:"Rule DIMCTDOWN_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:0},method:"PUT"}]};var rulePush=[];let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createCtDim(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDDIMCT,description:"Resourcelink for switch rule",name:"opt_dimTemp",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let gs={manufacturername:"Phoscon",modelid:"PHOSCON_FSM_FLAG",name:"CLIP-Sensor CTDIM-TOOGLE",state:{flag:!0},swversion:"1.0",type:"CLIPGenericFlag",uniqueid:sensorId+"-ct-dim-toogle-"+app.session.gid+"-"+(new Date).getTime()};var rulePush=[],genericSensorPush=[];let gsPromise2=restCreateResource(app.sensors,gs).then(id=>{let gsnid=id;if(rs.links.push("/sensors/"+id),!gsnid)return void reject(new Error("gsnid is missing"));let r1={name:"Rule CTDIM_START_UP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!0}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:400,transitiontime:60},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!1},method:"PUT"}]},r2={name:"Rule CTDIM_START_DOWN",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/sensors/"+gsnid+"/state/flag",operator:"eq",value:!1}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:-400,transitiontime:60},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{flag:!0},method:"PUT"}]},r3={name:"Rule CTDIM_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:0},method:"PUT"}]},promise1=restCreateResource(app.rules,r1).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise1);let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),genericSensorPush.push(gsPromise2),Promise.all(rulePush,genericSensorPush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})}).catch(()=>reject(new Error("Genericsensor is not created")))})}function createBlindDown(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDBLINDDOWN,description:"Resourcelink for switch rule",name:"blindDown",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let r2={name:"Rule BLINDDOWN_START",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{lift:50},method:"PUT"}]},r3={name:"Rule BLINDDOWN_STOP",conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[1]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/groups/"+app.session.gid+"/action",body:{ct_inc:0},method:"PUT"}]};var rulePush=[];let promise2=restCreateResource(app.rules,r2).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise2);let promise3=restCreateResource(app.rules,r3).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise3),Promise.all(rulePush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})})}function createCallEffect(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.lightEffect)return reject(new Error("app.lightEffect is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));const r={name:"Rule LIGHTCHAIN_"+app.lightEffect,conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"}],actions:[{address:"/lights/"+app.lightChainId+"/state",body:{effect:app.lightEffect},method:"PUT"}]},rs={classid:CLASSIDCALLEFFECT,description:"Resourcelink for switch rule",name:"opt_callSelectedEffect",links:["/groups/"+app.session.gid,"/sensors/"+sensorId,"/effect/"+app.lightEffect]};let sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode),restCreateResource(app.rules,r).then(id=>rs.links.push("/rules/"+id)).then(()=>restCreateResource(app.resourcelinks,rs)).then(resolve).catch(reject)})}function createNextEffect(statekey,values,sensorId){return new Promise((resolve,reject)=>{if(!statekey||!values||!sensorId)return reject(new Error("parameter is missing"));if(!app.session.gid)return reject(new Error("app.session.gid is missing"));if(!app.groups)return reject(new Error("app.groups is missing"));if(!app.rules)return reject(new Error("app.rules is missing"));if(!app.groups.get(app.session.gid).get("name"))return reject(new Error("groupname of app.session.gid is missing"));let rs={classid:CLASSIDNEXTEFFECT,description:"Resourcelink for switch rule",name:"opt_callNextEffect",links:["/groups/"+app.session.gid,"/sensors/"+sensorId]},sensor=app.sensors.findWhere({uniqueid:sensorId});sensor&&sensor.get("config").devicemode&&rs.links.push("/devicemode/"+sensor.get("config").devicemode);let gs={manufacturername:"Phoscon",modelid:"PHOSCON_FSM_STATE",name:"CLIP-Sensor NEXTEFFECT",state:{status:1},swversion:"1.0",type:"CLIPGenericStatus",uniqueid:sensorId+"-next-effect-"+app.session.gid+"-"+(new Date).getTime()};var rulePush=[],genericSensorPush=[];let gsPromise=restCreateResource(app.sensors,gs).then(id=>{let gsnid=id;if(rs.links.push("/sensors/"+id),gsnid){var effects=["glow","snow","rainbow","snake","twinkle","fireworks","flag","waves","updown","vintage","fading","collide","strobe","sparkles","carnival","steady"];effects.forEach((effect,idx)=>{let thisEffect=idx+1,nextEffect=thisEffect==effects.length?1:thisEffect+1;var r={name:"Rule LIGHTCHAIN_NEXTEFFECT_"+thisEffect,conditions:[{address:"/sensors/"+sensorId+statekey,operator:"eq",value:values[0]},{address:"/sensors/"+sensorId+"/state/lastupdated",operator:"dx"},{address:"/sensors/"+gsnid+"/state/status",operator:"eq",value:thisEffect}],actions:[{address:"/lights/"+app.lightChainId+"/state",body:{effect:effect},method:"PUT"},{address:"/sensors/"+gsnid+"/state/",body:{status:nextEffect},method:"PUT"}]},promise=restCreateResource(app.rules,r).then(id=>{rs.links.push("/rules/"+id)});rulePush.push(promise)}),genericSensorPush.push(gsPromise),Promise.all(rulePush,genericSensorPush).then(()=>{restCreateResource(app.resourcelinks,rs).then(id=>{resolve(id)})})}else reject(new Error("gsnid is missing"))}).catch(()=>reject(new Error("Genericsensor is not created")))})}function deleteResources(resources){return Array.isArray(resources)?Promise.all(resources.map(r=>{let name=r.get("name");return restDeleteResource(r).then(id=>console.log("%c Resource ("+id+") deleted: "+name,DELETE))})):Promise.reject(new TypeError(`invalid argument for 'resources': expected an array got ${resources}`))}