/*! phoscon-app 2025-08-28 */

import{handleOutsideClick}from"../dashboard/dashboard-functions.js";import{SceneItemView}from"../groups-page/control-views.js";export const getDeviceValueSelectView=(constants,service)=>{return new(Backbone.View.extend({el:"#deviceValueSettingsList",initialize:function(){this.device=null,this.outer=document.querySelector("#deviceValueSettingsOuter"),this.outer.addEventListener("click",handleOutsideClick),document.getElementById("closeDeviceSettings").addEventListener("click",this.eventClose.bind(this))},events:{'click [data-btn-event="DEVICE_VALUE"]':"eventSelectDeviceValue",'click [data-btn-event="EDIT_DEVICE_NAME"]':"eventEditSensorName",'click [data-btn-event="SAVE_DEVICE_NAME"]':"eventSaveSensorName","blur .deviceNameInput":"eventSaveSensorName"},render:function(){if(!this.nameInput||this.nameInput.classList.contains("hidden"))return this.$el.empty(),this.device&&(this.renderSensorInfo(),this.renderSensorValues(),"LightGroup"===this.device.get("type")&&(this.el.dataset.gid=this.device.get("id"),this.renderGroupInfo())),this.nameInput=this.el.querySelector(".nameInput"),this.deviceNameText=this.el.querySelector(".deviceNameText"),this.saveButton=this.el.querySelector(".saveButton"),this},renderSensorInfo:function(){const name=this.device.attributes.name||"";this.el.innerHTML+=`\n                <li class="deviceValueSettingsItem">\n                    <div class="deviceValueWrapper">                        \n                        <div class="deviceValueLabel">${translate("text_name")}</div>\n                        <div class="deviceNameWrapper">\n                            <span class="deviceNameText">${name}</span>\n                            <input class="nameInput hidden" value="${name}" />\n                            <button data-btn-event="SAVE_DEVICE_NAME" class="hidden saveButton">${translate("text_save")}</button>\n                        </div>\n                        <div class="nameContainer">\n                            <svg width="24" height="24" aria-hidden="true" data-btn-event="EDIT_DEVICE_NAME">\n                                <use transform="scale(0.5)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#rename-icon"></use>\n                            </svg>\n                        </div>\n                    </div>\n                </li>`},renderGroupInfo:function(){let groupLights=this.device.get("lights")||[],groupLightsNames=[],sceneItemList=document.createElement("ul");groupLights.forEach(lid=>{let l=app.lights.get(lid);l&&"FLS-PP3 White"!==l.get("modelid")&&groupLightsNames.push(l.get("name"))}),0===groupLightsNames.length&&(groupLightsNames=translate("fade_no"));let groupScenes=this.device.get("scenes")||[];groupScenes.forEach(scene=>{let view=new SceneItemView({model:scene});sceneItemList.appendChild(view.el)}),this.el.innerHTML+=`                       \n                <li class="deviceValueSettingsItem">\n                    <div class="deviceValueWrapper"> \n                        <div class="deviceValueLabel">${translate("text_lights")}</div>\n                        <div class="deviceValue">${groupLightsNames}</div>\n                    </div>\n                </li>\n                <li class="deviceValueSettingsItem">\n                    <div class="deviceValueWrapper">                        \n                        <div class="deviceValueLabel">${translate("text_scenes")}</div>\n                        <div class="deviceValue">${0===groupScenes.length?translate("fade_no"):""}</div>\n                    </div>\n                </li>\n                <li class="deviceValueSettingsItem">\n                    <div class="deviceValueWrapper">\n                        <div class="deviceValue" id="groupSceneItemList"></div>\n                    </div>\n                </li>`,this.el.querySelector("#groupSceneItemList").appendChild(sceneItemList)},renderSensorValues:function(){const deviceValues=app.getSensorArrayInfo(this.device);this.el.innerHTML+=`\n                <li class="deviceValueSettingsItem">\n                    <div class="deviceValueWrapper">                        \n                        <div class="deviceValueLabel">${translate("text_id")}</div>\n                        <div class="deviceValue">${this.device.get("id")}</div>\n                    </div>\n                </li>`,deviceValues.forEach(info=>{let clickableClass=["macid","manufacture","product","battery","updated"].includes(info.type)?"":"clickable",mac=this.device.get("uniqueid")?this.device.get("uniqueid").split("-")[0]:this.device.get("mac"),chosenValue=JSON.parse(localStorage.getItem(mac)),chosenClass="";chosenValue&&info.type===chosenValue.showValue&&(chosenClass="chosen");let valueDisplay=`${info.value} ${info.unit||""}`.trim();("updated"!==info.type&&"lastupdated"!==info.type&&"lastseen"!==info.type||info.value&&"none"!==info.value)&&void 0!==info.value&&null!==info.value&&""!==valueDisplay&&(this.el.innerHTML+=`\n                    <li class="deviceValueSettingsItem ${clickableClass} ${chosenClass}" data-btn-event="DEVICE_VALUE" data-device-type="${info.type}">\n                        <div class="deviceValueWrapper">\n                            <div class="deviceValueLabel">${info.label}</div>\n                            <div class="deviceValue">${valueDisplay}</div>\n                        </div>\n                    </li>`)})},showDeviceValues:function(device){this.device=device,document.getElementById("deviceValueSettings").classList.remove("hidden"),this.positionDeviceSettings(),this.listenTo(this.device,"change",this.render),this.render()},positionDeviceSettings:function(){const settings=document.getElementById("deviceValueSettings");settings.style.left="50%",settings.style.top="50%",settings.style.transform="translate(-50%, -50%)"},eventClose:function(){this.toggleSensorNameEdit(!1),document.getElementById("deviceValueSettings").classList.add("hidden"),this.device=null,document.querySelector("#deviceValueSettingsOuter").classList.add("hidden"),this.render()},eventSelectDeviceValue:function(event){const type=event.currentTarget.dataset.deviceType;if(type){const mac=this.device.get("uniqueid")?this.device.get("uniqueid").split("-")[0]:this.device.get("mac"),itemConfig=JSON.parse(localStorage.getItem(mac))||{displayValues:[]};itemConfig.showValue=type,localStorage.setItem(mac,JSON.stringify(itemConfig)),app.roomViews.views.some(roomView=>roomView.roomDeviceItemViews.some(itemView=>{if(itemView.name&&itemView.name===this.deviceNameText.textContent)return itemView._handleShowValue(),itemView.render(),!0})),app.groupPageViews.deviceListView.views.some(itemView=>{if(itemView.name&&itemView.name===this.deviceNameText.textContent)return itemView._handleShowValue(),itemView.render(),!0}),this.render()}},eventEditSensorName:function(){document.getElementById("deviceValueSettings").classList.contains("hidden")||this.toggleSensorNameEdit(!0)},eventSaveSensorName:function(e){e.stopPropagation();const name=this.$el.find(".nameInput").val().trim(),Id=this.device.attributes.id,type=this.device.attributes.type;"Daylight"===type?app.sensors.get(Id).save({name:name},{patch:!0}):type.includes("light")||type.includes("plug")||type.includes("Window")?app.lights.get(Id).save({name:name},{patch:!0}):type.includes("LightGroup")?app.groups.get(Id).save({name:name},{patch:!0}):app.sensors.get(Id).save({name:name},{patch:!0}),this.renderNewName()},toggleSensorNameEdit:function(isEditing){const editSvgIcon=this.$el.find(".nameContainer"),nameRow=this.$el.find("li:first-child"),sensorNameText=this.$el.find(".deviceNameText"),sensorNameInput=this.$el.find(".nameInput"),saveButton=this.$el.find(".saveButton");nameRow.toggleClass("no-hover",isEditing),editSvgIcon[0].classList.add("hide"),sensorNameText.toggleClass("hidden",isEditing),sensorNameInput.toggleClass("hidden",!isEditing).focus(),saveButton.toggleClass("hidden",!isEditing)},renderNewName:function(){let newName=this.nameInput.value;const nameRow=this.$el.find("li:first-child")[0],editSvgIcon=this.$el.find(".nameContainer");this.nameInput.classList.add("hidden"),this.deviceNameText.textContent=newName,this.deviceNameText.classList.remove("hidden"),this.saveButton.classList.add("hidden"),editSvgIcon[0].classList.remove("hide"),nameRow.classList.remove("no-hover")}}))};