/*! phoscon-app 2025-08-28 */

function updateVersion1ToVersion2(model){if(1!==model.get("version"))return;let data=model.attributes;data.states.forEach((st,index)=>{if(-1===["dimm1","dimm2","end"].indexOf(st.name))return;if(!st.presence)return;let c=st.presence.find(x=>"ddx"===x.operator);c&&(st.state.push(c),delete st.presence)}),data.version=2}function updateVersion2ToVersion3(model){if(gatewayVersion()<20530)return;if(2!==model.get("version"))return;let data=model.attributes;data.states.forEach((st,index)=>{-1!==["dimm1","dimm2","end","wait"].indexOf(st.name)&&st.state&&st.state.filter(c=>"ddx"===c.operator).forEach(c=>c.operator="stable")}),data.version=3}function togglePirResourcelink(rl,model){var links=rl.get("links"),pir="/sensors/"+model.id;return-1!==links.indexOf(pir)?links=links.filter(x=>x!==pir):links.push(pir),restUpdateResource(rl,{links:links}).then(result=>{app.savePirControl()})}function toggleSwitchResourcelink(rl,model){let links=rl.get("links"),endpoints=model.get("endpoints"),promises=[];return Object.keys(endpoints).forEach(x=>{let sid=endpoints[x].id,r="/sensors/"+sid;if(-1!==links.indexOf(r))links=links.filter(x=>x!==r);else{links.push(r);let up=app.pirStateListView.userparameter,switches=up.get("switches")||[];switches.find(x=>x.sid===sid)||(switches.push({sid:sid,mode:"master"}),up.set({switches:switches}),updateVersion1ToVersion2(up),promises.push(restSaveResource(up)))}}),promises.push(restUpdateResource(rl,{links:links})),Promise.all(promises).then(result=>{app.savePirControl()})}function toggleSwitchMode(rl,up,model){rl.get("links");let endpoints=model.get("endpoint"),promises=[],switches=up.get("switches")||[];return Object.keys(endpoints).forEach(x=>{let sid=endpoints[x].id,cfg=switches.find(x=>x.sid===sid);cfg?"master"===cfg.mode?cfg.mode="pir":"pir"===cfg.mode?cfg.mode="master":console.log("unknown mode",cfg.mode):switches.push({sid:sid,mode:"master"})}),up.set({switches:switches}),updateVersion1ToVersion2(up),promises.push(restSaveResource(up)),Promise.all(promises).then(result=>{app.savePirControl()})}function deletePirControl(rl){var links=[];rl.get("links").forEach(l=>{if(0===l.indexOf("/sensors")){let sid=l.split("/").pop(),s=app.sensors.get(sid);if(!s)return;let type=s.get("type");if("CLIPGenericStatus"===type);else if("CLIPPresence"!==type)return;links.push(restDeleteResource(s))}else if(0===l.indexOf("/rules")){let rid=l.split("/").pop(),r=app.rules.get(rid);r&&links.push(restDeleteResource(r))}else{if(0!==l.indexOf("/userparameter"))return;{let uid=l.split("/").pop(),u=app.userparameter.get(uid);u&&links.push(restDeleteResource(u))}}}),Promise.all(links).then(result=>restDeleteResource(rl)).then(result=>{console.log("all deleted")})}function createPirControl(name){restCreateResource(app.userparameter,defaultPirStateMachine).then(id=>{var resourceLink={name:name,classid:2020,links:["/userparameter/"+id,"/groups/"+app.session.gid]};return restCreateResource(app.resourcelinks,resourceLink)}).then(id=>{console.info("created pir control resourcelink",id),setActiveSensorControl(app.resourcelinks.get(id)),app.savePirControl()}).catch(err=>{console.error("failed to create pir control")})}function createStateMachineRules(rl,u){var status=null,vpir=null,pirs=[],switches=[],rvpir=null,rstatus=null,rulesToUpdate=[],rulesToPush=[],pirPresence=0;let sensorState,vstatusAfterUpdate=0,group=app.groups.get(app.session.gid);app.activatedSensor&&("open"in app.activatedSensor.get("state")&&(sensorState="open"),"vibration"in app.activatedSensor.get("state")&&(sensorState="vibration"),"water"in app.activatedSensor.get("state")&&(sensorState="water"),"presence"in app.activatedSensor.get("state")&&(sensorState="presence"));var links=[],daylightSid=app.sensors.find(x=>"Daylight"===x.get("type"));daylightSid=daylightSid?daylightSid.get("id"):null,rl.get("links").forEach(l=>{if(0===l.indexOf("/sensors")){let sid=l.split("/").pop(),s=app.sensors.get(sid);if(!s)return;let type=s.get("type");"CLIPGenericStatus"===type?rstatus=s:"CLIPPresence"===type?rvpir=s:"ZHAPresence"===type||"ZLLPresence"===type||"ZHAVibration"===type||"ZHAOpenClose"===type||"ZHAWater"===type?(pirs.push(l),links.push(l)):"ZHASwitch"!==type&&"ZLLSwitch"!==type&&"ZGPSwitch"!==type||(switches.push(l),links.push(l))}else if(0===l.indexOf("/rules")){let rid=l.split("/").pop(),r=app.rules.get(rid);r&&-1===rulesToUpdate.indexOf(r)&&rulesToUpdate.push(r)}else-1===links.indexOf(l)&&links.push(l)});let vpirData={type:"CLIPPresence",modelid:"PHOSCON_VPIR",manufacturername:"Phoscon",name:"VPIR "+rl.get("name"),swversion:"1.0",uniqueid:"vpir-"+(new Date).getTime(),config:{duration:60}},vstatusData={type:"CLIPGenericStatus",modelid:"PHOSCON_FSM_STATE",manufacturername:"Phoscon",name:"FSM_STATE "+rl.get("name"),swversion:"1.0",uniqueid:"fsm-state-"+(new Date).getTime(),state:{status:0}};Promise.all([restGetResource(rvpir).catch(err=>restCreateResource(app.sensors,vpirData)).then(id=>{vpir="/sensors/"+id,rvpir=app.sensors.get(id)}),restGetResource(rstatus).catch(err=>restCreateResource(app.sensors,vstatusData)).then(id=>{status="/sensors/"+id,rstatus=app.sensors.get(id)}),restGetResource(group)]).then(result=>(links.push(vpir),links.push(status),restUpdateResource(rl,{links:links}))).then(result=>{console.log("vpir: "+vpir),console.log("vstatus: "+status);let fsm=u.attributes,hh=0,mm=0,ss=0,maxDuration=60,startActions=null;if(fsm.states.forEach((st,stNum)=>{var r={name:fsm.type+"-state-"+st.name,conditions:[],actions:[]};let ddx=null,time=null;st.state.forEach(c=>{let val=c.value;if(("ddx"===c.operator||"stable"===c.operator)&&-1!==["dimm1","dimm2","end"].indexOf(st.name)){ddx=c.value.slice(2),time=ddx.split(":").map(x=>parseInt(x)),"dimm1"===st.name&&(time[2]+=2);let t1=Date.UTC(2017,1,1,time[0],time[1],time[2]),tx=new Date(t1-(18e5*hh+6e4*mm+1e3*ss));hh+=tx.getUTCHours(),mm+=tx.getUTCMinutes(),ss+=tx.getUTCSeconds(),val="PT"+tx.getUTCHours().toString().padStart(2,"0")+":"+tx.getUTCMinutes().toString().padStart(2,"0")+":"+tx.getUTCSeconds().toString().padStart(2,"0")}"stable"===c.operator&&(localTimeDx=!0,r.conditions.push({address:"/config/localtime",operator:"dx"})),"start"===st.name?"daylight"===fsm.activate?r.conditions.push({address:"/sensors/"+daylightSid+"/state/daylight",operator:"eq",value:"true"}):"no_daylight"===fsm.activate&&r.conditions.push({address:"/sensors/"+daylightSid+"/state/daylight",operator:"eq",value:"false"}):"wait"===st.name&&"any_on"===fsm.activate&&"stable"===c.operator&&(val="PT00:00:30"),r.conditions.push({address:status+"/state/status",operator:c.operator,value:val})});let next="next"in st?st.next:stNum+1;if("wait"===st.name&&"any_on"===fsm.activate&&(next=-2),console.log(st.name+": "+stNum+" -> "+next),r.actions.push({address:status+"/state",method:"PUT",body:{status:next}}),"dimm1"===st.name){if(!time||3!==time.length)throw time;maxDuration=1800*time[0]+60*time[1]+time[2];let rr={name:fsm.type+"-vpir-reset",conditions:[],actions:[]};rr.conditions.push({address:status+"/state/status",operator:"eq",value:"1"}),rr.conditions.push({address:vpir+"/state/presence",operator:"eq",value:"true"}),rr.conditions.push({address:vpir+"/state/lastupdated",operator:"ddx",value:"PT"+ddx}),rr.actions.push({address:vpir+"/state",method:"PUT",body:{presence:!1}});let rrule=rulesToUpdate.shift(),promise=restUpdateResource(rrule,rr).catch(err=>restCreateResource(app.rules,rr)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise),st.presence||(st.presence=[{operator:"eq",value:"false"}])}if(st.presence&&(1===next&&r.conditions.push({address:vpir+"/state/lastupdated",operator:"dx"}),st.presence.forEach(c=>{let o={address:vpir+"/state/presence"};for(let key in c)o[key]=c[key];r.conditions.push(o)})),st.group){let body=JSON.parse(JSON.stringify(st.group));body.bri&&(body.bri=Math.round(body.bri/100*254)),body.on&&body.bri&&r.actions.push({address:"/groups/"+app.session.gid+"/action",method:"PUT",body:{on:!0}}),Object.keys(body).length>0&&r.actions.push({address:"/groups/"+app.session.gid+"/action",method:"PUT",body:body}),"start"===st.name&&(startActions=JSON.parse(JSON.stringify(r.actions)))}var rule=rulesToUpdate.shift(),promise=restUpdateResource(rule,r).catch(err=>restCreateResource(app.rules,r)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise)}),app.session.gid){let r={name:fsm.type+"-reset-after-off",conditions:[{address:"/groups/"+app.session.gid+"/state/any_on",operator:"ddx",value:"PT00:00:04"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:"false"},{address:status+"/state/status",operator:"stable",value:"PT00:00:05"},{address:status+"/state/status",operator:"gt",value:"0"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!1}},{address:status+"/state",method:"PUT",body:{status:-1}}]},rule=rulesToUpdate.shift(),promise=restUpdateResource(rule,r).catch(err=>restCreateResource(app.rules,r)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise);let r1={name:fsm.type+"-block-motion-events",conditions:[{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:"false"},{address:status+"/state/status",operator:"eq",value:"-3"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!1}},{address:status+"/state",method:"PUT",body:{status:-2}}]},rule1=rulesToUpdate.shift(),promise1=restUpdateResource(rule1,r1).catch(err=>restCreateResource(app.rules,r1)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise1);let r2={name:fsm.type+"-reset-after-off-master",conditions:[{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:"true"},{address:status+"/state/status",operator:"eq",value:"-3"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!1}},{address:status+"/state",method:"PUT",body:{status:-1}}]},rule2=rulesToUpdate.shift(),promise2=restUpdateResource(rule2,r2).catch(err=>restCreateResource(app.rules,r2)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise2)}if("any_on"===fsm.activate){vstatusAfterUpdate=-2;let r2={name:fsm.type+"-state-leave-any_on",conditions:[{address:"/config/localtime",operator:"dx"},{address:"/groups/"+app.session.gid+"/state/any_on",operator:"eq",value:"true"},{address:status+"/state/status",operator:"eq",value:"-2"}],actions:startActions||[{address:status+"/state",method:"PUT",body:{status:1}}]},rule2=rulesToUpdate.shift(),promise2=restUpdateResource(rule2,r2).catch(err=>restCreateResource(app.rules,r2)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise2)}return pirs.forEach((pir,i)=>{let sensorState,sid=pir.slice(pir.lastIndexOf("/")+1),s=app.sensors.get(sid);if(!s)return;if(s.has("state")&&s.get("state").presence&&(pirPresence+=1),maxDuration>=10&&s.has("config")){let config={};if("duration"in s.get("config")){let duration=s.get("config").duration||60;duration>maxDuration?config.duration=maxDuration:maxDuration>60&&(config.duration=maxDuration);const uniqueid=s.get("uniqueid")||"";-1!==(s.get("modelid")||"").indexOf("lumi.sensor_motion")?duration<90&&(config.duration=90):-1!==uniqueid.indexOf("-0500")&&duration<90&&(config.duration=90)}if("delay"in s.get("config")){(s.get("config").delay||60)>maxDuration?config.delay=maxDuration:maxDuration>60&&(config.delay=maxDuration)}(config.duration||config.delay)&&restUpdateResource(s,{config:config}).then(()=>{console.log(pir+" updated "+JSON.stringify(config))}).catch(console.log)}"presence"in s.get("state")&&(sensorState="presence"),"open"in s.get("state")&&(sensorState="open"),"vibration"in s.get("state")&&(sensorState="vibration"),"water"in s.get("state")&&(sensorState="water");let r={name:fsm.type+"-trigger-"+sid,conditions:[{address:pir+"/state/"+sensorState,operator:"eq",value:"true"},{address:pir+"/state/lastupdated",operator:"dx"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!0}}]},rule=rulesToUpdate.shift(),promise=restUpdateResource(rule,r).catch(err=>restCreateResource(app.rules,r)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise);let r2={name:fsm.type+"-trigger-rev-"+sid,conditions:[{address:vpir+"/state/lastupdated",operator:"dx"},{address:vpir+"/state/presence",operator:"eq",value:"false"},{address:pir+"/state/"+sensorState,operator:"eq",value:"true"},{address:pir+"/config/reachable",operator:"eq",value:"true"},{address:status+"/state/status",operator:"gt",value:"0"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!0}}]},rule2=rulesToUpdate.shift(),promise2=restUpdateResource(rule2,r2).catch(err=>restCreateResource(app.rules,r2)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise2)}),switches.forEach(sw=>{let sid=sw.slice(sw.lastIndexOf("/")+1),mode="pir";if(u.has("switches")){let cfg=u.get("switches").find(x=>x.sid===sid);cfg&&cfg.mode&&(mode=cfg.mode)}let r=null;if("pir"===mode)r={name:fsm.type+"-sw-trigger-"+sid,conditions:[{address:sw+"/state/lastupdated",operator:"dx"}],actions:[{address:vpir+"/state",method:"PUT",body:{presence:!0}}]};else{if("master"!==mode)return;r={name:fsm.type+"-sw-trigger-"+sid,conditions:[{address:sw+"/state/lastupdated",operator:"dx"}],actions:[{address:status+"/state",method:"PUT",body:{status:-3}}]}}let rule=rulesToUpdate.shift(),promise=restUpdateResource(rule,r).catch(err=>restCreateResource(app.rules,r)).then(id=>(links.push("/rules/"+id),id));rulesToPush.push(promise)}),Promise.all(rulesToPush)}).then(result=>{result.forEach(id=>{let r=app.rules.get(id);r&&console.log("r "+id+" "+r.get("name")+" updated")});var toDelete=[];return rulesToUpdate.forEach(r=>{toDelete.push(restDeleteResource(r))}),Promise.all(toDelete)}).then(result=>restUpdateResource(rl,{links:links})).then(result=>restUpdateResource(rstatus,{state:{status:vstatusAfterUpdate}})).then(result=>restUpdateResource(rvpir,{state:{presence:pirPresence>0}})).then(result=>{console.log("all done"),app.poll.resume()}).catch(err=>{console.log(err)})}function checkPirRulesConsistency(){let rules=app.rules.filter(r=>0===r.get("name").indexOf("pir-fsm")).filter(r=>!app.resourcelinks.find(l=>-1!==l.get("links").indexOf("/rules/"+r.id)));return rules.length>0&&console.log("remove orphan PIR rules"),Promise.all(rules.map(r=>restDeleteResource(r))).then(()=>restGetResource(app.rules)).then(()=>app.resourcelinks.filter(rl=>rl.get("classid")===RL_PIR_CONTROL&&rl.get("links").filter(l=>0===l.indexOf("/groups")).find(g=>{let gid=g.slice(g.lastIndexOf("/")+1);return!app.groups.get(gid)}))).then(res=>Promise.all(res.map(rl=>deletePirControl(rl))))}app.PirTimeRangeView=Backbone.View.extend({el:"#pirTimeRange",initialize:function(){console.log(this.el);let slider=document.createElement("DIV");slider.classList.add("tr-slider"),this.el.appendChild(slider),this.sl=new TimeRangeSlider({el:slider})},render:function(){}}),app.PirStateConfigView=Backbone.View.extend({el:"#pirStateConfig",initialize:function(){this.listenTo(app,"state-clicked",this.stateClicked);var me=this;this.dimmInput=this.el.querySelector(".dimm-input input"),this.timeButton=this.el.querySelector("#pirTimeDropdown button .value"),$("#pirActionDropdown a").on("click",e=>{e.preventDefault();let model=app.pirStateListView.userparameter;var li=e.currentTarget.parentNode;if(!model||me.action===li.dataset.action)return;me.action=li.dataset.action;let states=model.get("states"),st=states[me.state];"bri"in st.group&&(st.dimm=st.group.bri);var group={};"on"===me.action?group.on=!0:"off"===me.action?group.on=!1:-1!==me.action.indexOf("dimm")&&("on-dimm"===me.action&&(group.on=!0),group.bri=me.dimmInput.value),updateVersion1ToVersion2(model),st.group=group,restUpdateResource(model,{states:states}).then(()=>restGetResource(model)).then(()=>{app.savePirControl(),me.updateUiFromState()})}),$("#pirTimeDropdown a").on("click",e=>{e.preventDefault();let model=app.pirStateListView.userparameter;if(!model)return;var li=e.currentTarget.parentNode;this.time=li.dataset.time,this.timeButton.innerText=e.currentTarget.innerText;let states=model.get("states")||[],st=states[this.state];updateVersion1ToVersion2(model);var ddx=st.state.find(c=>"ddx"===c.operator||"stable"===c.operator);ddx&&(ddx.value=this.time),restUpdateResource(model,{states:states}).then(()=>restGetResource(model)).then(()=>{app.savePirControl(),me.updateUiFromState()})}),$(this.dimmInput).on("change",function(e){if(e.preventDefault(),-1!==me.action.indexOf("dimm")){let model=app.pirStateListView.userparameter;if(!model)return;let states=model.get("states"),st=states[me.state];st.dimm=e.currentTarget.value,st.group.bri=st.dimm,updateVersion1ToVersion2(model),restUpdateResource(model,{states:states}).then(()=>restGetResource(model)).then(()=>{app.savePirControl()})}})},events:{click:"onClicked"},updateUiFromState:function(){let model=app.pirStateListView.userparameter;if(!model)return;var states=model.get("states"),st=states[this.state];this.el.dataset.state=this.state,this.action="no-action",st.group.on&&"bri"in st.group?(this.action="on-dimm",this.dimmInput.value=st.group.bri):"bri"in st.group?(this.action="dimm",this.dimmInput.value=st.group.bri):!0===st.group.on?this.action="on":!1===st.group.on&&(this.action="off");let $timeButton=$("#pirTimeDropdown button .value"),times=[];document.querySelectorAll("#pirTimeDropdown li").forEach((li,i)=>{times.push(li.getAttribute("data-time"))});let tmin=0,tmax=times.length;states.forEach((x,i)=>{if(i===this.state)return;if(!x.state||!x.name)return;if(-1===["start","dimm1","dimm2","end"].indexOf(x.name))return;let ddx=x.state.find(c=>"ddx"===c.operator||"stable"===c.operator);if(!ddx)return;let idx=times.indexOf(ddx.value);-1!==idx&&(i<this.state&&idx>=tmin?tmin=idx+1:i>this.state&&tmax>idx&&(tmax=idx))}),document.querySelectorAll("#pirTimeDropdown li").forEach((li,i)=>{i<tmin||i>=tmax?li.classList.add("hidden"):li.classList.remove("hidden")});let ddx=st.state.find(c=>"ddx"===c.operator||"stable"===c.operator);if(!ddx&&st.presence&&(ddx=st.presence.find(c=>"ddx"===c.operator)),ddx){let li=$('#pirTimeDropdown li[data-time="'+ddx.value+'"]');1===li.length?$timeButton.text(li.text()):$timeButton.text(ddx.value.slice(2))}this.el.dataset.action=this.action;var li=this.el.querySelector('[data-action="'+this.action+'"]');$("#pirActionDropdown button .action").text(li.innerText)},stateClicked:function(e){this.state=e.state,this.updateUiFromState()},render:function(){return this}}),app.PirDiagramView=Backbone.View.extend({el:null,collection:app.userparameter,initialize:function(){this.stateLabels=[],this.timeLabels=[],app.dia=this.svg=SVG("pirDiagram").size("100%","100%"),this.setElement(this.svg.node),this.listenTo(this.model,"change",this.render)},onResize:function(e){this.resizePending?clearTimeout(this.resizePending):this.clearAll(),this.resizePending=setTimeout(()=>{this.resizePending=void 0,this.render()},300)},clearAll:function(){this.svg.clear(),this.path=null,this.stateLabels=[],this.timeLabels=[]},render:function(){let data=[],tmin=null,tmax=null,textOn=translate("text_on"),textOff=translate("text_off"),textDimm=translate("text_dimm");var bodyStyles=window.getComputedStyle(document.body),icFill=bodyStyles.getPropertyValue("--ic-fill"),icLine=bodyStyles.getPropertyValue("--ic-line");this.model.get("states").forEach((st,stNum)=>{if(!st.group)return;let ddx=st.state.find(c=>"ddx"===c.operator||"stable"===c.operator),item={name:st.name};!ddx&&st.presence&&(ddx=st.presence.find(c=>"ddx"===c.operator)),(st.presence||ddx)&&(item.status="next"in st?st.next:stNum+1,ddx=ddx?ddx.value:"PT00:00:00","on"in st.group&&(item.on=st.group.on),"bri"in st.group&&(item.bri=parseInt(st.group.bri)),item.t=new Date("2017-01-01T"+ddx.slice(2)).getTime(),("on"in item||"bri"in item)&&((!tmin||tmin>item.t)&&(tmin=item.t),(!tmax||tmax<item.t)&&(tmax=item.t),data.push(item)))}),this.stateLabels.length!==data.length&&this.clearAll();let bbw=this.svg.rbox().w-64,bbh=this.svg.rbox().h-64,bbbottom=this.svg.rbox().h;if(!this.svg.node.hasChildNodes()){let x1=16,y1=Math.round(32+bbh),x2=x1+bbw+16,y2=y1;this.svg.line(x1,y1,x2,y2).stroke({color:icLine,width:1}).opacity(1),x1=16,y1=Math.round(32+bbh),x2=x1,y2=32,this.svg.line(x1,y1,x2,y2).stroke({color:icLine,width:1}).opacity(1)}let x0=16,y0=bbh+32,bri0=100,path1="M"+x0+","+y0;data.forEach((st,i)=>{let y=0;st.bri?(y=st.bri/100,bri0=st.bri):st.on&&(y=bri0/100),y=1-y;let label,x=(st.t-tmin)/(tmax-tmin);if(0===x&&(x=.035),x=32+x*bbw,y=32+y*bbh,isNaN(x)||isNaN(y))return;path1+=" C"+(x0+.3*(x-x0))+","+y0+" "+(x0+.1*(x-x0))+","+y+" "+x+","+y,i<this.stateLabels.length?(label=this.stateLabels[i]).animate(100).x(x-16).y(y-label.font("size")):((label=this.svg.text("").font({family:"Lato, LatoLatinWeb, LatoWeb",size:14})).x(x-16).y(y-14),this.stateLabels.push(label)),label.text(function(add){let fill=0!==app.pirState&&app.pirState===st.status?"#2196f3":icFill;"bri"in st?(add.tspan(st.on?textOn:textDimm).fill(fill),add.tspan(st.bri+"%").fill(fill).dx(8)):!0===st.on?add.tspan(textOn).fill(fill):!1===st.on&&add.tspan(textOff).fill(fill)});let seconds=(st.t-tmin)/1e3,txt=seconds>59?seconds/60+" min":seconds+" sec";if(0===seconds&&(txt="0"),i<this.timeLabels.length){let label=this.timeLabels[i];label.plain(txt),label.x(x-16).y(bbbottom-1.25*label.font("size"))}else{let label=this.svg.plain(txt).font({family:"Lato, LatoLatinWeb, LatoWeb",size:14}).x(x-16);label.y(bbbottom-1.25*label.font("size")),this.timeLabels.push(label)}x0=x,y0=y}),this.path?this.path.animate(100).plot(path1):(this.path=this.svg.path(path1).fill("none").stroke({color:icLine,width:1.5}),this.path.marker("mid",4,4,add=>{add.circle(4).fill(icFill)}))}}),app.PirStateView=Backbone.View.extend({tagName:"li",className:"list-group-item",template:_.template($("#pir-state-template").html()),initialize:function(){this.listenTo(this.model,"change",this.render),this.listenTo(this.model,"destroy",this.remove),this.$el.html(this.template(this.attributes)),this.labelAction=this.el.querySelector(".item-action"),this.labelExtra=this.el.querySelector(".item-extra"),this.labelTime=this.el.querySelector(".item-time");var use=this.el.querySelector(".item-icon use");0===this.attributes.state?use.setAttribute("xlink:href","#rule-start-icon"):-1===this.attributes.next&&use.setAttribute("xlink:href","#rule-end-icon"),this.render()},events:{click:"onClicked"},render:function(){let st=this.model.get("states")[this.attributes.state],action="",time="",extra="";if(st){if(st.group&&(action=!0===st.group.on?translate("text_on"):"bri"in st.group?translate("text_dimm"):!1===st.group.on?translate("text_off"):translate("action_none"),"bri"in st.group&&(extra=st.group.bri+"%")),st.presence){let ddx=st.presence.find(c=>"ddx"===c.operator);if(ddx){console.log("warning old state format -> TODO rebuild");let tref="2017-01-01T",t0=new Date("2017-01-01T00:00:00").getTime(),min=(new Date(tref+ddx.value.slice(2)).getTime()-t0)/1e3/60;time=translate("text_after")+" "+min+" "+translate(min<=1?"text_minute":"text_minutes")}}if(st.state){let ddx=st.state.find(c=>"ddx"===c.operator||"stable"===c.operator);if(ddx){let tref="2017-01-01T",t0=new Date("2017-01-01T00:00:00").getTime(),sec=(new Date(tref+ddx.value.slice(2)).getTime()-t0)/1e3,min=sec/60;time=sec<60?translate("text_after")+" "+sec+" "+translate("text_seconds"):translate("text_after")+" "+min+" "+translate(min<=1?"text_minute":"text_minutes")}}return this.labelAction.innerText=action,this.labelExtra.innerText=extra,this.labelTime.innerText=time,this}console.log("warning st == null this should not happen")},onClicked:function(){app.trigger("state-clicked",{view:this,model:this.model,state:this.attributes.state})}}),app.PirStateListView=Backbone.View.extend({el:"#pirStateList",collection:app.userparameter,initialize:function(){this.views=[],this.resourcelinks=null,this.userparameter=null,this.dia=null,app.pirState=null,this.listenTo(app.userparameter,"add change",this.updatedUserParameter),this.listenTo(app,"active-item-changed",this.sensorControlChanged),this.listenTo(app,"state-clicked",this.stateClicked),this.listenTo(app.sensors,"change",this.sensorChanged),window.addEventListener("resize",e=>{this.dia&&this.dia.onResize(e)})},updateCurrentState:function(sensor){if("CLIPGenericStatus"===sensor.get("type")){var state=sensor.get("state");app.pirState!==state.status&&(app.pirState=state.status,this.dia&&this.dia.render()),this.views.forEach(view=>{view.attributes.next===state.status&&0!==state.status?view.el.classList.add("current"):view.el.classList.remove("current")})}},sensorChanged:function(sensor,options){this.resourcelinks&&-1!==this.resourcelinks.get("links").indexOf("/sensors/"+sensor.id)&&this.updateCurrentState(sensor)},updatedUserParameter:function(model){if(this.userparameter===model&&!model.isNew()){var data=model.attributes;if(data.type&&data.states&&"pir-fsm"===data.type){if(gatewayVersion()>=20530){let v=model.get("version");1===model.get("version")&&updateVersion1ToVersion2(model),2===model.get("version")&&updateVersion2ToVersion3(model),v!==model.get("version")&&(console.log("updated pir control version from "+v+" to "+data.version),model.save(),app.savePirControl())}data.states.forEach((st,index)=>{var view=this.views.find(v=>v.model.id===model.id&&v.attributes.name===st.name);st.state.length>0&&"eq"===st.state[0].operator&&"-1"===st.state[0].value||(console.log("update state",st.name),view&&view.attributes.name===st.name?view.render():((view=new app.PirStateView({model:model,attributes:{name:st.name,state:index,next:st.next}})).el.classList.add("hidden"),this.views.push(view),this.$el.append(view.render().el)))})}}},sensorControlChanged:function(e){app.pirState=null,this.resourcelinks=null,this.userparameter=null,this.views.forEach(v=>v.remove()),this.views=[],this.dia&&(this.dia.remove(),this.dia=null),app.pirStateConfigView.el.dataset.state="none";var a=this.el.parentElement.querySelector(".active-item");if(a&&a.classList.remove("active-item"),e.model.get("classid")===RL_PIR_CONTROL){var u=e.model.get("links").find(x=>x.indexOf(!1));u&&(u=u.split("/").pop(),(u=app.userparameter.get(u))&&(this.resourcelinks=e.model,this.userparameter=u)),this.resourcelinks&&this.userparameter&&(this.updatedUserParameter(this.userparameter),this.views.forEach(v=>{v.model==this.userparameter?(v.el.classList.remove("hidden"),0===v.attributes.state&&v.$el.after($(".no-motion"))):v.el.classList.add("hidden")}),this.dia=new app.PirDiagramView({model:this.userparameter}),this.timeRange=new app.PirTimeRangeView({model:this.userparameter}),e.model.get("links").find(x=>{if(0!==x.indexOf("/sensors/"))return!1;let sid=x.split("/").pop(),s=app.sensors.get(sid);return!(!s||"CLIPGenericStatus"!==s.get("type"))&&(this.updateCurrentState(s),!0)}),app.pirSettingsView.update(this.userparameter))}},stateClicked:function(e){var cur=e.view.el.parentElement.querySelector(".active-item");e.view.el.classList.add("active-item"),cur&&e.view.el!==cur&&cur.classList.remove("active-item")}}),app.PirSettingsView=Backbone.View.extend({el:"#pirSettings",events:{'click input[name="pirActiveRadios"]':"pirActiveRadioChanged"},initialize:function(){let dl=app.sensors.find(x=>"Daylight"===x.get("type")),enable=!1;dl&&dl.has("config")&&dl.get("config").configured&&(enable=!0),["#optNoDaylight","#optDaylight"].forEach(opt=>{let o=document.querySelector(opt);o&&(enable?o.removeAttribute("disabled"):o.setAttribute("disabled","true"))})},pirActiveRadioChanged:function(e){console.log(e.target.value),restSaveResource(this.model,{activate:e.target.value}).then(()=>restGetResource(this.model)).then(()=>app.savePirControl())},update:function(model){this.model=model;var val=model.get("activate")||"always";$('input[value="'+val+'"]',this.el).prop("checked",!0)},render:function(){}}),app.PirSensorView=Backbone.View.extend({tagName:"li",className:"list-group-item",template:_.template($("#pir-sensor-item-template").html()),initialize:function(){this.model.on("change",this.render,this),this.model.on("destroy",this.remove,this),this.$el.html(this.template(this.model.attributes)),this.el.setAttribute("data-id",this.model.get("mac"));let iconId=getDeviceIconId(this.model.attributes);if("#empty-frame-icon"===iconId&&(iconId="#generic-sensor-icon"),iconId){this.el.querySelector(".item-icon use").setAttribute("xlink:href",iconId)}let infoEl=this.el.querySelector(".item-extra");"ZHAVibration"===this.model.get("type")&&(infoEl.innerText="Vibration"),"ZHAOpenClose"===this.model.get("type")&&(infoEl.innerText="Contact"),"ZHAWater"===this.model.get("type")&&(infoEl.innerText="Water"),"ZHAPresence"!==this.model.get("type")&&"ZLLPresence"!==this.model.get("type")||(infoEl.innerText="Motion")},events:{"click .item-check":"onClicked"},onClicked:function(ev){ev.target.closest(".list-group-item").classList.contains("activated")?app.activatedSensor=void 0:app.activatedSensor=this.model,togglePirResourcelink(app.pirStateListView.resourcelinks,this.model).then(result=>{this.render()})},render:function(){var links=[];app.pirStateListView.resourcelinks&&(links=app.pirStateListView.resourcelinks.get("links")),-1!==links.indexOf("/sensors/"+this.model.id)?this.el.classList.add("activated"):this.el.classList.remove("activated");var state=this.model.get("state");"presence"in state&&state.presence||"open"in state&&state.open||"vibration"in state&&state.vibration||"water"in state&&state.water?this.el.classList.add("presence"):this.el.classList.remove("presence");let name=this.el.querySelector(".item-name");return name.innerText!==this.model.get("name")&&(name.innerText=this.model.get("name")),this},edit:function(){}}),app.PirSwitchView=Backbone.View.extend({tagName:"li",className:"list-group-item",template:_.template($("#pir-switch-item-template").html()),initialize:function(){this.model.on("change",this.render,this),this.model.on("destroy",this.remove,this);var icon=getDeviceIconId(this.model.attributes);"#empty-frame-icon"===icon&&(icon="#generic-switch-icon"),this.model.has("icon")||this.model.set({icon:icon})},events:{"click .item-check":"onClicked","click .item-motion":"onClickedMode"},onClicked:function(){toggleSwitchResourcelink(app.pirStateListView.resourcelinks,this.model).then(result=>{this.render()})},onClickedMode:function(){toggleSwitchMode(app.pirStateListView.resourcelinks,app.pirStateListView.userparameter,this.model).then(result=>{this.render()})},render:function(){var links=[];app.pirStateListView.resourcelinks&&(links=app.pirStateListView.resourcelinks.get("links"));let activated=!1,endpoints=this.model.get("endpoints");return Object.keys(endpoints).forEach(x=>{let sid=endpoints[x].id,r="/sensors/"+sid;-1!==links.indexOf(r)&&(activated=!0);let mode=null,up=app.pirStateListView.userparameter;if(up&&up.has("switches")){let cfg=up.get("switches").find(x=>x.sid===sid);cfg&&cfg.mode&&(mode=cfg.mode)}"pir"===mode?this.el.classList.add("presence"):this.el.classList.remove("presence")}),activated?this.el.classList.add("activated"):this.el.classList.remove("activated"),this.$el.html(this.template(this.model.attributes)),this},edit:function(){}}),app.PirSensorListView=Backbone.View.extend({el:"#pirSensorList",collection:app.sensors,initialize:function(){this.views=[],this.listenTo(this.collection,"add",this.addOne),this.listenTo(app.switches,"add",this.addSwitch),this.listenTo(app,"active-item-changed",this.activeItemChanged),app.sensors.forEach(sensor=>this.addOne(sensor)),app.switches.forEach(sw=>this.addSwitch(sw))},addOne:function(model){if(-1!==["ZHAPresence","ZLLPresence","ZHAVibration","ZHAOpenClose","ZHAWater"].indexOf(model.get("type"))&&!(view=this.views.find(function(view){return view.model.get("type")===model.get("type")&&view.model.get("mac")===model.get("mac")}))){var view=new app.PirSensorView({model:model});this.views.push(view),this.$el.append(view.el)}},addSwitch:function(model){if(["Scene Switch","Lighting Switch","RWL02","HS_4f_GJ_1","WS_4f_J_1","WS_3f_G_1","ZGPSWITCH","TRADFRI remote","RM01","RB01","lumi.vibration","WaterSensor-EM","button","ROM001","RDM003","lumi.sensor_switch","lumi.ctrl_ln","lumi.sensor_86sw","lumi.remote","TRADFRI on/off switch","FOHSWITCH"].find(x=>-1!==model.get("modelid").indexOf(x))){if(!(view=this.views.find(function(view){return view.model.collection===app.switches&&view.model.get("id")===model.get("id")}))){var view=new app.PirSwitchView({model:model});this.views.push(view),this.$el.append(view.el)}}else console.log("unsupported switch",model.get("modelid"))},activeItemChanged:function(){this.views.forEach(v=>{v.render()})}}),app.savePirControl=_.debounce(function(){var rl=app.pirStateListView.resourcelinks,u=app.pirStateListView.userparameter;rl&&u&&(app.poll.pause(),Promise.all([restGetResource(app.resourcelinks),restGetResource(app.rules),checkPirRulesConsistency()]).then(()=>{createStateMachineRules(rl,u)}))},2e3);const defaultPirStateMachine={type:"pir-fsm",version:4,states:[{name:"start",state:[{operator:"gt",value:"-1"}],next:1,presence:[{operator:"eq",value:"true"}],group:{on:!0,bri:100,transitiontime:20}},{name:"dimm1",state:[{operator:"eq",value:"1"},{operator:"stable",value:"PT00:02:00"}],presence:[{operator:"eq",value:"false"}],next:2,group:{bri:50,transitiontime:100}},{name:"dimm2",state:[{operator:"eq",value:"2"},{operator:"stable",value:"PT00:03:00"}],next:3,group:{bri:1,transitiontime:100}},{name:"end",state:[{operator:"eq",value:"3"},{operator:"stable",value:"PT00:05:00"}],next:0,group:{on:!1}},{name:"wait",state:[{operator:"eq",value:"-1"},{operator:"stable",value:"PT00:00:10"}],next:0}]};