/*! phoscon-app 2025-08-28 */

export function initDetailsView(injectSwitchWizzardSvg,pageParams){let getSvgDevicePath=pageParams.constants.getSvgDevicePath||null,getSvgIconPath=pageParams.constants.getSvgIconPath||null;if(!getSvgDevicePath||!getSvgIconPath)throw new Error("getSvg function is missing, initDetailsView");return Backbone.View.extend({el:"#details",template:_.template(document.getElementById("thermostat-details-template").innerHTML),initialize:function(model){this.model=model,app.session.thid=this.model.get("id"),this.views=[],this.listenTo(this.model,"change",this.render),this.el.innerHTML=this.template(model),this.nameLabel=this.el.querySelector("h1 span"),this.vendorLabel=this.el.querySelector(".vendor"),this.productLabel=this.el.querySelector(".product"),this.batteryLabel=this.el.querySelector(".battery .battery-content"),this.productExtraLabel=this.el.querySelector(".product + i"),this.plusBtn=this.el.querySelector("#tempPlusBtn"),this.minusBtn=this.el.querySelector("#tempMinusBtn");this.model.get("modelid");setStateValues(this.model,this.el),loadLanguage(),this.unit=" °C",-1!==navigator.language.indexOf("US")&&(this.unit=" °F"),this.render(),this.show(),loadLanguage()},events:{"click [data-btn-ev]":function(e){let el=e.currentTarget;if(!el)return;let ev=el.getAttribute("data-btn-ev");this.service.send(ev)}},raiseTemp:function(unit){let elem=document.querySelector(".heatsetpoint.data-val"),val=elem.innerText.split(" ")[0];(val=Number(val)%1==.5?Number(val)+.5:Number(val)+1)>30?elem.innerText="30"+unit:(elem.innerText=val+unit," °F"===unit&&(val=5/9*(Number(val)-32)),val*=100,saveDebounced(this.model,val))},lowerTemp:function(unit){let elem=document.querySelector(".heatsetpoint.data-val"),val=elem.innerText.split(" ")[0];(val=Number(val)%1==.5?Number(val)-.5:Number(val)-1)<5?elem.innerText="5"+unit:(elem.innerText=val+unit," °F"===unit&&(val=5/9*(Number(val)-32)),val*=100,saveDebounced(this.model,val))},render:function(){if(app.session.thid!==this.model.get("id"))return;setStateValues(this.model,this.el,this.unit),this.nameLabel.textContent!==this.model.get("name")&&(this.nameLabel.textContent=this.model.get("name"));let lastu=this.model.get("state").lastupdated;if(lastu){let el=this.el.querySelector(".lastupdated");if(lastu&&"none"!==lastu){let value=(lastu=moment.utc(lastu)).local().format("L LTS"),now=new Date,lastUpdated=new Date(lastu),seconds=new Date(now.getTime()-lastUpdated.getTime())/1e3,minutes=seconds/60,hours=minutes/60,days=hours/24;var text="",updateTimes=0;days>=1?(updateTimes=days,text=translate("text_before_days")):hours>=1?(updateTimes=hours,text=translate("text_before_hours")):minutes>=1?(updateTimes=minutes,text=translate("text_before_minutes")):(updateTimes=seconds,text=translate("text_before_seconds")),updateTimes=Math.floor(updateTimes),el.classList.remove("hide"),el.querySelector(".data-val").innerHTML=`<span>${value}</span><span><i>${text}</i></span>`,el.querySelector(".data-val .number").innerHTML=`${updateTimes}`}else el.classList.add("hide")}return this},show:function(){this.el.classList.remove("hide"),this.plusBtn.addEventListener("click",()=>{this.raiseTemp(this.unit)}),this.minusBtn.addEventListener("click",()=>{this.lowerTemp(this.unit)})},hide:function(){this.el.classList.add("hide"),this.plusBtn.replaceWith(this.plusBtn.cloneNode(!0)),this.minusBtn.replaceWith(this.minusBtn.cloneNode(!0))}})};const saveDebounced=_.debounce((model,heatsetpoint)=>{let sensor=app.sensors.find(s=>s.attributes.uniqueid===model.get("uniqueid"));sensor&&restUpdateResource(sensor,{config:{heatsetpoint:heatsetpoint}})},1e3);function setStateValues(model,el,unit){var thermostat=app.thermostats.filter(sn=>sn.get("mac")===model.get("mac"))||[],statesToShow=["swversion","temperature","windowopen","battery","lowbattery","lastupdated","buttonevent","mode","preset","heatsetpoint","open","locked"],states={};for(var state in el.querySelectorAll(".thermostat-states span").forEach(el=>el.classList.add("hide")),thermostat.forEach(sn=>{states=Object.assign(states,sn.get("state")||{}),states=Object.assign(states,{swversion:sn.get("swversion")}||{}),(statesToShow.filter(s=>s in model.get("config"))||[]).forEach(state=>{states=Object.assign(states,{[state]:sn.get("config")[state]})})}),states)if(-1!==statesToShow.indexOf(state)){var value=states[state];if("open"===state);else if("temperature"===state){if(!value)continue;value/=100," °F"===unit&&(value=40),value=Math.round(2*value)/2,value+=unit}else if("battery"===state){if(!value)continue;value+="&nbsp;%"}else if("lowbattery"===state)0===model.get("modelid").indexOf("lumi.")&&(value=""),null===value?value=translate("text_lowbat_unknown"):!1===value?value=translate("text_lowbat_ok"):!0===value&&(value=translate("text_lowbat_low"));else if("lastupdated"===state&&model.get("config").reachable){let t=moment.utc(value),tooOld=moment().subtract(2,"days"),reachable=!1,lastupdated=null;t.isAfter(tooOld)?(reachable=!0,lastupdated&&!lastupdated.isBefore(t)||(lastupdated=t)):model.get("config").reachable&&console.log(`sensor ${model.id} shouldn't be reachable`),lastupdated&&(value=lastupdated.local().format("L LTS"),value+="&nbsp;<i>"+lastupdated.fromNow()+"</i>")}else"heatsetpoint"==state?(value/=100," °F"===unit&&(value=40),value=Math.round(2*value)/2,value+=unit):"preset"==state?value="manual"===value?translate("th_manual"):"holiday"===value?translate("th_holiday"):value:"locked"===state&&(value=!0===value?'<svg width="18" height="18" class="svg-icon"> <use transform="scale(0.375)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#lock-close"></use></svg>':'<svg width="18" height="18" class="svg-icon"> <use transform="scale(0.375)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#lock-open"></use></svg>');if(value&&""!==value&&"none"!==value&&null!==value&&void 0!==value){el.querySelectorAll("."+state).forEach(el=>el.classList.remove("hide"));let dataElem=el.querySelector("."+state+".data-val");dataElem&&(dataElem.innerHTML=value)}}}