/*! phoscon-app 2025-08-28 */

export function initOverview(injectSwitchWizzardSvg,pageParams){let tableView,bottomView;pageParams.constants.svgPathsBlinds;const OverviewView=Backbone.View.extend({el:"#overview",template:_.template(document.getElementById("blind-overview-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),tableView=new TableView,bottomView=new BottomView},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),EmptyView=Backbone.View.extend({el:".empty-div",template:_.template(document.getElementById("blind-empty-template").innerHTML),initialize:function(){this.el.innerHTML=this.template()},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}}),BottomView=Backbone.View.extend({el:"#bottom",template:_.template(document.getElementById("search-blind-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),this.searchText1=this.el.querySelector("#c_newLi_la"),this.emptyDiv=document.querySelector(".empty-div"),this.time=this.el.querySelector("#time"),this.timeLabels=this.time.querySelectorAll("span"),this.progressBar=this.el.querySelector("#progressBar"),this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne)},setSearchActive:function(){this.searchText1.textContent=translate("txt_searchBlinds"),document.body.classList.add("search-active"),this.emptyDiv.classList.add("search")},setSearchInactive:function(){document.body.classList.remove("search-active"),this.emptyDiv.classList.remove("search"),this.time.style.opacity=0},updateProgressBarSmooth:function(start,end,duration){let current=start;const step=(end-start)/(duration/50),interval=setInterval(()=>{(current+=step)>=end&&(clearInterval(interval),current=end),this.updateProgressBar(current)},50)},updateProgressBar:function(width){this.progressBar.style.width=width+"%"},setTimelabelOneMinute:function(){this.timeLabels[0].textContent=" ",this.timeLabels[1].textContent=translate("text_1min_remaining")},setTimelabelMinutesRemaining:function(min){this.time.classList.remove("hidden"),this.time.style.opacity=1,this.timeLabels[0].textContent=min+" ",this.timeLabels[1].textContent=translate("text_min_remaining")},setTimeLabelMinutes:function(min){this.timeLabels[0].textContent=min+" "}}),TableView=Backbone.View.extend({el:"#switchTable",collection:app.blinds,initialize:function(){this.views=[],this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne),app.blinds.forEach(this.addOne,this)},addOne:function(model){var view=new TableRowView({model:model});this.$el.append(view.render().el),this.views.push(view)},removeOne:function(model){let views=this.views.filter(v=>v.model.get("id")!==model.get("id"));this.views=views}}),TableRowView=Backbone.View.extend({tagName:"tr",template:_.template($("#blind-item-template").html()),initialize:function(){this.model.on("change",this.render,this),this.model.on("destroy",this.remove,this),this.model.set("product",getDeviceProductName(this.model.attributes));var html=this.template(this.model.attributes);this.$el.html(html),this.$el.attr("data-bid",this.model.id),this.nameLabel=this.el.querySelector("td:nth-child(2)"),this.vendorLabel=this.el.querySelector("td:nth-child(3)"),this.productLabel=this.el.querySelector("td:nth-child(4)"),this.stateLabel=this.el.querySelector("td:nth-child(5)"),this.lightModel=app.lights.get(this.model.id);let iconImg=this.el.querySelector(".item-icon");iconImg.setAttribute("src","img/blinds/48px/blind-icon.svg#generic-blind-icon"),injectSwitchWizzardSvg([iconImg]),this.service=null,this.render()},events:{"click .open-detail":function(){app.router.navigate("blind/"+this.model.id,{trigger:!0})}},render:function(){console.log("render blind "+this.model.get("id")),this.model.get("reachable")?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable");const name=this.model.get("name");this.nameLabel&&this.nameLabel.textContent!==name&&(this.nameLabel.textContent=name);const vendor=this.model.get("vendor")||this.model.get("manufacturername");this.vendorLabel&&this.vendorLabel.textContent!==vendor&&(this.vendorLabel.textContent=vendor);const product=this.model.get("product");this.productLabel&&this.productLabel.textContent!==product&&(this.productLabel.textContent=product);var val=(100-this.model.get("state").lift).toFixed(0);return"NaN"===val?val="":val<=0?val=translate("txt_close"):setTimeout(()=>{val=val+"% "+translate("text_isopen")},300),this.stateLabel&&this.stateLabel.textContent!==val&&setTimeout(()=>{this.stateLabel.textContent=val},300),this}});return{overview:new OverviewView,emptyview:new EmptyView,tableView:tableView,bottomView:bottomView}};