<!-- template for thermostat details -->
<script type="text/us-templ" id="thermostat-details-template">
    <div class="main-head">
        <h1>
            <svg width="33" height="33" class="svg-icon mq-desktop">
                <use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#thermostat-icon"></use>
            </svg>

            <span><%- attributes.name %></span>
            <div class="item-edit pencil mq-desktop" data-toggle="modal" data-target="#renameThermostatModal" data-swid="<%- cid %>">
                <svg width="24" height="24"><use transform="scale(0.48)" xlink:href="#icon-rename" /></svg>
            </div>
            <div class="mq-phone context-menu-box">
            <div class="context-menu-outer"></div>
            <svg class="context-menu-icon" width="24" height="24"><use transform="scale(0.48)" xlink:href="#dot-menu" /></svg>
            <ul class="context-menu">
                <li data-toggle="modal" data-target="#renameThermostatModal" data-swid="<%- cid %>">
                    <svg width="18" height="18"><use transform="scale(0.36)" xlink:href="#icon-rename" /></svg>
                    <span data-translateid="txt_rename">Umbenennen</span>
                </li>
                <li data-toggle="modal" data-target="#deleteThermostatModal">
                    <!-- templ-include: img/24px/delete.svg -->
                    <span data-translateid="txt_delete">Löschen</span>
                </li>
            </ul>
        </div>
        </h1>
        <a id="deleteThermostat_btn" type="button" class="hdr-delete-btn mq-desktop" data-toggle="modal" data-target="#deleteThermostatModal">
            <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#delete-icon-sm" /></svg>
            <span data-translateid="deleteThermostat">Thermostat löschen</span>
        </a>
        <!-- <button class="btn btn-default del-thermostat">DEL</button> -->
    </div>            

    </div>

    <div class="main-content">
        <svg width="192" height="192" id="detailImg" viewBox="0 0 48 48" >
            <use transform="scale(1)" xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#thermostat-icon"></use>
        </svg>

        <div id="detailInfos">
            <div class="generals thermostat-generals">
                <span data-translateid="th_vendor">Vendor</span> 
                <span class="vendor details-content"><%- attributes.manufacturername %></span>

                <span data-translateid="th_product">Product</span> 
                <div>
                    <span class="product details-content"><%- attributes.product %></span>
                    <i id="vsExtra"></i>
                </div>
            </div>

            <div class="sensor-states">
                <span class="swversion" data-translateid="th_version">Version</span>
                <span class="swversion data-val details-content"></span>

                <div class="lastupdated">
                    <span data-translateid="th_lastupdated">Last seen</span>
                    <span class="data-val details-content">{lastupdated}</span>
                </div>
                <div></div>

                <span class="battery hide" data-translateid="th_battery"></span>
                <span class="battery details-content data-val hide"></span>

                <span class="lowbattery hide" data-translateid="th_battery"></span>
                <span class="lowbattery details-content hide data-val"></span>            

                <span class="preset hide" data-translateid="th_preset"></span>
                <span class="preset details-content data-val hide"></span>

                <!--
                <span class="mode hide" data-translateid="th_mode"></span>
                <span class="mode details-content data-val hide"></span>
            
                <span class="windowopen hide" data-translateid="th_windowopen"></span>
                <span class="windowopen details-content data-val hide"></span>
                -->

                <span class="temperature hide" data-translateid="th_roomtemperature"></span>
                <span class="temperature details-content data-val hide"></span>

                <span class="locked hide" data-translateid="th_locked"></span>
                <span class="locked details-content data-val hide">
                </span>
                <span class="heatsetpoint" data-translateid="th_heatsetpoint"></span>
                <span class="heatsetpoint hide">
                    <button id="tempMinusBtn" class="btn bottom-bar">-</button>
                    <span class="box details-content heatsetpoint data-val"></span>
                    <button id="tempPlusBtn" class="btn bottom-bar">+</button>
                </span>
            </div>

            <div id="devUpdate" class="hide">
                <a class="changelog-wizard" href="#" data-translateid="text_view_change">Show changelog</a>
                <button class="btn btn-default update-wizard" data-toggle="modal" data-target="#thermostatWizardModal" data-translateid="text_updateFirmware">Update firmware</button>
            </div>
        </div>
    </div>
</script>