/*! phoscon-app 2024-10-07 */

export function initOverview(constants,injectSwitchWizzardSvg){let tableView;const OverviewView=Backbone.View.extend({el:"#overview",template:_.template(document.getElementById("sensor-overview-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),tableView=new TableView,this.service=null},events:{},show:function(){this.el.classList.remove("hide"),tableView.refreshListeners()},hide:function(){this.el.classList.add("hide")}}),TableView=Backbone.View.extend({el:"#sensorTable",collection:app.sensors,initialize:function(){this.views=[],this.service=null,this.listenTo(this.collection,"add",this.addOne),this.listenTo(this.collection,"remove",this.removeOne),this.collection.forEach(this.addOne,this)},refreshListeners:function(){this.views.forEach(view=>{view.initialize(),view.render()})},addOne:function(model){if(getDeviceDevtype(model.attributes)!==DEV_TYPE_SENSOR)return;if("ZHAThermostat"===model.attributes.type)return;let view=this.views.find(view=>view.model.get("mac")===model.get("mac"));if(view)return this.changeMultiSensorIcon(view.model,model)?(view.remove(),this.views.pop(view),view=new TableRowView({model:model}),this.$el.append(view.render().el),void this.views.push(view)):void 0;view=new TableRowView({model:model}),this.$el.append(view.render().el),this.views.push(view)},changeMultiSensorIcon:function(lastModel,currentModel){let lastType=lastModel.get("type"),currentType=currentModel.get("type");return constants.multiSensorIconHierarchy[currentType]&&constants.multiSensorIconHierarchy[currentType]<constants.multiSensorIconHierarchy[lastType]?(console.log(lastType+" / "+currentType+": chose "+currentType+" icon"),!0):(console.log(lastType+" / "+currentType+": don't change"),!1)},removeOne:function(model){let views=this.views.filter(v=>v.model.get("id")!==model.get("id"));this.views=views,0!==this.views.length&&-1===window.location.hash.indexOf(model.get("id"))||app.router.navigate("table",{trigger:!0})}}),TableRowView=Backbone.View.extend({tagName:"tr",template:_.template(document.getElementById("sensor-item-template").innerHTML),initialize:function(){this.model.set("product",getDeviceProductName(this.model.attributes)),this.el.innerHTML=this.template(this.model.attributes),this.service=null,this.iconImg=this.el.querySelector(".item-icon"),this.itemAttrs=this.el.querySelectorAll(".item-attr"),this.nameLabel=this.el.querySelector(".name-val");let iconPath=constants.getSvgIconPath(this.model,"img/sensors/","svgPathsSensors");this.iconImg.setAttribute("src",iconPath),injectSwitchWizzardSvg([this.iconImg]),this.sensors=app.sensors.where({mac:this.model.get("mac")}),this.sensors.forEach(s=>this.listenTo(s,"change",this.render)),this.model.on("destroy",this.remove,this)},render:function(){if("PHDL00"==this.model.get("modelid")){let attr=getDaylightSensorAttribute(this.model,constants);this.el.classList.add("disabled"),attr.reachable?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable");let img=`<img src="${attr.icon}" width="24" height="24" class="svg-icon"/>`;this.itemAttrs[0].innerHTML=img,this.itemAttrs[1].innerHTML=img,attr.reachable&&(injectSwitchWizzardSvg([this.itemAttrs[0].querySelector("img")]),injectSwitchWizzardSvg([this.itemAttrs[1].querySelector("img")]))}else{let name=this.model.get("name");name!=this.nameLabel.innerText&&(this.nameLabel.innerText=name);let state=[];this.model.get("config").reachable?this.el.classList.remove("not-reachable"):this.el.classList.add("not-reachable"),constants.sensorValues.forEach(value=>{let sensor=this.sensors.find(s=>value in s.get("config")||value in s.get("state"));if(!sensor)return;let val=getValueState(value,sensor,constants);val&&state.push(val)}),state=state.join(", "),this.itemAttrs[0].innerHTML=state,this.itemAttrs[1].innerHTML=state;let imgs=this.itemAttrs[0].querySelectorAll("img");injectSwitchWizzardSvg(imgs);let imgs2=this.itemAttrs[1].querySelectorAll("img");injectSwitchWizzardSvg(imgs2)}return this},addOne:function(model){if(app.testEmptyState)console.log("don't add device in test empty state");else if(model.has("modelid")&&-1===model.get("modelid").indexOf("lumi.vibration")){var view=new TableRowView({model:model});this.$el.append(view.render().el),this.views.push(view)}},removeOne:function(model){let views=this.views.filter(v=>v.model.get("id")!==model.get("id"));this.views=views,0!==this.views.length&&-1===window.location.hash.indexOf(model.get("id"))||app.router.navigate("table",{trigger:!0})},events:{click:function(){this.el.classList.contains("disabled")||app.router.navigate("sensor/"+this.model.id,{trigger:!0})}}});return{overview:new OverviewView,tableView:tableView}};function getValueState(v,model,c){let value=model.get("config")[v]||model.get("state")[v];if(null!=value){switch(v){case"open":case"vibration":case"alarm":case"water":case"presence":case"fire":case"carbonmonoxide":value=getSvgOrTxt(value,v,c);break;case"lightlevel":(value=Math.pow(10,value/1e4))>=1?value-=1:value=0,value=Math.round(value)+"&nbsp;Lux";break;case"temperature":value=parseInt(value/100)+"&nbsp;°C";break;case"humidity":value=parseFloat(value/100)+"&nbsp;%";break;case"pressure":value+="&nbsp;hPa";break;case"airquality":value=translate("txt_"+value);break;case"particulatematter":value=value;break;default:value=void 0}return value}}function getSvgOrTxt(value,val,{sensorValueIconPath:sensorValueIconPath}){let path=sensorValueIconPath[val];if("open"==val)return value?translate("text_isopen"):translate("text_closed");if(""==path)return value?translate("text_detected_true"):translate("text_detected");return`<img src="${path}" width="24" height="24" class="svg-icon svg-icon-detected${value?" detected":""}"/>`}function getDaylightSensorAttribute(model,c){console.log("render daylight sensor:",model.id);let cfg=model.get("config")||{},state=model.get("state")||{},ico=c.iconMoonPath,status="status"in state?state.status:0,reachable=!!cfg.configured;return!0!==state.daylight&&160!=status||(ico=c.iconSunPath),cfg.configured?status>=140&&status<160?ico=c.iconSunrisePath:status>=180&&status<=210&&(ico=c.iconSunsetPath):ico="#",{icon:ico,reachable:reachable}}