<!-- template for switch details -->
<script type="text/us-templ" id="switch-details-template">
    <div class="main-head">
        <h1>
            <img src="#" data-svgInject="switchWizzardSvg" data-wiz-page="none" class="svg-icon mq-desktop"/>
            <span><%- attributes.name %></span>
            <div class="item-edit pencil mq-desktop" data-toggle="modal" data-target="#renameSensorModal" data-swid="<%- cid %>">
                <svg width="24" height="24"><use transform="scale(0.48)" xlink:href="#icon-rename" /></svg>
            </div>
        </h1>
        <a id="deleteSwitches_btn" type="button" class="hdr-delete-btn mq-desktop" data-toggle="modal" data-target="#deleteSwitchModal">
            <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#delete-icon-sm" /></svg>
            <span data-translateid="deleteSwitch">Schalter löschen</span>
        </a>

        <div class="mq-phone context-menu-box">
            <div class="context-menu-outer"></div>
            <svg class="context-menu-icon" width="24" height="24"><use transform="scale(0.48)" xlink:href="#dot-menu" /></svg>
            <ul class="context-menu">
                <li data-toggle="modal" data-target="#renameSensorModal" data-swid="<%- cid %>">
                    <svg width="18" height="18"><use transform="scale(0.36)" xlink:href="#icon-rename" /></svg>
                    <span data-translateid="txt_rename">Umbenennen</span>
                </li>
                <li data-toggle="modal" data-target="#deleteSwitchModal">
                    <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#delete-icon-sm" /></svg>
                    <span data-translateid="txt_delete">Löschen</span>
                </li>
            </ul>
        </div>

    </div>

    <div class="main-content">

        <img id="detailImg" src="#" data-svgInject="switchWizzardSvg" data-wiz-page="none" class="interactive"/>

        <div id="detailInfos">
            <div class="generals">
                <span data-translateid="th_vendor">Vendor</span> 
                <span class="vendor"><%- attributes.manufacturername %></span>

                <span data-translateid="th_product">Product</span> 
                <div>
                    <span class="product"><%- attributes.product %></span>
                    <i id="vsExtra"></i>
                </div>
            </div>

            <div class="swversion">
                <span data-translateid="th_version">Version</span> 
                <span class="swversion-label"><%- attributes.swversion %></span>

                <div class="version-ok" data-translateid="text_versionOk">Die Version ist auf dem neuesten Stand</div>
            </div>

            <div class="battery">
                <span data-translateid="th_battery">Battery</span> 
                <span class="battery-content"><%- attributes.config.battery %> %</span>
            </div>

            <div class="state">
                <span data-translateid="th_state">State</span>
                <span class="state-value">unknown</span>
                <span data-translateid="th_gesture">Gesture</span>
                <span class="gesture-value">unknown</span>
            </div>

            <div id="devUpdate" class="hide">
                <a class="changelog-wizard" href="#" data-translateid="text_view_change">Show changelog</a>
                <button class="btn btn-default update-wizard" data-toggle="modal" data-target="#switchWizardModal" data-translateid="text_updateFirmware">Update firmware</button>
            </div>
            
            <div id="phModuleMode">
                <span data-translateid="">Konfiguration</span>
                <span id="actuallyConfig">Kippschalter / zwei Wippen</span>
                <button class="btn btn-default btn-ph-config" data-toggle="modal" data-target="#phConfigModal">Konfigurieren</button>
            </div>

            <div id="lightingSwitchMode">
                <span data-translateid="th_mode">Modus</span>
                <span id="actuallyMode">zwei Gruppen</span>
                <button class="btn btn-default" data-btn-ev="BTN_LIGHTING_MODE_PRESSED">Modus wechseln</button>
            </div>
        </div>
    </div>

    <div class="modal" id="phConfigModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="mq-phone" data-dismiss="modal">
                        <svg width="20" height="20"><use transform="scale(0.8)" xlink:href="#back-icon-sm"/></svg>
                    </div>
                    <button type="button" class="close mq-desktop" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h3 class="modal-title" data-translateid="">Konfigurieren</h3>
                </div>
                <div class="modal-body">
                    <div>
                        <h4 data-translateid="" class="number-buttons">Verbauten Schaltertyp auswählen</h4>
                        <span class="ph-module-mode" data-mode="rocker">
                            <input type="radio" id="sp2" name="phmode" value="sp-2-pol">
                            <span class="checkmark"></span>
                            <label for="sr" data-translateid="txt_ph_rocker">Kippschalter</label>
                        </span>
                        <small data-translateid="txt_ph_rocker_info">Wippe verbleibt nach Loslassen in Position</small>
                        <span class="ph-module-mode" data-mode="pushbutton">
                            <input type="radio" id="sp1" name="phmode" value="sp-1-pol">
                            <span class="checkmark"></span>
                            <label for="sr" data-translateid="txt_ph_pushbutton">Taster</label>
                        </span>
                        <small data-translateid="txt_ph_pushbutton_info">Taste springt in ursprüngliche Position zurück</small>
                    </div>

                    <div>
                        <h4 data-translateid="" class="number-buttons" id="txtKeyNumber">Anzahl Wippen auswählen</h4>
                        <span class="ph-svg-box">
                            <div class="ph-module-num-btn" data-mode="single">
                                <span>
                                    <input type="radio" id="sp1" name="phnum" value="sp-1-pol">
                                    <span class="checkmark"></span>
                                </span>
                                <svg class="single-rocker"></svg>
                                <span class="ph-text txt-single-switch">eine Wippe</span>
                            </div>
                            <div class="ph-module-num-btn" data-mode="dual">
                                <span>
                                    <input type="radio" id="sp1" name="phnum" value="sp-1-pol">
                                    <span class="checkmark"></span>
                                </span>
                                <svg class="dual-rocker"></svg>
                                <span class="ph-text txt-dual-switch">zwei Wippen</span>
                            </div>
                        </span>
                        <small id="rockerInfo">
                            <span data-translateid="text_note"></span>
                            <span data-translateid="txt_rocker_note"></span>
                        </small>
                    </div>

                    <button type="submit" class="btn btn-primary mq-phone btn-ph-module-mode" data-dismiss="modal"><span data-translateid="">Übernehmen</span></button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><span data-translateid="btn_cancel">Beenden</span></button>
                    <button type="submit" class="btn btn-primary btn-ph-module-mode" data-dismiss="modal"><span data-translateid="">Übernehmen</span></button>
                </div>
            </div>
        </div>
    </div>
</script>