/*! phoscon-app 2024-10-07 */

export function initDetailsView(injectSwitchWizzardSvg,pageParams){let getSvgDevicePath=pageParams.constants.getSvgDevicePath||null,getSvgIconPath=pageParams.constants.getSvgIconPath||null;if(!getSvgDevicePath||!getSvgIconPath)throw new Error("getSvg function is missing, initDetailsView");return Backbone.View.extend({el:"#details",template:_.template(document.getElementById("switch-details-template").innerHTML),initialize:function(model){this.model=model;let id=this.model.get("id");app.session.swid=id,this.listenTo(this.model,"change",this.render),this.listenTo(this.model,"change",this.onChange),this.listenTo(app,"phModeChanged",this.setPhSvg),this.el.innerHTML=this.template(model),this.nameLabel=this.el.querySelector("h1 span"),this.vendorLabel=this.el.querySelector(".vendor"),this.swVLabel=this.el.querySelector(".swversion-label"),this.productLabel=this.el.querySelector(".product"),this.batteryLabel=this.el.querySelector(".battery .battery-content"),this.productExtraLabel=this.el.querySelector(".product + i"),this.liModusLabel=this.el.querySelector("#actuallyMode"),this.phModusLabel=this.el.querySelector("#actuallyConfig"),this.phModusButton=this.el.querySelector(".btn-ph-config");let iconPath=getSvgIconPath(this.model,"img/switches/","svgPathsSwitches"),iconImg=this.el.querySelector(".main-head > h1 > img"),detailPath=getSvgDevicePath(this.model,"img/switches/","svgPathsSwitches"),detailImg=this.el.querySelector("#detailImg");var d=app.devices.get(this.model.get("uniqueid")),btnMap=d?d.attributes:void 0;if("RDM001"===this.model.get("modelid")||"RDM004"===this.model.get("modelid")){let mode=this.model.get("config").devicemode;btnMap="dualpushbutton"===mode||"dualrocker"===mode?{buttons:{1:{name:"left button"},2:{name:"right button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1},2001:{action:"HOLD",button:2},2002:{action:"SHORT_RELEASE",button:2},2003:{action:"LONG_RELEASE",button:2}}}:{buttons:{1:{name:"middle button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1}}}}-1!==this.model.get("modelid").indexOf("lumi.remote.cagl")&&this.phModusButton.classList.add("hidden"),-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&(svg.setAttribute("class","svg-icon mq-desktop"),iconImg.replaceWith(svg))}).catch(console.log):(iconImg.setAttribute("src",iconPath),injectSwitchWizzardSvg([iconImg])),-1!==detailPath.indexOf("generic")&&btnMap?getGenericSwInteractive(btnMap).then(svg=>{if(svg){svg.setAttribute("id","detailImg"),svg.setAttribute("class","interactive"),(svg.querySelectorAll(".sw-target")||[]).forEach((target,idx)=>{let btn=Object.entries(btnMap.values).filter(([key,value])=>value.button==idx+1);btn=btn.map(b=>b[0]).join(),target.setAttribute("data-buttonEvent",btn)}),detailImg.replaceWith(svg)}}).catch(console.log):(detailPath&&-1!==detailPath.indexOf("#lutron-friends-of-hue")&&detailImg.classList.add("sw-extra-fill"),detailImg.setAttribute("src",detailPath),injectSwitchWizzardSvg([detailImg])),this.render(),this.show()},events:{"click .ph-module-mode":"changeInputChecked","click .ph-module-num-btn":"changeInputChecked","click .btn-ph-module-mode":"changePhModuleMode","click .btn-ph-config":"setPhModuleMode","click [data-btn-ev]:not(.disabled)":function(ev){var dataEv=ev.currentTarget.getAttribute("data-btn-ev");this.service.send(dataEv)}},onChange:function(model){if(1==_.size(model.changed)&&model.changed.lastupdated||model.changed.buttonevent){if(app.session.swid!==model.get("id"))return;let btnEvent=model.get("buttonevent");if(!btnEvent)return;btnEvent=btnEvent.toString();let detailImg=document.querySelector("#detailImg");if(!detailImg)return;let targets=detailImg.querySelectorAll(".sw-target")||[];setActiveTarget(targets,btnEvent)}},render:function(){if(this.model.get("id")!==app.session.swid)return;let state=this.el.querySelector(".state"),stateValue=state.querySelector(".state-value"),gestureValue=state.querySelector(".gesture-value");if(-1!==this.model.get("modelid").indexOf("cube")||-1!==this.model.get("modelid").indexOf("lumi.remote.cagl")){this.el.classList.add("state");let states=getXiaomiCubeState(this.model);if(!states)throw new Error("states are missing");stateValue.textContent=states.buttons.join(" / "),gestureValue.innerHTML=states.gestureVal,state.classList.remove("hide")}else stateValue.textContent="",state.classList.add("hide"),this.el.classList.remove("state");this.nameLabel.textContent!==this.model.get("name")&&(this.nameLabel.textContent=this.model.get("name")),this.batteryLabel.textContent.replace("%","")!=this.model.get("config").battery&&(this.batteryLabel.textContent=this.model.get("config").battery+"%");const product=this.model.get("product")||getDeviceProductName(this.model.attributes),productExtra=this.model.get("productextra")||"";var liModus=this.model.get("mode")||void 0;liModus=liModus&&1==liModus?translate("txt_sceneMode_big"):liModus&&2==liModus?translate("txt_groupMode_big"):translate("txt_tempMode_big");var phModus=this.model.get("config").devicemode||void 0;switch(phModus){case"dualpushbutton":phModus="Taster / zwei Wippen";break;case"singlepushbutton":phModus="Taster / eine Wippe";break;case"dualrocker":phModus="Kippschalter / zwei Wippen";break;case"singlerocker":phModus="Kippschalter / eine Wippe"}this.productLabel.textContent!==product&&(this.productLabel.textContent=product),this.productExtraLabel.textContent!==productExtra&&(this.productExtraLabel.textContent=productExtra),this.liModusLabel.textContent!==liModus&&(this.liModusLabel.textContent=liModus),this.phModusLabel.textContent!==phModus&&(this.phModusLabel.textContent=phModus);const vendor=this.model.get("vendor")||this.model.get("manufacturername");return-1!==["dresden elektronik"].indexOf(vendor)?this.el.querySelector(".version-ok").classList.remove("hide"):this.el.querySelector(".version-ok").classList.add("hide"),"Lighting Switch"==this.model.get("modelid")?this.el.classList.add("l-switch-mode"):this.el.classList.remove("l-switch-mode"),["swversion","battery","devicemode"].forEach(attr=>{if(this.model.get(attr)&&"unknown"!==this.model.get(attr)||this.model.get("config")[attr]&&"unknown"!==this.model.get("config")[attr]){if(this.el.classList.add(attr),this.swVLabel.textContent!==this.model.get("swversion")&&(this.swVLabel.textContent=this.model.get("swversion")),"devicemode"==attr){let btnMapDouble={buttons:{1:{name:"left button"},2:{name:"right button"}}},btnMapSingle={buttons:{1:{name:"middle button"}}};var elem=this.el.querySelector("svg.single-rocker"),elemD=this.el.querySelector("svg.dual-rocker");getGenericSwIcon(btnMapSingle).then(svg=>(svg&&(svg.setAttribute("data-mode","single"),svg.classList.add("single-rocker"),elem.replaceWith(svg)),getGenericSwIcon(btnMapDouble))).then(svg=>{svg&&(svg.setAttribute("data-mode","dual"),svg.classList.add("dual-rocker"),elemD.replaceWith(svg))}).catch(console.log)}}else this.el.classList.remove(attr)}),loadLanguage(),this},setPhSvg:function(){let btnMap,mode=this.model.get("config").devicemode,iconImg=this.el.querySelector(".main-head > h1 > svg"),detailImg=this.el.querySelector("#detailImg");btnMap="dualpushbutton"===mode||"dualrocker"===mode?{buttons:{1:{name:"left button"},2:{name:"right button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1},2001:{action:"HOLD",button:2},2002:{action:"SHORT_RELEASE",button:2},2003:{action:"LONG_RELEASE",button:2}}}:{buttons:{1:{name:"middle button"}},values:{1001:{action:"HOLD",button:1},1002:{action:"SHORT_RELEASE",button:1},1003:{action:"LONG_RELEASE",button:1}}},getGenericSwIcon(btnMap).then(svg=>{svg&&(svg.setAttribute("class","svg-icon mq-desktop"),iconImg.replaceWith(svg))}).catch(console.log),getGenericSwInteractive(btnMap).then(svg=>{if(svg){svg.setAttribute("id","detailImg"),svg.setAttribute("class","interactive"),(svg.querySelectorAll(".sw-target")||[]).forEach((target,idx)=>{let btn=Object.entries(btnMap.values).filter(([key,value])=>value.button==idx+1);btn=btn.map(b=>b[0]).join(),target.setAttribute("data-buttonEvent",btn)}),detailImg.replaceWith(svg)}}).catch(console.log)},setPhModuleMode:function(){let inputMode,svgMode,deviceMode=this.model.get("config").devicemode||"singlerocker";switch(deviceMode){case"singlerocker":svgMode="single",inputMode="rocker";break;case"dualrocker":svgMode="dual",inputMode="rocker";break;case"singlepushbutton":svgMode="single",inputMode="pushbutton";break;case"dualpushbutton":svgMode="dual",inputMode="pushbutton"}let elInput=this.el.querySelector("[data-mode="+inputMode+"]"),elSvg=this.el.querySelector("[data-mode="+svgMode+"]");elInput.querySelector("input").checked=!0,elSvg.querySelector("input").checked=!0,-1!==deviceMode.indexOf("pushbutton")?(this.el.querySelector("#txtKeyNumber").innerText=translate("txt_ph_pushbutton_head"),this.el.querySelector(".txt-single-switch").innerText=translate("txt_ph_pushbutton_1_button"),this.el.querySelector(".txt-dual-switch").innerText=translate("txt_ph_pushbutton_2_button")):-1!==deviceMode.indexOf("rocker")&&(this.el.querySelector("#txtKeyNumber").innerText=translate("txt_ph_rocker_head"),this.el.querySelector(".txt-single-switch").innerText=translate("txt_ph_rocker_1_button"),this.el.querySelector(".txt-dual-switch").innerText=translate("txt_ph_rocker_2_button"))},changeInputChecked:function(ev){let mode=ev.currentTarget.getAttribute("data-mode")||void 0;mode&&(this.el.querySelector('[data-mode="'+mode+'"] input').checked=!0)},changePhModuleMode:function(ev){let mode=[this.el.querySelector('input[name="phnum"]:checked'),this.el.querySelector('input[name="phmode"]:checked')].map(m=>m.closest("[data-mode]").getAttribute("data-mode")).join("");if(!mode)return;const sen=app.sensors.findWhere({mac:app.session.swid});if(!sen)return;const sid=sen.id,xhr=new XMLHttpRequest,url="//"+app.session.gw+"/api/"+app.apikey+"/sensors/"+sid+"/config";xhr.open("PUT",url,!0),xhr.setRequestHeader("Content-type","application/json; charset=utf-8"),xhr.setRequestHeader("Accept",apiversion),xhr.send(JSON.stringify({devicemode:mode})),xhr.onreadystatechange=(e=>{if(4==xhr.readyState){let res=xhr.responseText||"{}";res=JSON.parse(res),console.log(res),setTimeout(()=>{this.render(),app.trigger("phModeChanged",{model:this.model})},100)}})},show:function(){this.el.classList.remove("hide")},hide:function(){this.el.classList.add("hide")}})};function getXiaomiCubeState(model){let buttons=[],gestureVal=translate("fade_no");return app.sensors.where({mac:model.id}).forEach(sen=>{let st=sen.get("state")||{},btnEvent=st.buttonevent,gesture=st.gesture;if(!btnEvent)return;if("03"===sen.get("endpoint")){let deg=st.buttonevent/100;buttons.push(deg.toFixed(2)+"°")}else buttons.push(st.buttonevent);let change=sen.changed;if(!change.state||!change.state.gesture)return;if(!gesture)return;gestureVal=(gest=>({1:"txt_shake",2:"txt_drop",3:"txt_flip90",4:"txt_flip180",5:"txt_push",6:"txt_knock",7:"txt_rotate_cw",8:"txt_rotate_ccw"})[gest])(gesture),gestureVal=translate(gestureVal)}),{buttons:buttons,gestureVal:gestureVal}}const setActiveTarget=(targets,btnEvent)=>{targets.forEach(target=>{let targetBtnEv=target.getAttribute("data-buttonEvent");targetBtnEv&&-1!==targetBtnEv.indexOf(btnEvent)?(target.classList.add("active-target"),setTimeout(()=>{target.classList.remove("active-target")},800)):target.classList.remove("active-target")})};