function rgb2hsv () {
    var rr, gg, bb,
        r = arguments[0] / 255,
        g = arguments[1] / 255,
        b = arguments[2] / 255,
        h, s,
        v = Math.max(r, g, b),
        diff = v - Math.min(r, g, b),
        diffc = function(c){
            return (v - c) / 6 / diff + 1 / 2;
        };

    if (diff == 0) {
        h = s = 0;
    } else {
        s = diff / v;
        rr = diffc(r);
        gg = diffc(g);
        bb = diffc(b);

        if (r === v) {
            h = bb - gg;
        }else if (g === v) {
            h = (1 / 3) + rr - bb;
        }else if (b === v) {
            h = (2 / 3) + gg - rr;
        }
        if (h < 0) {
            h += 1;
        }else if (h > 1) {
            h -= 1;
        }
    }
    return {
        h: Math.round(h * 360),
        s: Math.round(s * 100),
        v: Math.round(v * 100)
    };
}

function sendLightColor(form, lid) {
	var r = form[0].value;
	var g = form[1].value;
	var b = form[2].value;

	var hmul = 182.00;
	var hsv = rgb2hsv(r,g,b);

	var hue = Math.round(hsv.h * hmul);
	var sat = Math.round(hsv.s * 2.55);
	var bri = Math.round(hsv.v * 2.55);

	// console.log(hsv);
	// console.log([ hue, sat, bri ]);

	out = { "on": true, "bri": bri, "hue": hue, "sat": sat, "transitiontime": 0 };

    $.ajax({
        url: '/api/' + apikey + '/lights/' + lid + '/state',
        type: 'PUT',
        cache: false,
        dataType: 'json',
        contentType: 'application/json; charset=utf-8',
        data: JSON.stringify(out),
        success: function(json) {
        	console.log(json);
            clearAlert();
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            default:
              showAlert('alert-error', '<b>Error!</b> Sending failed.');
              break;
            }
        },
        timeout: 10000
    });
}

function displayLights(lights) {
	var txt = "<ul>";

	for (var l in lights) {
		txt += '<li>';
		txt += '<form onsubmit="sendLightColor(this,' + l + ')">';
		txt += lights[l].name + '<br/>';
		txt += '<input type="range" name="r" min="0" max="255" value="0"><br/>';
		txt += '<input type="range" name="r" min="0" max="255" value="0"><br/>';
		txt += '<input type="range" name="r" min="0" max="255" value="0"><br/>';
		txt += '<input class="" type="submit"></input>';
		txt += '</form>';
		txt += '</li>';
	}

	txt += '</ul>';

	$('#lights').html(txt);

	// prevent default sending of form
	$('form').submit(function(e){
	    e.preventDefault();
	    return false;
	});
}

function loadLights() {
    $.ajax({
        url: '/api/' + apikey + '/lights',
        type: 'GET',
        cache: false,
        dataType: 'json',
        success: function(json) {
          clearAlert();
          displayLights(json);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            switch (jqXHR.status) {
            case 403:
              window.location.assign("/pwa/login.html");
              break;

            default:
              setTimeout(loadLights, 1000);
              showAlert('alert-error', '<b>Error!</b> Loading data, retry in one second ...');
              break;
            }
        },
        timeout: 10000
    });
}

$(document).ready(function() {
  lightControlInit();
  lightEditReset();
  loadLights();
});
