<!-- template for thermostat details -->
<script type="text/us-templ" id="thermostat-overview-template">
    <div class="main-head">
        <h1 data-translateid="text_connectedThermostats">Connected thermostats</h1>

        <div data-btn-ev="BTN_ADD_THERMOSTAT_PRESSED" data-modal="thermostatWizardModal" class="mq-phone">
            <svg width="18" height="18"><use transform="scale(0.7)" xlink:href="#add-icon-sm"/></svg>
        </div>
    </div>

    <div class="main-content">
        <div class="dev-table-hdr">
            <b><!-- head for icon --></b>
            <b data-translateid="th_name">Name</b>
            <b data-translateid="th_vendor">Vendor</b>
            <b data-translateid="th_product">Product</b>
            <b data-translateid="th_temperature">Temperature</b>
            <b data-translateid="th_heatsetpoint">Heatsetpoint</b>
        </div>

        <div id="devicesThermostatsContainer" class="dev-scroll-cont">
            <table class="table table-hover dev-table">
                <tbody id="thermostatTable"></tbody>
            </table>
        </div>
    </div>

    <div class="bottom-bar mq-desktop">
        <button data-btn-ev="BTN_ADD_THERMOSTAT_PRESSED" data-modal="thermostatWizardModal" class="btn btn-default" data-translateid="btn_newThermostat">Connect new thermostat</button>
    </div>
</script>

<!-- template for rending one row -->
<script type="text/us-templ" id="thermostat-item-template">
    <td style="display: flex;">
        <img src="#" data-svgInject="thermostatWizzardSvg" class="item-icon svg-icon" data-wiz-page="none"/>
    </td>
    <td class="name-col"><span class="name-val"><%- name %></span><span class="item-attr"></span></td>
    <td><%- manufacturername %></td>
    <td><%- producttype %></td>
    <td><%- state.temperature %></td>
    <td><%- config.heatsetpoint %></td>
    <!-- <td class="td_update">update verfügbar</td> -->
</script>