
var autoModeOn = false;
var lastActivity = 0;
var lastAutoLight = undefined;
// var maxBrightness = 1;
// var minBrightness = 0.1;
// var transitionTime = 3; // 3/10 sec

var autoParam = {
	triggerDelay: 60,
	changeInterval: 3,
	maxBrightness: 1,
	minBrightness: 0.1,
	transitionTime: 5 // 5/10 sec
};

function storeAutoMode(param) {
	localStorage.autoMode = JSON.stringify(param);
};

function modifyLight(light) {
	var out = {};
	var level = undefined;

    out.id = light.id;
    out.type = TYPE_LIGHT;
    out.automode = true;
    out.transitionTime = autoParam.transitionTime;

	level = Math.random();

	if (level > autoParam.maxBrightness) {
		level = autoParam.maxBrightness;
	}

	// force off sometimes
	if (out.level < 0.2) {
		out.on = false;
	}
	else {
		if (light.on === false) {
			out.on = true;
		}

		if (level < autoParam.minBrightness) {
			level = autoParam.minBrightness;
		}

		out.level = Math.floor(level * 255);

		if (light.hasColor) {
			out.hue = Math.random();
			out.sat = Math.floor(Math.random() * 254);
		}
	}

	// console.log(out);
	return out;
};

function getNextAutoLight() {
    if (lightArr.length === 1) {
        return lightArr[0].available ? 0 : undefined;
    }

    if (lightArr.length === 0) {
    	return undefined;
    }

    var maxRounds = 5;
    while (maxRounds > 0) {
    	maxRounds--;
	    var i = Math.floor(Math.random() * lightArr.length);

	    if ((i < lightArr.length) && (i !== lastAutoLight) && (lightArr[i].available)) {
	    	lastAutoLight = i;
	    	return i;
	    }
	}

	return undefined;
}

function autoModeTick() {
	if (!autoModeOn) {
		return;
	}

	var ap = autoParam;

	var triggerDelayEl = document.getElementById("autoUserTimeout");
	var changeIntervalEl = document.getElementById("autoChangeInterval");
	var minLevelEl = document.getElementById("autoMinBrightness");
	var maxLevelEl = document.getElementById("autoMaxBrightness");
	var transitionTimeEl = document.getElementById("autoTransitionTime");

	ap.triggerDelay = parseInt(triggerDelayEl.value);
	ap.changeInterval = parseInt(changeIntervalEl.value);
	ap.transitionTime = parseInt(transitionTimeEl.value);
	ap.minBrightness = parseFloat(minLevelEl.value);
	ap.maxBrightness = parseFloat(maxLevelEl.value);

	if (isNaN(ap.triggerDelay) || ap.triggerDelay < 5) {
		ap.triggerDelay = 60;
	}

	if (isNaN(ap.changeInterval) || ap.changeInterval < 1) {
		ap.changeInterval = 3;
	}

	if (isNaN(ap.transitionTime) || ap.transitionTime < 1 || ap.transitionTime > 1000) {
		ap.transitionTime = 10;
	}

	if (isNaN(ap.maxBrightness) || ap.maxBrightness < 0 || ap.maxBrightness > 1) {
		ap.maxBrightness = 0.4;
	}

	if (isNaN(ap.minBrightness) || ap.minBrightness < 0 || ap.minBrightness > 1) {
		ap.minBrightness = 0.4;
	}

	if ((lastActivity > ap.triggerDelay) && (lightArr.length !== 0)) {
		// choose a random light
		var i = undefined;
		try {
			i = getNextAutoLight();
		} catch (e) {
			console.log(e);
			return;
		}

		if (i !== undefined) {
			// console.log("automode tick " + lastActivity + " light[" + i + "]");

			if (i < lightArr.length) {
				var out = modifyLight(lightArr[i]);
				pushObjState(out);
			}
		}
		else {
			console.log("automode NOP");
		}	
	}

	setTimeout(autoModeTick, ap.changeInterval * 1000);
	storeAutoMode(ap);
};

function setLastActivity(delta) {
	lastActivity = delta;
};

function handleAutomode(checkbox) {
	if (checkbox.checked) {
		enableAutoMode();
	}
	else {
		disableAutoMode();
	}
};

function showAutoModeParams() {
	var triggerDelayEl = document.getElementById("autoUserTimeout");
	var changeIntervalEl = document.getElementById("autoChangeInterval");
	var minLevelEl = document.getElementById("autoMinBrightness");
	var maxLevelEl = document.getElementById("autoMaxBrightness");
	var transitionTimeEl = document.getElementById("autoTransitionTime");

	triggerDelayEl.value = autoParam.triggerDelay;
	changeIntervalEl.value = autoParam.changeInterval;
	minLevelEl.value = autoParam.minBrightness;
	maxLevelEl.value = autoParam.maxBrightness;
	transitionTimeEl.value = autoParam.transitionTime;
};

function initAutoMode() {
	if (localStorage.autoMode) {
		try {
			var p = JSON.parse(localStorage.autoMode);
			if (p.triggerDelay !== undefined && p.changeInterval !== undefined && p.minBrightness !== undefined && p.maxBrightness !== undefined && p.transitionTime !== undefined) {
				autoParam = p;
				showAutoModeParams();
				return true;	
			}
			
		} catch (e) {
			console.log(e);
		}
	}

	console.log("use automode default settings");

    storeAutoMode(autoParam);
    showAutoModeParams();
};

function enableAutoMode() {
	if (autoModeOn) {
		return;
	}

	autoModeOn = true;
	autoModeTick();
};

function disableAutoMode() {
	autoModeOn = false;
};