/*! phoscon-app 2024-10-07 */

import{Types,ApiStates,ButtonEvents}from"./state-constants.js";export const SettingsNetworkHandlerView=Backbone.View.extend({template:_.template(document.getElementById("settings-network-template").innerHTML),el:"#bodyContentSettings",initialize:function(){this.listenTo(app.wifi,"change",this.render),this.el.innerHTML=this.template(),document.querySelector("body").appendChild(this.el),this.wifiElem=this.el.querySelector("#wifiDiv"),app.subViewElement=this.wifiElem,this.apTab=this.el.querySelector("#tab-accesspoint"),this.clientTab=this.el.querySelector("#tab-client"),this.debugWindow=document.querySelector("#wifiStateText"),new accessPointView,new clientModeView,this.render(app.wifi)},render:function(model){try{const out=JSON.stringify(model.attributes,null,"\t");this.debugWindow.textContent=out}catch(e){console.log(e)}return this},events:{"click #tab-accesspoint":function(){app.stateEventHandler(ButtonEvents.TAB_AP_PRESSED)},"click #tab-client":function(){app.stateEventHandler(ButtonEvents.TAB_CLIENT_PRESSED)}},showAccessPoint:function(){this.wifiElem.setAttribute("data-wifi","accesspoint"),this.clientTab.classList.remove("active-menu"),this.apTab.classList.add("active-menu")},showClientMode:function(){this.wifiElem.setAttribute("data-wifi","client"),this.apTab.classList.remove("active-menu"),this.clientTab.classList.add("active-menu")}});var accessPointView=Backbone.View.extend({template:_.template(document.getElementById("access-point-template").innerHTML),el:"#accesspoint",initialize:function(){this.el.innerHTML=this.template(app.wifi),app.subViewElement.appendChild(this.el),new accessPointStatusView,app.apStateElement=this.el.querySelector("#apState"),this.render()},render:function(){return this}}),accessPointStatusView=Backbone.View.extend({template:_.template(document.getElementById("access-point-status-template").innerHTML),el:"#apStatus",initialize:function(){this.el.innerHTML=this.template(app.wifi),this.apStatusText=this.el.querySelector("#apStatusText"),this.svg=this.el.querySelector("#svgAp"),this.listenTo(app.wifi,"change:state",this.render,this),this.render()},render:function(){let wifi=app.wifi.get("wifi"),type=app.wifi.get("workingtype")||"";return type===Types.CLIENT||wifi===ApiStates.DEACTIVATED?this.apStatusText.innerHTML=translate("text_not_active"):type===Types.ACCESSPOINT||type===Types.ACCESSPOINT_BACKUP?this.apStatusText.innerHTML=translate("text_active"):wifi===ApiStates.NOT_CONFIGURED&&(app.wifi.get("type")===Types.accesspoint?this.apStatusText.innerHTML=translate("text_active_not_configured"):this.apStatusText.innerHTML=translate("text_not_active_not_configured")),this}}),clientModeView=Backbone.View.extend({template:_.template(document.getElementById("client-mode-template").innerHTML),el:"#client",initialize:function(){this.el.innerHTML=this.template(app.wifi),app.subViewElement.appendChild(this.el),new clientStatusView,app.clientStateElement=this.el.querySelector("#clientState")},render:function(){return this}}),clientStatusView=Backbone.View.extend({template:_.template(document.getElementById("client-mode-status-template").innerHTML),el:"#clientStatus",initialize:function(){this.el.innerHTML=this.template(app.wifi),this.clientStatusText=this.el.querySelector("#clientStatusText"),this.clientStatusTextActive=this.el.querySelector("#clientStatusTextActive"),this.cabelNodeElem=this.el.querySelector("#notCabelNode"),this.listenTo(app.wifi,"change:state",this.render,this),this.render()},render:function(){let wifi=app.wifi.get("wifi"),type=app.wifi.get("workingtype")||"",ip=app.wifi.get("wlan0"),wName=app.wifi.get("workingname");app.wifi.get("name");const ipLabel=this.el.querySelector("#statusTextIp");if(this.clientStatusText.classList.remove("status-activ-text"),this.clientStatusTextActive.style.display="none",this.clientStatusText.style.display="block",type!==Types.CLIENT||wifi===ApiStates.DEACTIVATED)this.clientStatusText.innerHTML=translate("text_not_active");else if(type===Types.CLIENT){if(null!==wName&&null===ip)return void(this.clientStatusText.innerHTML=translate("text_connection_lost"));ip=ip||"",ipLabel.textContent!=ip&&(ipLabel.textContent=ip),this.clientStatusTextActive.style.display="block",this.clientStatusText.style.display="none"}else wifi===ApiStates.NOT_CONFIGURED&&(app.wifi.get("type")===Types.CLIENT?this.clientStatusText.innerHTML=translate("text_active_not_configured"):this.clientStatusText.innerHTML=translate("text_not_active_not_configured"));return null===app.wifi.get("eth0")?this.cabelNodeElem.classList.remove("hidden"):this.cabelNodeElem.classList.add("hidden"),this}});