/*! phoscon-app 2024-10-07 */

export const getSwitchListView=c=>Backbone.View.extend({el:"#navigation",template:_.template(document.getElementById("navigation-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(),this.service=null,this.c=c,this.listView=new SwitchListView(this.c),this.changedBox=this.el.querySelector("#changedBox")},events:{"click [data-btn-ev]:not(.disabled):not(.switch)":function(ev){let sendEv=ev.currentTarget.getAttribute("data-btn-ev");this.service&&sendEv&&this.service.send(sendEv)}},show:function(){this.el.parentNode.classList.add("navigation")},hide:function(){this.el.parentNode.classList.remove("navigation")},showSaveDialog:function(){this.changedBox.classList.add("show-box"),screenMax(SCREEN_MAX_WIDTH_PHONE_LANDSCAPE)&&isThisPortrait()&&this.changedBox.querySelector(".btn-save").click()},hideSaveDialog:function(){this.changedBox.classList.remove("show-box")},getFirstSwid:function(){let v=this.listView.views[0];return v?v.el.getAttribute("data-swid"):null}});const SwitchItemView=Backbone.View.extend({tagName:"li",className:"switch list-group-item",template:_.template(document.getElementById("switch-item-template").innerHTML),initialize:function(){this.el.innerHTML=this.template(this.model.attributes),this.el.setAttribute("data-swid",this.model.get("id")),this.el.setAttribute("data-btn-ev","SW_PRESSED"),this.listenTo(this.model,"change",this.render),this.listenTo(this.model,"destroy",this.remove),this.icon=this.el.querySelector(".item-icon"),this.name=this.el.querySelector(".item-name")},render:function(){let iconPath=this.c.getSvgIconPath(this.model,"img/switches/","svgPathsSwitches");var d=app.devices.get(this.model.get("uniqueid")),btnMap=d?d.attributes:void 0;if("RDM001"===this.model.get("modelid")||"RDM004"===this.model.get("modelid")){let mode=this.model.get("config").devicemode;btnMap="dualpushbutton"===mode||"dualrocker"===mode?{buttons:{1:{name:"left button"},2:{name:"right button"}}}:{buttons:{1:{name:"middle button"}}}}return-1!==iconPath.indexOf("generic")&&btnMap?getGenericSwIcon(btnMap).then(svg=>{svg&&this.icon.replaceWith(svg)}).catch(console.log):(this.icon.setAttribute("src",iconPath),this.c.injectSvg([this.icon])),this.model.get("name")!==this.name.innerHTML&&(this.name.innerHTML=this.model.get("name"),app.trigger("swModelChanged",{model:this.model})),this}}),SwitchListView=Backbone.View.extend({el:"#switchNavList",initialize:function(c){this.c=c,this.service=null,this.views=[],this.body=document.querySelector("body"),this.body.classList.add("empty"),this.listenTo(app.resourcelinks,"add",this.addSw),this.listenTo(app.resourcelinks,"remove",this.removeSw),this.listenTo(app,"swToGroupMode",this.renderGroupMode),app.resourcelinks.models.forEach(rl=>{let classid=rl.get("classid");!classid||classid<c.SW_CLASSID_MIN||classid>c.SW_CLASSID_MAX||this.addSw(rl)}),app.switches.forEach(sw=>{sw.get("config").group&&hasConfigGroup(sw,app.session.gid)&&this.renderGroupMode(sw)})},events:{"click [data-btn-ev]:not(.disabled)":function(ev){let sendEv=ev.currentTarget.getAttribute("data-btn-ev"),swid=ev.currentTarget.getAttribute("data-swid")||void 0;this.service&&sendEv&&this.service.send({type:sendEv,swid:swid})}},renderGroupMode:function(model){let view=this.views.find(v=>v.model===model);view||((view=new SwitchItemView({model:model})).c=this.c,this.el.appendChild(view.render().el),this.views.push(view),app.trigger("switchViewAdded",{model:this.model}),this.views.length>0&&this.body.classList.remove("empty"))},addSw:function(rl){checkResourcelink(rl,this.c).then(model=>{let view=this.views.find(v=>v.model===model);view||((view=new SwitchItemView({model:model})).c=this.c,this.el.appendChild(view.render().el),this.views.push(view),app.trigger("switchViewAdded",{model:this.model}),this.views.length>0&&this.body.classList.remove("empty"))}).catch(err=>console.log(err))},removeSw:function(rl){0==this.views.length&&(this.body.classList.add("empty"),app.trigger("switchViewRemoved",{model:this.model}))},getFirstView:function(){return this.views[0]},setSwitchActive:function(swid){swid&&this.views.forEach(v=>{v.el.getAttribute("data-swid")==swid?v.el.classList.add("active-sw"):v.el.classList.remove("active-sw")})}});function checkResourcelink(rl,c){return new Promise((resolve,reject)=>{let classid=rl.get("classid");classid||reject("no classid"),(classid<c.SW_CLASSID_MIN||classid>c.SW_CLASSID_MAX)&&reject("classid not between min and max");let links=rl.get("links")||[],gid=getRlGroupId(links);gid!=app.session.gid&&0!=gid&&reject("gid not active group"),getRlSensorIds(links).then(sIds=>{sIds.forEach(id=>{let sn=getSensorFromId(id);sn&&-1===sn.get("type").indexOf("CLIP")||reject("clipSensor");let sw=app.switches.get(sn.get("mac"));sw||reject("sw not found"),resolve(sw)})}).catch(err=>{reject("sw not found")})})}function getRlGroupId(links){return links.find(l=>-1!==l.indexOf("/groups/")).split("/")[2]||void 0}function getRlSensorIds(links){return new Promise((resolve,reject)=>{resolve(links.filter(l=>-1!==l.indexOf("/sensors/")).map(item=>item.split("/")[2]))})}function getSensorFromId(id){return app.sensors.find(s=>s.get("id")===id||s.get("uniqueid")===id)}function hasConfigGroup(sw,gid){if(sw.attributes.config&&sw.attributes.config.group){return-1!==(sw.get("config").group||"").split(",").indexOf(gid)}return!1}